/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.pixex.output;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.pixex.aggregators.AggregatorStrategy;
import org.esa.beam.pixex.output.RasterNamesFactory;

public class PixExRasterNamesFactory
implements RasterNamesFactory {
    private final boolean exportBands;
    private final boolean exportTiePoints;
    private final boolean exportMasks;
    private final Map<String, String[]> rasterNamesMap;
    private final AggregatorStrategy aggregatorStrategy;

    public PixExRasterNamesFactory(boolean exportBands, boolean exportTiePoints, boolean exportMasks, AggregatorStrategy aggregatorStrategy) {
        this.exportBands = exportBands;
        this.exportTiePoints = exportTiePoints;
        this.exportMasks = exportMasks;
        this.rasterNamesMap = new HashMap<String, String[]>(37);
        this.aggregatorStrategy = aggregatorStrategy;
    }

    @Override
    public String[] getRasterNames(Product product) {
        String productType = product.getProductType();
        if (this.rasterNamesMap.containsKey(productType)) {
            return this.rasterNamesMap.get(productType);
        }
        String[] rasterNames = this.extractRasterNames(product, this.aggregatorStrategy);
        this.rasterNamesMap.put(productType, rasterNames);
        return rasterNames;
    }

    @Override
    public String[] getUniqueRasterNames(Product product) {
        return this.extractRasterNames(product, null);
    }

    private String[] extractRasterNames(Product product, AggregatorStrategy strategy) {
        ArrayList allNamesList = new ArrayList();
        if (this.exportBands) {
            Collections.addAll(allNamesList, product.getBandNames());
        }
        if (this.exportTiePoints) {
            Collections.addAll(allNamesList, product.getTiePointGridNames());
        }
        if (this.exportMasks) {
            Collections.addAll(allNamesList, product.getMaskGroup().getNodeNames());
        }
        if (strategy == null) {
            return allNamesList.toArray(new String[allNamesList.size()]);
        }
        String[] allNamesWithSuffixes = new String[allNamesList.size() * strategy.getValueCount()];
        int index = 0;
        for (String name : allNamesList) {
            for (String suffix : this.aggregatorStrategy.getSuffixes()) {
                allNamesWithSuffixes[index++] = name + "_" + suffix;
            }
        }
        return allNamesWithSuffixes;
    }
}

