/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.pixex.visat;

import com.vividsolutions.jts.geom.Point;
import java.util.Date;
import org.esa.beam.framework.datamodel.PinDescriptor;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.PlacemarkDescriptor;
import org.esa.beam.visat.toolviews.placemark.AbstractPlacemarkTableModel;

class CoordinateTableModel
extends AbstractPlacemarkTableModel {
    CoordinateTableModel() {
        super((PlacemarkDescriptor)PinDescriptor.getInstance(), null, null, null);
    }

    public String[] getStandardColumnNames() {
        return new String[]{"Name", "Latitude", "Longitude", "DateTime (UTC)"};
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: 
            case 2: {
                return Float.class;
            }
            case 3: {
                return Date.class;
            }
        }
        throw new IllegalArgumentException(String.format("Invalid columnIndex = %d", columnIndex));
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.placemarkHasGeoPos(rowIndex);
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Placemark placemark = this.getPlacemarkAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                placemark.setName((String)value);
                break;
            }
            case 1: {
                this.setGeoPosLat(value, placemark);
                break;
            }
            case 2: {
                this.setGeoPosLon(value, placemark);
                break;
            }
            case 3: {
                this.setDateTime((Date)value, placemark);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid columnIndex = %d", columnIndex));
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    protected void setDateTime(Date value, Placemark placemark) {
        placemark.getFeature().setAttribute("dateTime", (Object)value);
    }

    protected Object getStandardColumnValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getPlacemarkAt(rowIndex).getName();
            }
            case 1: {
                if (this.placemarkHasGeoPos(rowIndex)) {
                    return Float.valueOf(this.getPlacemarkAt(rowIndex).getGeoPos().getLat());
                }
                return ((Point)this.getPlacemarkAt(rowIndex).getFeature().getDefaultGeometry()).getY();
            }
            case 2: {
                if (this.placemarkHasGeoPos(rowIndex)) {
                    return Float.valueOf(this.getPlacemarkAt(rowIndex).getGeoPos().getLon());
                }
                return ((Point)this.getPlacemarkAt(rowIndex).getFeature().getDefaultGeometry()).getX();
            }
            case 3: {
                return this.getPlacemarkAt(rowIndex).getFeature().getAttribute("dateTime");
            }
        }
        throw new IllegalArgumentException(String.format("Invalid columnIndex = %d", columnIndex));
    }

    private boolean placemarkHasGeoPos(int rowIndex) {
        return this.getPlacemarkAt(rowIndex).getGeoPos() != null;
    }
}

