/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.pixex.visat;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import com.jidesoft.swing.FolderChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.product.SourceProductList;
import org.esa.beam.util.SystemUtils;

class PixelExtractionIOForm {
    static final String LAST_OPEN_INPUT_DIR = "beam.petOp.lastOpenInputDir";
    static final String LAST_OPEN_OUTPUT_DIR = "beam.petOp.lastOpenOutputDir";
    static final String LAST_OPEN_FORMAT = "beam.petOp.lastOpenFormat";
    private final AppContext appContext;
    private final JPanel panel;
    private final JTextField outputDirTextField;
    private final PropertyContainer container;
    private final BindingContext context;
    private final SourceProductList sourceProductList;

    PixelExtractionIOForm(AppContext appContext, PropertyContainer container, ListDataListener changeListener) {
        this.appContext = appContext;
        this.container = container;
        this.context = new BindingContext((PropertySet)container);
        TableLayout tableLayout = new TableLayout(3);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setColumnPadding(0, new Insets(3, 4, 4, 4));
        tableLayout.setTableWeightX(Double.valueOf(0.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        tableLayout.setColumnWeightX(1, Double.valueOf(1.0));
        tableLayout.setCellWeightY(0, 1, Double.valueOf(1.0));
        tableLayout.setCellFill(0, 1, TableLayout.Fill.BOTH);
        tableLayout.setCellColspan(3, 1, Integer.valueOf(2));
        this.panel = new JPanel((LayoutManager)tableLayout);
        this.sourceProductList = new SourceProductList(appContext);
        this.sourceProductList.setLastOpenedFormat(LAST_OPEN_FORMAT);
        this.sourceProductList.setLastOpenInputDir(LAST_OPEN_INPUT_DIR);
        this.sourceProductList.addChangeListener(changeListener);
        this.sourceProductList.setXAxis(true);
        this.context.bind("sourceProductPaths", (ComponentAdapter)this.sourceProductList);
        JComponent[] components = this.sourceProductList.getComponents();
        this.panel.add(new JLabel("Source Paths:"));
        this.panel.add(components[0]);
        this.panel.add(components[1]);
        this.panel.add(new JLabel("Time extraction:"));
        this.panel.add(new TimeExtractionPane(container));
        this.panel.add(new JLabel(""));
        JLabel outputDirLabel = new JLabel("Output directory:");
        this.panel.add(outputDirLabel);
        this.outputDirTextField = new JTextField();
        this.outputDirTextField.setEditable(false);
        this.outputDirTextField.setPreferredSize(new Dimension(80, this.outputDirTextField.getPreferredSize().height));
        String path = this.getDefaultOutputPath(appContext);
        this.setOutputDirPath(path);
        this.panel.add(this.outputDirTextField);
        AbstractButton outputDirChooserButton = this.createOutputDirChooserButton(container.getProperty("outputDir"));
        this.panel.add(outputDirChooserButton);
        JLabel filePrefixLabel = new JLabel("File prefix:");
        JTextField filePrefixField = this.createFilePrefixField(container.getProperty("outputFilePrefix"));
        this.panel.add(filePrefixLabel);
        this.panel.add(filePrefixField);
    }

    JPanel getPanel() {
        return this.panel;
    }

    void clear() {
        this.sourceProductList.clear();
        this.setOutputDirPath("");
    }

    void addProduct(Product selectedProduct) {
        this.sourceProductList.addProduct(selectedProduct);
    }

    Product[] getSourceProducts() {
        return this.sourceProductList.getSourceProducts();
    }

    private String getDefaultOutputPath(AppContext appContext) {
        String path;
        Property dirProperty = this.container.getProperty("outputDir");
        String lastDir = appContext.getPreferences().getPropertyString(LAST_OPEN_OUTPUT_DIR, ".");
        try {
            path = new File(lastDir).getCanonicalPath();
        }
        catch (IOException ignored) {
            path = SystemUtils.getUserHomeDir().getPath();
        }
        try {
            dirProperty.setValue((Object)new File(path));
        }
        catch (ValidationException ignore) {
            // empty catch block
        }
        return path;
    }

    private void setOutputDirPath(String path) {
        this.outputDirTextField.setText(path);
        this.outputDirTextField.setToolTipText(path);
    }

    private AbstractButton createOutputDirChooserButton(final Property outputFileProperty) {
        JButton button = new JButton("...");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FolderChooser folderChooser = new FolderChooser();
                folderChooser.setCurrentDirectory(new File(PixelExtractionIOForm.this.getDefaultOutputPath(PixelExtractionIOForm.this.appContext)));
                folderChooser.setDialogTitle("Select output directory");
                folderChooser.setMultiSelectionEnabled(false);
                int result = folderChooser.showDialog((Component)PixelExtractionIOForm.this.appContext.getApplicationWindow(), "Select");
                if (result != 0) {
                    return;
                }
                File selectedFile = folderChooser.getSelectedFile();
                PixelExtractionIOForm.this.setOutputDirPath(selectedFile.getAbsolutePath());
                try {
                    outputFileProperty.setValue((Object)selectedFile);
                    PixelExtractionIOForm.this.appContext.getPreferences().setPropertyString(PixelExtractionIOForm.LAST_OPEN_OUTPUT_DIR, selectedFile.getAbsolutePath());
                }
                catch (ValidationException ve) {
                    PixelExtractionIOForm.this.appContext.handleError("Invalid input path", (Throwable)ve);
                }
            }
        });
        return button;
    }

    private JTextField createFilePrefixField(Property property) {
        return this.createTextFieldBinding(property);
    }

    private JTextField createTextFieldBinding(Property property) {
        JTextField textField = new JTextField();
        this.context.bind(property.getName(), textField);
        return textField;
    }

    private JCheckBox createCheckBoxBinding(Property property) {
        JCheckBox checkBox = new JCheckBox(property.getDescriptor().getDisplayName());
        this.context.bind(property.getName(), checkBox);
        return checkBox;
    }

    private class TimeExtractionPane
    extends JPanel {
        public TimeExtractionPane(PropertyContainer container) {
            super(new BorderLayout(0, 5));
            final JCheckBox extractTime = PixelExtractionIOForm.this.createCheckBoxBinding(container.getProperty("extractTimeFromFilename"));
            Property datePattern = container.getProperty("dateInterpretationPattern");
            String dateDN = datePattern.getDescriptor().getDisplayName();
            JPanel datePanel = new JPanel(new BorderLayout(0, 2));
            final JLabel dateLabel = new JLabel(dateDN + ":");
            final JTextField datePatternField = PixelExtractionIOForm.this.createTextFieldBinding(datePattern);
            dateLabel.setEnabled(false);
            datePatternField.setEnabled(false);
            datePanel.add((Component)dateLabel, "North");
            datePanel.add((Component)datePatternField, "Center");
            Property filenamePattern = container.getProperty("filenameInterpretationPattern");
            String filenameDN = filenamePattern.getDescriptor().getDisplayName();
            JPanel filenamePanel = new JPanel(new BorderLayout(0, 2));
            final JLabel filenameLabel = new JLabel(filenameDN + ":");
            final JTextField filenamePatternField = PixelExtractionIOForm.this.createTextFieldBinding(filenamePattern);
            filenameLabel.setEnabled(false);
            filenamePatternField.setEnabled(false);
            filenamePanel.add((Component)filenameLabel, "North");
            filenamePanel.add((Component)filenamePatternField, "Center");
            extractTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean selected = extractTime.isSelected();
                    dateLabel.setEnabled(selected);
                    datePatternField.setEnabled(selected);
                    filenameLabel.setEnabled(selected);
                    filenamePatternField.setEnabled(selected);
                }
            });
            this.add((Component)extractTime, "North");
            this.add((Component)datePanel, "Center");
            this.add((Component)filenamePanel, "South");
        }
    }
}

