/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.pixex.visat;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.Enablement;
import com.jidesoft.combobox.DateModel;
import com.jidesoft.combobox.DefaultDateModel;
import com.jidesoft.grid.DateCellEditor;
import com.vividsolutions.jts.geom.Point;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.PlacemarkDescriptor;
import org.esa.beam.framework.datamodel.PlacemarkGroup;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.DecimalTableCellRenderer;
import org.esa.beam.framework.ui.FloatCellEditor;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.product.ProductExpressionPane;
import org.esa.beam.framework.ui.tool.ToolButtonFactory;
import org.esa.beam.pixex.Coordinate;
import org.esa.beam.pixex.PixExOp;
import org.esa.beam.pixex.visat.AddCoordinateAction;
import org.esa.beam.pixex.visat.AddCsvFileAction;
import org.esa.beam.pixex.visat.AddPlacemarkFileAction;
import org.esa.beam.pixex.visat.CoordinateTableModel;
import org.esa.beam.util.PropertyMap;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.jfree.ui.DateCellRenderer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;

class PixelExtractionParametersForm {
    private static final ImageIcon ADD_ICON = UIUtils.loadImageIcon((String)"icons/Plus24.gif");
    private static final ImageIcon REMOVE_ICON = UIUtils.loadImageIcon((String)"icons/Minus24.gif");
    private JPanel mainPanel;
    private JLabel windowLabel;
    private JSpinner windowSpinner;
    private final AppContext appContext;
    private final CoordinateTableModel coordinateTableModel;
    private JButton editExpressionButton;
    private JCheckBox useExpressionCheckBox;
    private JTextArea expressionArea;
    private JRadioButton expressionAsFilterButton;
    private JRadioButton exportExpressionResultButton;
    private Product activeProduct;
    private JLabel expressionNoteLabel;
    private JSpinner timeSpinner;
    private JComboBox timeUnitComboBox;
    private JCheckBox includeOriginalInputBox;
    private Enablement aggregationEneblement;
    private JCheckBox timeBox;

    PixelExtractionParametersForm(AppContext appContext, PropertyContainer container) {
        this.appContext = appContext;
        this.coordinateTableModel = new CoordinateTableModel();
        this.createUi(container);
        this.updateUi();
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coordinates = new Coordinate[this.coordinateTableModel.getRowCount()];
        for (int i = 0; i < this.coordinateTableModel.getRowCount(); ++i) {
            Placemark placemark = this.coordinateTableModel.getPlacemarkAt(i);
            SimpleFeature feature = placemark.getFeature();
            Date dateTime = (Date)feature.getAttribute("dateTime");
            Coordinate.OriginalValue[] originalValues = PixExOp.getOriginalValues(feature);
            if (placemark.getGeoPos() == null) {
                Point point = (Point)feature.getDefaultGeometry();
                coordinates[i] = new Coordinate(placemark.getName(), Float.valueOf((float)point.getY()), Float.valueOf((float)point.getX()), dateTime, originalValues);
                continue;
            }
            coordinates[i] = new Coordinate(placemark.getName(), Float.valueOf(placemark.getGeoPos().getLat()), Float.valueOf(placemark.getGeoPos().getLon()), dateTime, originalValues);
        }
        return coordinates;
    }

    void setCoordinates(Coordinate[] coordinates) {
        Placemark[] toDelete;
        for (Placemark placemark : toDelete = this.coordinateTableModel.getPlacemarks()) {
            this.coordinateTableModel.removePlacemark(placemark);
        }
        PlacemarkDescriptor placemarkDescriptor = this.coordinateTableModel.getPlacemarkDescriptor();
        SimpleFeatureType placemarkFT = placemarkDescriptor.getBaseFeatureType();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(placemarkFT);
        AttributeTypeImpl at = new AttributeTypeImpl((Name)new NameImpl("label"), String.class, false, false, null, null, null);
        for (Coordinate coordinate : coordinates) {
            ArrayList<AttributeDescriptorImpl> attributeDescriptors = new ArrayList<AttributeDescriptorImpl>();
            ArrayList<String> attributeValues = new ArrayList<String>();
            for (Coordinate.OriginalValue originalValue : coordinate.getOriginalValues()) {
                attributeDescriptors.add(new AttributeDescriptorImpl((AttributeType)at, (Name)new NameImpl(originalValue.getVariableName()), 0, 1, false, null));
                attributeValues.add(originalValue.getValue());
            }
            placemarkFT.getUserData().put("originalAttributeDescriptors", attributeDescriptors);
            int attributeCount = placemarkFT.getAttributeCount();
            SimpleFeature f = fb.buildFeature(coordinate.getName(), new Object[attributeCount]);
            f.getUserData().put("originalAttributes", attributeValues);
            f.setAttribute("dateTime", (Object)coordinate.getDateTime());
            Placemark placemark = placemarkDescriptor.createPlacemark(f);
            placemark.setGeoPos(new GeoPos(coordinate.getLat().floatValue(), coordinate.getLon().floatValue()));
            placemark.setName(coordinate.getName());
            this.coordinateTableModel.addPlacemark(placemark);
        }
    }

    public String getExpression() {
        if (this.useExpressionCheckBox.isSelected()) {
            return this.expressionArea.getText();
        }
        return null;
    }

    void setExpression(String expression) {
        this.useExpressionCheckBox.setSelected(expression != null);
        this.expressionArea.setText(expression);
    }

    public String getAllowedTimeDifference() {
        return this.createAllowedTimeDifferenceString();
    }

    void setAllowedTimeDifference(String timeDifference) {
        if (timeDifference != null && !timeDifference.isEmpty()) {
            this.timeBox.setSelected(true);
            String timePart = timeDifference.substring(0, timeDifference.length() - 1);
            this.timeSpinner.setValue(Integer.parseInt(timePart));
            char lastChar = timeDifference.charAt(timeDifference.length() - 1);
            int index = 0;
            switch (lastChar) {
                case 'D': {
                    index = 0;
                    break;
                }
                case 'H': {
                    index = 1;
                    break;
                }
                case 'M': {
                    index = 2;
                }
            }
            this.timeUnitComboBox.setSelectedIndex(index);
        } else {
            this.timeBox.setSelected(false);
        }
    }

    public boolean isExportExpressionResultSelected() {
        return this.exportExpressionResultButton.isSelected();
    }

    void setExportExpressionResultSelected(boolean isSelected) {
        this.exportExpressionResultButton.setSelected(isSelected);
    }

    private void createUi(PropertyContainer container) {
        Component[] timeDeltaComponents;
        TableLayout tableLayout = new TableLayout(3);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setTableWeightX(Double.valueOf(0.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        tableLayout.setColumnWeightX(1, Double.valueOf(1.0));
        tableLayout.setCellFill(0, 1, TableLayout.Fill.BOTH);
        tableLayout.setCellWeightY(0, 1, Double.valueOf(7.0));
        tableLayout.setCellPadding(6, 0, new Insets(8, 4, 4, 4));
        tableLayout.setCellPadding(6, 1, new Insets(0, 0, 0, 0));
        tableLayout.setCellWeightX(6, 1, Double.valueOf(1.0));
        tableLayout.setCellWeightY(6, 1, Double.valueOf(3.0));
        tableLayout.setCellFill(6, 1, TableLayout.Fill.BOTH);
        tableLayout.setCellPadding(7, 0, new Insets(8, 4, 4, 4));
        tableLayout.setCellPadding(7, 1, new Insets(0, 0, 0, 0));
        tableLayout.setCellPadding(8, 0, new Insets(8, 4, 4, 4));
        tableLayout.setCellPadding(8, 1, new Insets(0, 0, 0, 0));
        tableLayout.setCellPadding(9, 0, new Insets(8, 4, 4, 4));
        tableLayout.setCellPadding(9, 1, new Insets(0, 0, 0, 0));
        this.mainPanel = new JPanel((LayoutManager)tableLayout);
        this.mainPanel.add(new JLabel("Coordinates:"));
        JComponent[] coordinatesComponents = this.createCoordinatesComponents();
        this.mainPanel.add(coordinatesComponents[0]);
        this.mainPanel.add(coordinatesComponents[1]);
        for (Component timeDeltaComponent : timeDeltaComponents = this.createTimeDeltaComponents(tableLayout)) {
            this.mainPanel.add(timeDeltaComponent);
        }
        this.coordinateTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                PixelExtractionParametersForm.this.updateIncludeOriginalInputBox();
            }
        });
        BindingContext bindingContext = new BindingContext((PropertySet)container);
        this.mainPanel.add(new JLabel("Export:"));
        this.mainPanel.add(this.createExportPanel(bindingContext));
        this.mainPanel.add(tableLayout.createHorizontalSpacer());
        this.mainPanel.add(new JLabel("Window size:"));
        this.windowSpinner = this.createWindowSizeEditor(bindingContext);
        this.windowLabel = new JLabel();
        this.windowLabel.setHorizontalAlignment(0);
        this.windowSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PixelExtractionParametersForm.this.handleWindowSpinnerChange();
            }
        });
        this.mainPanel.add(this.windowSpinner);
        this.mainPanel.add(this.windowLabel);
        this.mainPanel.add(new JLabel("Pixel value aggregation method:"));
        JComboBox aggregationStrategyChooser = new JComboBox();
        bindingContext.bind("aggregatorStrategyType", aggregationStrategyChooser);
        this.aggregationEneblement = bindingContext.bindEnabledState("aggregatorStrategyType", true, new Enablement.Condition(){

            public boolean evaluate(BindingContext bindingContext) {
                Integer windowSize = (Integer)PixelExtractionParametersForm.this.windowSpinner.getValue();
                return windowSize > 1;
            }
        });
        this.mainPanel.add(aggregationStrategyChooser);
        this.mainPanel.add(tableLayout.createVerticalSpacer());
        this.mainPanel.add(new JLabel("Expression:"));
        this.mainPanel.add(this.createExpressionPanel(bindingContext));
        this.mainPanel.add(tableLayout.createHorizontalSpacer());
        this.mainPanel.add(new JLabel("Sub-scenes:"));
        this.mainPanel.add(this.createSubSceneExportPanel(bindingContext));
        this.mainPanel.add(tableLayout.createHorizontalSpacer());
        this.mainPanel.add(new JLabel("Google Earth export:"));
        this.mainPanel.add(this.createKmzExportPanel(bindingContext));
        this.mainPanel.add(tableLayout.createHorizontalSpacer());
        this.mainPanel.add(new JLabel("Match with original input:"));
        this.mainPanel.add(this.createIncludeOriginalInputBox(bindingContext));
        this.mainPanel.add(tableLayout.createHorizontalSpacer());
    }

    private JComponent createIncludeOriginalInputBox(BindingContext bindingContext) {
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        JPanel panel = new JPanel((LayoutManager)tableLayout);
        this.includeOriginalInputBox = new JCheckBox("Include original input");
        bindingContext.bind("includeOriginalInput", this.includeOriginalInputBox);
        panel.add(this.includeOriginalInputBox);
        this.updateIncludeOriginalInputBox();
        return panel;
    }

    private Component createKmzExportPanel(BindingContext bindingContext) {
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        JPanel panel = new JPanel((LayoutManager)tableLayout);
        JCheckBox exportKmzBox = new JCheckBox("Export output coordinates to Google Earth (KMZ)");
        bindingContext.bind("exportKmz", exportKmzBox);
        panel.add(exportKmzBox);
        return panel;
    }

    private JPanel createSubSceneExportPanel(BindingContext bindingContext) {
        TableLayout tableLayout = new TableLayout(4);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableWeightX(Double.valueOf(0.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        tableLayout.setColumnWeightX(1, Double.valueOf(0.3));
        tableLayout.setColumnWeightX(3, Double.valueOf(1.0));
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        JPanel exportPanel = new JPanel((LayoutManager)tableLayout);
        JCheckBox exportSubScenesCheckBox = new JCheckBox("Enable export");
        JLabel borderSizeLabel = new JLabel("Border size:");
        JTextField borderSizeTextField = new JTextField();
        borderSizeTextField.setHorizontalAlignment(4);
        bindingContext.bind("exportSubScenes", exportSubScenesCheckBox);
        bindingContext.bind("subSceneBorderSize", borderSizeTextField);
        bindingContext.bindEnabledState("subSceneBorderSize", false, "exportSubScenes", (Object)false);
        exportPanel.add(exportSubScenesCheckBox);
        exportPanel.add(new JLabel());
        exportPanel.add(borderSizeLabel);
        exportPanel.add(borderSizeTextField);
        return exportPanel;
    }

    private Component[] createTimeDeltaComponents(TableLayout tableLayout) {
        JLabel boxLabel = new JLabel("Allowed time difference:");
        this.timeBox = new JCheckBox("Use time difference constraint");
        Component horizontalSpacer = tableLayout.createHorizontalSpacer();
        Component horizontalSpacer2 = tableLayout.createHorizontalSpacer();
        this.timeSpinner = new JSpinner(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.timeSpinner.setEnabled(false);
        this.timeUnitComboBox = new JComboBox<String>(new String[]{"Day(s)", "Hour(s)", "Minute(s)"});
        this.timeUnitComboBox.setEnabled(false);
        this.timeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PixelExtractionParametersForm.this.timeSpinner.setEnabled(PixelExtractionParametersForm.this.timeBox.isSelected());
                PixelExtractionParametersForm.this.timeUnitComboBox.setEnabled(PixelExtractionParametersForm.this.timeBox.isSelected());
            }
        });
        return new Component[]{boxLabel, this.timeBox, horizontalSpacer, horizontalSpacer2, this.timeSpinner, this.timeUnitComboBox};
    }

    private String createAllowedTimeDifferenceString() {
        return this.timeBox.isSelected() ? String.valueOf(this.timeSpinner.getValue()) + this.timeUnitComboBox.getSelectedItem().toString().charAt(0) : "";
    }

    void updateUi() {
        this.handleWindowSpinnerChange();
        this.updateExpressionComponents();
        this.updateIncludeOriginalInputBox();
    }

    private void updateIncludeOriginalInputBox() {
        Coordinate[] coordinates;
        this.includeOriginalInputBox.setEnabled(false);
        for (Coordinate coordinate : coordinates = this.getCoordinates()) {
            if (coordinate.getOriginalValues().length <= 0) continue;
            this.includeOriginalInputBox.setEnabled(true);
            return;
        }
    }

    private void updateExpressionComponents() {
        boolean useExpressionSelected = this.useExpressionCheckBox.isSelected();
        this.editExpressionButton.setEnabled(useExpressionSelected && this.activeProduct != null);
        String toolTip = null;
        if (this.activeProduct == null) {
            toolTip = String.format("Editor can only be used with a product opened in %s.", this.appContext.getApplicationName());
        }
        this.editExpressionButton.setToolTipText(toolTip);
        this.expressionArea.setEnabled(useExpressionSelected);
        this.expressionNoteLabel.setEnabled(useExpressionSelected);
        this.expressionAsFilterButton.setEnabled(useExpressionSelected);
        this.exportExpressionResultButton.setEnabled(useExpressionSelected);
    }

    private void handleWindowSpinnerChange() {
        Integer windowSize = (Integer)this.windowSpinner.getValue();
        this.windowLabel.setText(String.format("%1$d x %1$d", windowSize));
        this.aggregationEneblement.apply();
    }

    private JPanel createExportPanel(BindingContext bindingContext) {
        TableLayout tableLayout = new TableLayout(4);
        tableLayout.setTablePadding(4, 0);
        tableLayout.setTableFill(TableLayout.Fill.VERTICAL);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setColumnWeightX(3, Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(1.0));
        JPanel exportPanel = new JPanel((LayoutManager)tableLayout);
        exportPanel.add(this.createIncludeCheckbox(bindingContext, "Bands", "exportBands"));
        exportPanel.add(this.createIncludeCheckbox(bindingContext, "Tie-point grids", "exportTiePoints"));
        exportPanel.add(this.createIncludeCheckbox(bindingContext, "Masks", "exportMasks"));
        exportPanel.add(tableLayout.createHorizontalSpacer());
        return exportPanel;
    }

    private JCheckBox createIncludeCheckbox(BindingContext bindingContext, String labelText, String propertyName) {
        Property windowProperty = bindingContext.getPropertySet().getProperty(propertyName);
        Boolean defaultValue = (Boolean)windowProperty.getDescriptor().getDefaultValue();
        JCheckBox checkbox = new JCheckBox(labelText, (boolean)defaultValue);
        bindingContext.bind(propertyName, checkbox);
        return checkbox;
    }

    private JPanel createExpressionPanel(BindingContext bindingContext) {
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setCellAnchor(0, 1, TableLayout.Anchor.NORTHEAST);
        tableLayout.setRowFill(0, TableLayout.Fill.VERTICAL);
        tableLayout.setCellFill(1, 0, TableLayout.Fill.BOTH);
        tableLayout.setCellWeightY(1, 0, Double.valueOf(1.0));
        tableLayout.setCellColspan(1, 0, Integer.valueOf(2));
        tableLayout.setCellColspan(2, 0, Integer.valueOf(2));
        tableLayout.setCellColspan(3, 0, Integer.valueOf(2));
        tableLayout.setCellFill(3, 0, TableLayout.Fill.BOTH);
        JPanel panel = new JPanel((LayoutManager)tableLayout);
        this.useExpressionCheckBox = new JCheckBox("Use expression");
        this.useExpressionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PixelExtractionParametersForm.this.updateExpressionComponents();
            }
        });
        this.editExpressionButton = new JButton("Edit Expression...");
        Window parentWindow = SwingUtilities.getWindowAncestor(panel);
        this.editExpressionButton.addActionListener(new EditExpressionActionListener(parentWindow));
        panel.add(this.useExpressionCheckBox);
        panel.add(this.editExpressionButton);
        this.expressionArea = new JTextArea(3, 40);
        this.expressionArea.setLineWrap(true);
        panel.add(new JScrollPane(this.expressionArea));
        this.expressionNoteLabel = new JLabel("Note: The expression might not be applicable to all products.");
        panel.add(this.expressionNoteLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.expressionAsFilterButton = new JRadioButton("Use expression as filter", true);
        buttonGroup.add(this.expressionAsFilterButton);
        this.exportExpressionResultButton = new JRadioButton("Export expression result");
        buttonGroup.add(this.exportExpressionResultButton);
        Property exportResultProperty = bindingContext.getPropertySet().getProperty("exportExpressionResult");
        Boolean defaultValue = (Boolean)exportResultProperty.getDescriptor().getDefaultValue();
        this.exportExpressionResultButton.setSelected(defaultValue);
        this.exportExpressionResultButton.setToolTipText("Expression result is exported to the output file for each exported pixel.");
        this.expressionAsFilterButton.setSelected(defaultValue == false);
        this.expressionAsFilterButton.setToolTipText("Expression is used as filter (all pixels in given window must be valid).");
        JPanel expressionButtonPanel = new JPanel(new FlowLayout(0));
        expressionButtonPanel.add(this.expressionAsFilterButton);
        expressionButtonPanel.add(this.exportExpressionResultButton);
        panel.add(expressionButtonPanel);
        return panel;
    }

    private JComponent[] createCoordinatesComponents() {
        Product selectedProduct = this.appContext.getSelectedProduct();
        if (selectedProduct != null) {
            PlacemarkGroup pinGroup = selectedProduct.getPinGroup();
            for (int i = 0; i < pinGroup.getNodeCount(); ++i) {
                this.coordinateTableModel.addPlacemark((Placemark)pinGroup.get(i));
            }
        }
        JTable coordinateTable = new JTable((TableModel)((Object)this.coordinateTableModel));
        coordinateTable.setName("coordinateTable");
        coordinateTable.setAutoResizeMode(1);
        coordinateTable.setSelectionMode(2);
        coordinateTable.setRowSelectionAllowed(true);
        coordinateTable.getTableHeader().setReorderingAllowed(false);
        coordinateTable.setDefaultRenderer(Float.class, (TableCellRenderer)new DecimalTableCellRenderer(new DecimalFormat("0.0000")));
        coordinateTable.setPreferredScrollableViewportSize(new Dimension(250, 100));
        coordinateTable.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)new FloatCellEditor(-90.0f, 90.0f));
        coordinateTable.getColumnModel().getColumn(2).setCellEditor((TableCellEditor)new FloatCellEditor(-180.0f, 180.0f));
        coordinateTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        DefaultDateModel dateModel = new DefaultDateModel();
        DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss");
        dateModel.setDateFormat(dateFormat);
        DateCellEditor dateCellEditor = new DateCellEditor((DateModel)dateModel, true);
        dateCellEditor.setTimeDisplayed(true);
        coordinateTable.getColumnModel().getColumn(3).setCellEditor((TableCellEditor)dateCellEditor);
        coordinateTable.getColumnModel().getColumn(3).setPreferredWidth(200);
        DateCellRenderer dateCellRenderer = new DateCellRenderer(dateFormat);
        dateCellRenderer.setHorizontalAlignment(4);
        coordinateTable.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)dateCellRenderer);
        JScrollPane rasterScrollPane = new JScrollPane(coordinateTable);
        AbstractButton addButton = ToolButtonFactory.createButton((Icon)ADD_ICON, (boolean)false);
        addButton.addActionListener(new AddPopupListener());
        AbstractButton removeButton = ToolButtonFactory.createButton((Icon)REMOVE_ICON, (boolean)false);
        removeButton.addActionListener(new RemovePlacemarksListener(coordinateTable, this.coordinateTableModel));
        JPanel buttonPanel = new JPanel();
        BoxLayout layout = new BoxLayout(buttonPanel, 1);
        buttonPanel.setLayout(layout);
        buttonPanel.add(addButton);
        buttonPanel.add(removeButton);
        return new JComponent[]{rasterScrollPane, buttonPanel};
    }

    private JSpinner createWindowSizeEditor(BindingContext bindingContext) {
        PropertyDescriptor windowSizeDescriptor = bindingContext.getPropertySet().getProperty("windowSize").getDescriptor();
        windowSizeDescriptor.setValueRange(new ValueRange(1.0, Double.POSITIVE_INFINITY));
        windowSizeDescriptor.setAttribute("stepSize", (Object)2);
        windowSizeDescriptor.setValidator(new Validator(){

            public void validateValue(Property property, Object value) throws ValidationException {
                if (((Number)value).intValue() % 2 == 0) {
                    throw new ValidationException("Only odd values allowed as window size.");
                }
            }
        });
        JSpinner spinner = new JSpinner();
        bindingContext.bind("windowSize", spinner);
        return spinner;
    }

    public void setActiveProduct(Product product) {
        this.activeProduct = product;
        this.updateExpressionComponents();
    }

    private class EditExpressionActionListener
    implements ActionListener {
        private final Window parentWindow;

        private EditExpressionActionListener(Window parentWindow) {
            this.parentWindow = parentWindow;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProductExpressionPane pep = ProductExpressionPane.createBooleanExpressionPane((Product[])new Product[]{PixelExtractionParametersForm.this.activeProduct}, (Product)PixelExtractionParametersForm.this.activeProduct, (PropertyMap)PixelExtractionParametersForm.this.appContext.getPreferences());
            pep.setCode(PixelExtractionParametersForm.this.expressionArea.getText());
            int i = pep.showModalDialog(this.parentWindow, "Expression Editor");
            if (i == 1) {
                PixelExtractionParametersForm.this.expressionArea.setText(pep.getCode());
            }
        }
    }

    private static class RemovePlacemarksListener
    implements ActionListener {
        private final JTable coordinateTable;
        private final CoordinateTableModel tableModel;

        private RemovePlacemarksListener(JTable coordinateTable, CoordinateTableModel tableModel) {
            this.coordinateTable = coordinateTable;
            this.tableModel = tableModel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selectedRows = this.coordinateTable.getSelectedRows();
            Placemark[] toRemove = new Placemark[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                toRemove[i] = this.tableModel.getPlacemarkAt(selectedRows[i]);
            }
            for (Placemark placemark : toRemove) {
                this.tableModel.removePlacemark(placemark);
            }
        }
    }

    private class AddPopupListener
    implements ActionListener {
        private AddPopupListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu popup = new JPopupMenu("Add");
            Object source = e.getSource();
            if (source instanceof Component) {
                Component component = (Component)source;
                Rectangle buttonBounds = component.getBounds();
                popup.add(new AddCoordinateAction(PixelExtractionParametersForm.this.coordinateTableModel));
                popup.add(new AddPlacemarkFileAction(PixelExtractionParametersForm.this.appContext, PixelExtractionParametersForm.this.coordinateTableModel, PixelExtractionParametersForm.this.mainPanel));
                popup.add(new AddCsvFileAction(PixelExtractionParametersForm.this.appContext, PixelExtractionParametersForm.this.coordinateTableModel, PixelExtractionParametersForm.this.mainPanel));
                popup.show(component, 1, buttonBounds.height + 1);
            }
        }
    }
}

