/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.statistics;

import javax.media.jai.Histogram;
import org.esa.beam.framework.datamodel.HistogramStxOp;

public class HistogramExpanderTransmitter {
    static HistogramStxOp createExpandedHistogramOp(Histogram oldHistogram, double minimum, double maximum, boolean intHistogram, int initialBinCount) {
        int binRatio;
        double oldMin = oldHistogram.getLowValue()[0];
        double oldMax = oldHistogram.getHighValue()[0];
        double newMin = Math.min(oldMin, minimum);
        double newMax = Math.max(oldMax, maximum);
        int oldBinCount = oldHistogram.getNumBins()[0];
        double oldBinWidth = HistogramExpanderTransmitter.computeBinWidth(oldMin, oldMax, oldBinCount);
        double numNewMinBins = 0.0;
        if (minimum < oldMin) {
            double minDiff = oldMin - minimum;
            numNewMinBins = Math.ceil(minDiff / oldBinWidth);
        }
        double numNewMaxBins = 0.0;
        if (maximum > oldMax) {
            double maxDiff = maximum - oldMax;
            numNewMaxBins = Math.ceil(maxDiff / oldBinWidth);
        }
        if (oldBinWidth == 0.0 || numNewMinBins + numNewMaxBins > (double)(200 * initialBinCount)) {
            HistogramStxOp histogramStxOp = new HistogramStxOp(initialBinCount, newMin, newMax, intHistogram, false);
            HistogramExpanderTransmitter.migrateOldHistogramData(oldHistogram, histogramStxOp.getHistogram());
            return histogramStxOp;
        }
        double newMinimum = oldMin - numNewMinBins * oldBinWidth;
        double newMaximum = oldMax + numNewMaxBins * oldBinWidth;
        double newBinCount = (double)oldBinCount + numNewMinBins + numNewMaxBins;
        if (newBinCount > (double)(2 * initialBinCount)) {
            binRatio = (int)(newBinCount / (double)initialBinCount);
            int binRemainder = (int)(newBinCount % (double)binRatio);
            newMaximum += (double)binRemainder * oldBinWidth;
            newBinCount = (newBinCount + (double)binRemainder) / (double)binRatio;
        } else {
            binRatio = 1;
        }
        HistogramStxOp histogramStxOp = new HistogramStxOp((int)newBinCount, newMinimum, newMaximum, intHistogram, false);
        HistogramExpanderTransmitter.migrateOldHistogramData(oldHistogram, histogramStxOp.getHistogram(), (int)numNewMinBins, binRatio);
        return histogramStxOp;
    }

    private static void migrateOldHistogramData(Histogram oldHistogram, Histogram newHistogram) {
        double oldMin = oldHistogram.getLowValue(0);
        double oldMax = oldHistogram.getHighValue(0);
        int[] oldBins = oldHistogram.getBins(0);
        int oldNumBins = oldBins.length;
        double oldBinWidth = HistogramExpanderTransmitter.computeBinWidth(oldMin, oldMax, oldNumBins);
        double newMin = newHistogram.getLowValue(0);
        double newMax = newHistogram.getHighValue(0);
        int[] newBins = newHistogram.getBins(0);
        int newNumBins = newBins.length;
        double newBinWidth = HistogramExpanderTransmitter.computeBinWidth(newMin, newMax, newNumBins);
        for (int i = 0; i < oldBins.length; ++i) {
            int count = oldBins[i];
            if (count == 0) continue;
            double binCenterValue = oldMin + oldBinWidth * (double)i + oldBinWidth / 2.0;
            int newBinIndex = (int)Math.floor((binCenterValue - newMin) / newBinWidth);
            if (newBinIndex >= newNumBins) {
                newBinIndex = newNumBins - 1;
            }
            int n = newBinIndex;
            newBins[n] = newBins[n] + count;
        }
    }

    private static void migrateOldHistogramData(Histogram oldHistogram, Histogram newHistogram, int startOffset, int binRatio) {
        int[] oldBins = oldHistogram.getBins(0);
        int[] newBins = newHistogram.getBins(0);
        int newMaxIndex = newBins.length - 1;
        for (int i = 0; i < oldBins.length; ++i) {
            int newBinsIndex = (startOffset + i) / binRatio;
            if (newBinsIndex > newMaxIndex) {
                newBinsIndex = newMaxIndex;
            }
            int n = newBinsIndex;
            newBins[n] = newBins[n] + oldBins[i];
        }
    }

    private static double computeBinWidth(double min, double max, int binCount) {
        return (max - min) / (double)binCount;
    }
}

