/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.statistics.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.util.logging.BeamLogManager;

public class BandNameCreator {
    private Map<String, Integer> indexMap;
    private final PrintStream printStream;
    private Map<String, String> mappedNames;

    public BandNameCreator() {
        this(new PrintStream(new NullOutputStream()));
    }

    public BandNameCreator(PrintStream printStream) {
        this.printStream = printStream;
        this.indexMap = new HashMap<String, Integer>();
        this.mappedNames = new HashMap<String, String>();
    }

    public String createUniqueAttributeName(String algorithmName, String sourceBandName) {
        boolean tooLong;
        String desiredAttributeName = algorithmName + "_" + sourceBandName;
        if (this.mappedNames.containsKey(desiredAttributeName)) {
            return this.mappedNames.get(desiredAttributeName);
        }
        String attributeName = desiredAttributeName;
        boolean bl = tooLong = desiredAttributeName.length() > 10;
        if (tooLong) {
            attributeName = algorithmName + "_" + sourceBandName.replace("_", "");
            attributeName = BandNameCreator.shorten(attributeName);
        }
        if (attributeName.length() > 10) {
            int index = this.getIndex(algorithmName);
            attributeName = BandNameCreator.shorten(algorithmName) + "_" + index;
            if (attributeName.length() > 10) {
                String indexPart = Integer.toString(index);
                int idxLength = indexPart.length();
                attributeName = attributeName.substring(0, 10 - idxLength - 1) + "_" + indexPart;
            }
            this.indexMap.put(algorithmName, index + 1);
        }
        if (tooLong) {
            BeamLogManager.getSystemLogger().warning("attribute name '" + desiredAttributeName + "' exceeds 10 characters in length. Shortened to '" + attributeName + "'.");
        }
        this.addMapping(desiredAttributeName, attributeName);
        return attributeName;
    }

    private static String shorten(String attributeName) {
        attributeName = attributeName.replace("minimum", "min").replace("maximum", "max");
        attributeName = attributeName.replace("a", "").replace("e", "").replace("i", "").replace("o", "").replace("u", "");
        return attributeName;
    }

    private int getIndex(String attributeName) {
        if (this.indexMap.containsKey(attributeName)) {
            return this.indexMap.get(attributeName);
        }
        return 0;
    }

    private void addMapping(String desiredAttributeName, String attributeName) {
        this.printStream.append(attributeName).append("=").append(desiredAttributeName).append("\n");
        this.mappedNames.put(desiredAttributeName, attributeName);
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

