/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.statistics.output;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.esa.beam.statistics.output.StatisticsOutputContext;
import org.esa.beam.statistics.output.StatisticsOutputter;

public class CsvStatisticsWriter
implements StatisticsOutputter {
    private final PrintStream csvOutput;
    private String[] algorithmNames;
    final Statistics statisticsContainer;

    public CsvStatisticsWriter(PrintStream csvOutput) {
        this.csvOutput = csvOutput;
        this.statisticsContainer = new Statistics();
    }

    @Override
    public void initialiseOutput(StatisticsOutputContext statisticsOutputContext) {
        this.algorithmNames = statisticsOutputContext.algorithmNames;
        Arrays.sort(this.algorithmNames);
    }

    @Override
    public void addToOutput(String bandName, String regionId, Map<String, Number> statistics) {
        BandStatistics dataForBandName;
        if (!this.statisticsContainer.containsBand(bandName)) {
            this.statisticsContainer.put(bandName, new BandStatistics());
        }
        if (!(dataForBandName = this.statisticsContainer.getDataForBandName(bandName)).containsRegion(regionId)) {
            dataForBandName.put(regionId, new RegionStatistics());
        }
        RegionStatistics dataForRegionName = dataForBandName.getDataForRegionName(regionId);
        for (Map.Entry<String, Number> entry : statistics.entrySet()) {
            dataForRegionName.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void finaliseOutput() throws IOException {
        if (this.algorithmNames == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " not initialised.");
        }
        this.writeHeader();
        for (String bandName : this.statisticsContainer.getBandNames()) {
            BandStatistics bandStatistics = this.statisticsContainer.getDataForBandName(bandName);
            for (String regionName : bandStatistics.getRegionNames()) {
                this.csvOutput.append(regionName).append("\t").append(bandName);
                for (String algorithmName : this.algorithmNames) {
                    this.csvOutput.append("\t");
                    RegionStatistics dataForRegionName = bandStatistics.getDataForRegionName(regionName);
                    if (!dataForRegionName.containsAlgorithm(algorithmName)) continue;
                    Number numberValue = dataForRegionName.getDataForAlgorithmName(algorithmName);
                    this.csvOutput.append(CsvStatisticsWriter.getValueAsString(numberValue));
                }
                this.csvOutput.append("\n");
            }
        }
    }

    private void writeHeader() {
        this.csvOutput.append("# Region").append("\t").append("Band");
        for (String algorithmName : this.algorithmNames) {
            this.csvOutput.append("\t").append(algorithmName);
        }
        this.csvOutput.append("\n");
    }

    static String getValueAsString(Number numberValue) {
        if (numberValue instanceof Float || numberValue instanceof Double) {
            return String.format(Locale.ENGLISH, "%.4f", numberValue.doubleValue());
        }
        return numberValue.toString();
    }

    static class RegionStatistics {
        Map<String, Number> regionStatistics = new HashMap<String, Number>();

        RegionStatistics() {
        }

        Number getDataForAlgorithmName(String algorithmName) {
            return this.regionStatistics.get(algorithmName);
        }

        boolean containsAlgorithm(String algorithmName) {
            return this.regionStatistics.containsKey(algorithmName);
        }

        void put(String algorithmName, Number value) {
            this.regionStatistics.put(algorithmName, value);
        }
    }

    static class BandStatistics {
        Map<String, RegionStatistics> bandStatistics = new HashMap<String, RegionStatistics>();

        BandStatistics() {
        }

        RegionStatistics getDataForRegionName(String regionName) {
            return this.bandStatistics.get(regionName);
        }

        boolean containsRegion(String regionName) {
            return this.bandStatistics.containsKey(regionName);
        }

        String[] getRegionNames() {
            Set<String> regionNames = this.bandStatistics.keySet();
            return regionNames.toArray(new String[regionNames.size()]);
        }

        void put(String regionName, RegionStatistics regionStatistics) {
            this.bandStatistics.put(regionName, regionStatistics);
        }
    }

    static class Statistics {
        Map<String, BandStatistics> statistics = new HashMap<String, BandStatistics>();

        Statistics() {
        }

        BandStatistics getDataForBandName(String bandName) {
            return this.statistics.get(bandName);
        }

        boolean containsBand(String bandName) {
            return this.statistics.containsKey(bandName);
        }

        String[] getBandNames() {
            Set<String> bandNames = this.statistics.keySet();
            return bandNames.toArray(new String[bandNames.size()]);
        }

        void put(String bandName, BandStatistics bandStatistics) {
            this.statistics.put(bandName, bandStatistics);
        }
    }
}

