/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.statistics.output;

import java.util.ArrayList;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;

public class StatisticsOutputContext {
    public final String[] sourceProductNames;
    public final String[] bandNames;
    public final String[] algorithmNames;
    public final ProductData.UTC startDate;
    public final ProductData.UTC endDate;
    public final String[] regionIds;

    public static StatisticsOutputContext create(Product[] sourceProducts, String[] bandNames, String[] algorithmNames, ProductData.UTC startDate, ProductData.UTC endDate, String[] regionIds) {
        String[] sourceProductNames = StatisticsOutputContext.extractSourceProductNames(sourceProducts);
        return new StatisticsOutputContext(sourceProductNames, bandNames, algorithmNames, startDate, endDate, regionIds);
    }

    public static StatisticsOutputContext create(String[] sourceProductNames, String[] bandNames, String[] algorithmNames, ProductData.UTC startDate, ProductData.UTC endDate, String[] regionIds) {
        return new StatisticsOutputContext(sourceProductNames, bandNames, algorithmNames, startDate, endDate, regionIds);
    }

    public static StatisticsOutputContext create(Product[] sourceProducts, String[] algorithmNames, String[] regionIds) {
        String[] sourceProductNames = StatisticsOutputContext.extractSourceProductNames(sourceProducts);
        return new StatisticsOutputContext(sourceProductNames, null, algorithmNames, null, null, regionIds);
    }

    public static StatisticsOutputContext create(String[] bandNames, String[] algorithmNames) {
        return new StatisticsOutputContext(null, bandNames, algorithmNames, null, null, null);
    }

    private StatisticsOutputContext(String[] sourceProductNames, String[] bandNames, String[] algorithmNames, ProductData.UTC startDate, ProductData.UTC endDate, String[] regionIds) {
        this.sourceProductNames = sourceProductNames;
        this.bandNames = bandNames;
        this.algorithmNames = algorithmNames;
        this.startDate = startDate;
        this.endDate = endDate;
        this.regionIds = regionIds;
    }

    private static String[] extractSourceProductNames(Product[] sourceProducts) {
        ArrayList<String> productNames = new ArrayList<String>();
        for (Product sourceProduct : sourceProducts) {
            productNames.add(sourceProduct.getName());
        }
        return productNames.toArray(new String[productNames.size()]);
    }
}

