/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.statistics.output;

import javax.media.jai.Histogram;
import org.opengis.feature.simple.SimpleFeature;

public class Util {
    public static final int MAX_ACCURACY = 6;

    public static String getFeatureName(SimpleFeature simpleFeature) {
        if (simpleFeature.getAttribute("name") != null) {
            return simpleFeature.getAttribute("name").toString();
        }
        if (simpleFeature.getAttribute("NAME") != null) {
            return simpleFeature.getAttribute("NAME").toString();
        }
        return simpleFeature.getID();
    }

    public static double getBinWidth(Histogram histogram) {
        return (histogram.getHighValue(0) - histogram.getLowValue(0)) / (double)histogram.getNumBins(0);
    }

    public static int computeBinCount(int accuracy) {
        if (accuracy < 0 || accuracy > 6) {
            throw new IllegalArgumentException("accuracy is not in the range 0 ... 6");
        }
        return (int)Math.pow(10.0, accuracy);
    }
}

