/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.statistics.percentile.interpolated;

import java.util.ArrayList;
import org.esa.beam.interpolators.InterpolatingFunction;
import org.esa.beam.interpolators.Interpolator;

public class GapFiller {
    public static void fillGaps(float[] interpolationFloats, Interpolator interpolator, float startValueFallback, float endValueFallback) {
        GapFiller.fillStartAndEndWithFallback(interpolationFloats, startValueFallback, endValueFallback);
        ArrayList<Double> xList = new ArrayList<Double>();
        ArrayList<Double> yList = new ArrayList<Double>();
        for (int i = 0; i < interpolationFloats.length; ++i) {
            float value = interpolationFloats[i];
            if (Float.isNaN(value)) continue;
            xList.add(Double.valueOf(i));
            yList.add(Double.valueOf(value));
        }
        double[] nx = new double[xList.size()];
        double[] ny = new double[yList.size()];
        for (int i = 0; i < xList.size(); ++i) {
            nx[i] = (Double)xList.get(i);
            ny[i] = (Double)yList.get(i);
        }
        InterpolatingFunction interpolate = interpolator.interpolate(nx, ny);
        for (int i = 0; i < interpolationFloats.length; ++i) {
            interpolationFloats[i] = (float)interpolate.value(i);
        }
    }

    public static void fillStartAndEndWithFallback(float[] interpolationFloats, float startValueFallback, float endValueFallback) {
        int lastIdx;
        if (Float.isNaN(interpolationFloats[0])) {
            interpolationFloats[0] = startValueFallback;
        }
        if (Float.isNaN(interpolationFloats[lastIdx = interpolationFloats.length - 1])) {
            interpolationFloats[lastIdx] = endValueFallback;
        }
    }
}

