/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.statistics.percentile.interpolated;

import java.awt.geom.Area;
import java.util.logging.Logger;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.statistics.percentile.interpolated.Utils;

public class ProductValidator {
    final ProductData.UTC startDate;
    final ProductData.UTC endDate;
    private final Logger logger;
    private final Area targetArea;
    private final String sourceBandName;
    private final String bandMathExpression;
    private final String validPixelExpression;

    public ProductValidator(String sourceBandName, String bandMathExpression, String validPixelExpression, ProductData.UTC startDate, ProductData.UTC endDate, Area targetArea, Logger logger) {
        this.sourceBandName = sourceBandName;
        this.bandMathExpression = bandMathExpression;
        this.validPixelExpression = validPixelExpression;
        this.startDate = startDate;
        this.endDate = endDate;
        this.logger = logger;
        this.targetArea = targetArea;
    }

    public boolean isValid(Product product) {
        return product != null && this.containsGeoCodingWithReverseOperationSupport(product) && this.fulfillsTimeConditions(product) && this.canHandleExpressionOrSourceBand(product) && this.isInDateRange(product) && this.intersectsTargetArea(product);
    }

    private boolean containsGeoCodingWithReverseOperationSupport(Product product) {
        GeoCoding geoCoding = product.getGeoCoding();
        if (geoCoding == null) {
            this.logSkipped("The product '" + product.getName() + "' does not contain a geo coding.");
            return false;
        }
        if (!geoCoding.canGetPixelPos()) {
            this.logSkipped("The geo-coding of the product '" + product.getName() + "' can not determine the pixel position from a geodetic position.");
            return false;
        }
        return true;
    }

    private boolean fulfillsTimeConditions(Product product) {
        return this.containsStartAndEndDate(product) && this.startTimeMustBeBeforeEnd(product) && this.timeRangeIsLessThan367Days(product);
    }

    private boolean containsStartAndEndDate(Product product) {
        boolean valid;
        boolean bl = valid = product.getStartTime() != null && product.getEndTime() != null;
        if (!valid) {
            this.logSkipped("The product '" + product.getName() + "' must contain start and end time.");
        }
        return valid;
    }

    private boolean startTimeMustBeBeforeEnd(Product product) {
        double stopMJD;
        boolean valid;
        double startMJD = product.getStartTime().getMJD();
        boolean bl = valid = startMJD < (stopMJD = product.getEndTime().getMJD());
        if (!valid) {
            this.logSkipped("The product '" + product.getName() + "' has an end time which is before start time.");
        }
        return valid;
    }

    private boolean timeRangeIsLessThan367Days(Product product) {
        boolean valid;
        double startMJD = product.getStartTime().getMJD();
        double stopMJD = product.getEndTime().getMJD();
        boolean bl = valid = stopMJD - startMJD < 367.0;
        if (!valid) {
            this.logSkipped("The product '" + product.getName() + "' covers more than one year.");
        }
        return valid;
    }

    private boolean canHandleExpressionOrSourceBand(Product product) {
        String expression;
        if (this.sourceBandName != null) {
            if (!product.containsBand(this.sourceBandName)) {
                this.logSkipped("The product '" + product.getName() + "' does not contain the band '" + this.sourceBandName + "'.");
                return false;
            }
        } else if (!product.isCompatibleBandArithmeticExpression(this.bandMathExpression)) {
            this.logSkipped("'" + this.bandMathExpression + "' is not a compatible band arithmetic expression for product: '" + product.getName() + ".");
            return false;
        }
        if (this.validPixelExpression != null && this.validPixelExpression.trim().length() > 0 && !product.isCompatibleBandArithmeticExpression(expression = this.validPixelExpression.trim())) {
            this.logSkipped("'" + this.validPixelExpression + "' is not a compatible valid pixel expression for product: '" + product.getName() + ".");
            return false;
        }
        return true;
    }

    private boolean isInDateRange(Product product) {
        if (this.startDate == null && this.endDate == null) {
            return true;
        }
        if (this.startDate != null) {
            long startDateMillis = this.startDate.getAsDate().getTime();
            long productStartDateMillis = product.getStartTime().getAsDate().getTime();
            if (productStartDateMillis < startDateMillis) {
                this.logSkippedDueToTimeRange(product);
                return false;
            }
        }
        if (this.endDate != null) {
            long endDateMillis = this.endDate.getAsDate().getTime();
            long productEndDateMillis = product.getEndTime().getAsDate().getTime();
            if (productEndDateMillis > endDateMillis) {
                this.logSkippedDueToTimeRange(product);
                return false;
            }
        }
        return true;
    }

    private boolean intersectsTargetArea(Product product) {
        boolean valid;
        Area productArea = Utils.createProductArea(product);
        productArea.intersect(this.targetArea);
        boolean bl = valid = !productArea.isEmpty();
        if (!valid) {
            this.logSkipped("The product '" + product.getName() + "' does not intersect the target product.");
        }
        return valid;
    }

    private void logSkippedDueToTimeRange(Product product) {
        this.logSkipped("The product '" + product.getName() + "' is not inside the date range" + this.formatDateRange());
    }

    private String formatDateRange() {
        return (this.startDate != null ? " from " + this.startDate.format() : " ") + (this.endDate != null ? " to " + this.endDate.format() : "");
    }

    private void logSkipped(String message) {
        this.logger.info("Product skipped. " + message);
    }
}

