/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.core;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.runtime.Activator;
import com.bc.ceres.core.runtime.ModuleContext;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.esa.beam.dataio.dimap.DimapProductReader;
import org.esa.beam.dataio.dimap.DimapProductReaderPlugIn;
import org.esa.beam.dataio.dimap.DimapProductWriter;
import org.esa.beam.dataio.dimap.DimapProductWriterPlugIn;
import org.esa.beam.framework.dataio.ProductIOPlugInManager;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.beam.timeseries.core.timeseries.datamodel.TimeSeriesFactory;
import org.esa.beam.util.io.FileUtils;
import org.esa.beam.visat.VisatApp;

public class TimeSeriesToolActivator
implements Activator {
    private final DimapProductWriter.WriterExtender writerExtender = this.createWriterExtender();
    private final DimapProductReader.ReaderExtender readerExtender = this.createReaderExtender();

    public void start(ModuleContext moduleContext) throws CoreException {
        ProductIOPlugInManager ioPlugInManager = ProductIOPlugInManager.getInstance();
        Iterator allWriterPlugIns = ioPlugInManager.getWriterPlugIns("BEAM-DIMAP");
        while (allWriterPlugIns.hasNext()) {
            DimapProductWriterPlugIn writerPlugIn = (DimapProductWriterPlugIn)allWriterPlugIns.next();
            writerPlugIn.addWriterExtender(this.writerExtender);
        }
        Iterator readerPlugIns = ioPlugInManager.getReaderPlugIns("BEAM-DIMAP");
        while (readerPlugIns.hasNext()) {
            DimapProductReaderPlugIn readerPlugin = (DimapProductReaderPlugIn)readerPlugIns.next();
            readerPlugin.addReaderExtender(this.readerExtender);
        }
    }

    public void stop(ModuleContext moduleContext) throws CoreException {
        ProductIOPlugInManager ioPlugInManager = ProductIOPlugInManager.getInstance();
        Iterator writerPlugIns = ioPlugInManager.getWriterPlugIns("BEAM-DIMAP");
        while (writerPlugIns.hasNext()) {
            DimapProductWriterPlugIn writerPlugIn = (DimapProductWriterPlugIn)writerPlugIns.next();
            writerPlugIn.removeWriterExtender(this.writerExtender);
        }
        Iterator readerPlugIns = ioPlugInManager.getReaderPlugIns("BEAM-DIMAP");
        while (readerPlugIns.hasNext()) {
            DimapProductReaderPlugIn readerPlugIn = (DimapProductReaderPlugIn)readerPlugIns.next();
            readerPlugIn.removeReaderExtender(this.readerExtender);
        }
    }

    private DimapProductWriter.WriterExtender createWriterExtender() {
        return new DimapProductWriter.WriterExtender(){

            public boolean vetoableShouldWrite(ProductNode node) {
                if (!this.isTimeSerisProduct(node.getProduct())) {
                    return true;
                }
                return !(node instanceof RasterDataNode);
            }

            public void intendToWriteDimapHeaderTo(File outputDir, Product product) {
                if (this.isTimeSerisProduct(product)) {
                    TimeSeriesToolActivator.convertAbsolutPathsToRelative(product, outputDir);
                }
            }

            private boolean isTimeSerisProduct(Product product) {
                return product.getProductType().equals("org.esa.beam.glob.timeseries");
            }
        };
    }

    public static void convertAbsolutPathsToRelative(Product product, File outputDir) {
        MetadataElement tsRootElem = product.getMetadataRoot().getElement("TIME_SERIES");
        MetadataElement productLocations = tsRootElem.getElement("PRODUCT_LOCATIONS");
        MetadataElement sourceProductPaths = tsRootElem.getElement("SOURCE_PRODUCT_PATHS");
        TimeSeriesToolActivator.replaceWithRelativePaths(productLocations.getElements(), outputDir);
        TimeSeriesToolActivator.replaceWithRelativePaths(sourceProductPaths.getElements(), outputDir);
    }

    private static void replaceWithRelativePaths(MetadataElement[] elements, File outputDir) {
        for (MetadataElement element : elements) {
            String pathName = element.getAttributeString("PATH");
            URI relativeUri = FileUtils.getRelativeUri((URI)outputDir.toURI(), (File)new File(pathName));
            MetadataAttribute pathAttr = element.getAttribute("PATH");
            MetadataAttribute typeAttr = element.getAttribute("TYPE");
            element.removeAttribute(pathAttr);
            element.removeAttribute(typeAttr);
            pathAttr.dispose();
            MetadataAttribute newPathAttr = new MetadataAttribute("PATH", ProductData.createInstance((String)relativeUri.toString()), true);
            element.addAttribute(newPathAttr);
            element.addAttribute(typeAttr);
        }
    }

    private DimapProductReader.ReaderExtender createReaderExtender() {
        return new DimapProductReader.ReaderExtender(){

            public void completeProductNodesReading(final Product product) {
                if (product.getProductType().equals("org.esa.beam.glob.timeseries")) {
                    final VisatApp visatApp = VisatApp.getApp();
                    Window appWindow = visatApp.getApplicationWindow();
                    ProgressMonitorSwingWorker<AbstractTimeSeries, Void> pm = new ProgressMonitorSwingWorker<AbstractTimeSeries, Void>((Component)appWindow, "Creating Time Series..."){

                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (InterruptedException e) {
                                this.handleError(e);
                            }
                            catch (ExecutionException e) {
                                this.handleError(e.getCause());
                            }
                            super.done();
                        }

                        private void handleError(Throwable theCause) {
                            visatApp.getLogger().log(Level.SEVERE, theCause.getMessage());
                            visatApp.showErrorDialog("Could not load time series", theCause.getMessage());
                        }

                        protected AbstractTimeSeries doInBackground(ProgressMonitor pm) throws Exception {
                            return TimeSeriesFactory.create(product, pm);
                        }
                    };
                    pm.executeWithBlocking();
                }
            }
        };
    }
}

