/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.core;

import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductManager;
import org.esa.beam.timeseries.core.TimeSeriesMapper;
import org.esa.beam.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.beam.visat.VisatApp;
import org.esa.beam.visat.VisatPlugIn;

public class TimeSeriesVPI
implements VisatPlugIn {
    private final ProductManager.Listener productManagerListener = this.createProductManagerListener();

    public void start(VisatApp visatApp) {
        visatApp.getProductManager().addListener(this.productManagerListener);
    }

    public void stop(VisatApp visatApp) {
        visatApp.getProductManager().removeListener(this.productManagerListener);
    }

    public void updateComponentTreeUI() {
    }

    private ProductManager.Listener createProductManagerListener() {
        return new ProductManager.Listener(){

            public void productAdded(ProductManager.Event event) {
            }

            public void productRemoved(ProductManager.Event event) {
                Product product = event.getProduct();
                if (product.getProductType().equals("org.esa.beam.glob.timeseries")) {
                    TimeSeriesMapper timeSeriesMapper = TimeSeriesMapper.getInstance();
                    AbstractTimeSeries timeSeries = timeSeriesMapper.getTimeSeries(product);
                    Product[] sourceProducts = timeSeries.getSourceProducts();
                    ProductManager productManager = VisatApp.getApp().getProductManager();
                    for (Product sourceProduct : sourceProducts) {
                        if (productManager.contains(sourceProduct)) continue;
                        sourceProduct.dispose();
                    }
                    timeSeriesMapper.remove(product);
                }
            }
        };
    }
}

