/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.core.insitu.csv;

import java.util.Date;
import org.esa.beam.framework.datamodel.GeoPos;

public class InsituRecord {
    public final GeoPos pos;
    public final Date time;
    public final String stationName;
    public final double value;

    public InsituRecord(GeoPos pos, Date time, String stationName, double value) {
        this.pos = pos;
        this.time = time;
        this.stationName = stationName;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsituRecord that = (InsituRecord)o;
        if (Double.compare(that.value, this.value) != 0) {
            return false;
        }
        if (this.pos != null ? !this.pos.equals((Object)that.pos) : that.pos != null) {
            return false;
        }
        if (this.stationName != null ? !this.stationName.equals(that.stationName) : that.stationName != null) {
            return false;
        }
        return !(this.time != null ? !this.time.equals(that.time) : that.time != null);
    }

    public int hashCode() {
        int result = this.pos != null ? this.pos.hashCode() : 0;
        result = 31 * result + (this.time != null ? this.time.hashCode() : 0);
        result = 31 * result + (this.stationName != null ? this.stationName.hashCode() : 0);
        long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

