/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.core.insitu.csv;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.esa.beam.timeseries.core.insitu.Record;

abstract class RecordIterator
implements Iterator<Record> {
    private Record next;
    private boolean nextValid;

    RecordIterator() {
    }

    @Override
    public boolean hasNext() {
        this.ensureValidNext();
        return this.next != null;
    }

    @Override
    public Record next() {
        this.ensureValidNext();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.nextValid = false;
        return this.next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void ensureValidNext() {
        if (!this.nextValid) {
            this.next = this.getNextRecord();
            if (this.next != null) {
                this.nextValid = true;
            }
        }
    }

    protected abstract Record getNextRecord();
}

