/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.core.timeseries.datamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class AxisMapping {
    private final Map<String, Set<String>> insituMap = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> rasterMap = new HashMap<String, Set<String>>();
    private final List<AxisMappingListener> listeners = new ArrayList<AxisMappingListener>();

    public List<String> getInsituNames(String alias) {
        return this.getNamesFor(alias, this.insituMap);
    }

    public List<String> getRasterNames(String alias) {
        return this.getNamesFor(alias, this.rasterMap);
    }

    public void addRasterName(String alias, String rasterName) {
        this.addNameToAliasMap(alias, rasterName, this.rasterMap);
    }

    public void addInsituName(String alias, String insituName) {
        this.addNameToAliasMap(alias, insituName, this.insituMap);
    }

    public void removeAlias(String alias) {
        this.insituMap.remove(alias);
        this.rasterMap.remove(alias);
        this.fireEvent();
    }

    public void addAlias(String alias) {
        this.insituMap.put(alias, new TreeSet());
        this.fireEvent();
    }

    public void removeInsituName(String alias, String insituName) {
        this.removeName(alias, insituName, this.insituMap);
    }

    public void removeRasterName(String alias, String rasterName) {
        this.removeName(alias, rasterName, this.rasterMap);
    }

    public Set<String> getAliasNames() {
        TreeSet<String> names = new TreeSet<String>();
        names.addAll(this.insituMap.keySet());
        names.addAll(this.rasterMap.keySet());
        return names;
    }

    public void replaceAlias(String beforeName, String changedName) {
        this.replaceAliasInMap(beforeName, changedName, this.rasterMap);
        this.replaceAliasInMap(beforeName, changedName, this.insituMap);
        this.fireEvent();
    }

    public String getRasterAlias(String rasterName) {
        return this.getAlias(rasterName, this.rasterMap);
    }

    public String getInsituAlias(String insituName) {
        return this.getAlias(insituName, this.insituMap);
    }

    public void addAxisMappingListener(AxisMappingListener axisMappingListener) {
        this.listeners.add(axisMappingListener);
    }

    public int getRasterCount() {
        return this.getDataSourceCount(this.rasterMap);
    }

    public int getInsituCount() {
        return this.getDataSourceCount(this.insituMap);
    }

    private String getAlias(String rasterName, Map<String, Set<String>> map) {
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            for (String mappedRasterName : entry.getValue()) {
                if (!mappedRasterName.equals(rasterName)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private List<String> getNamesFor(String alias, Map<String, Set<String>> map) {
        if (!map.containsKey(alias)) {
            return Collections.emptyList();
        }
        Set<String> insituSet = map.get(alias);
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(insituSet);
        return Collections.unmodifiableList(names);
    }

    private void addNameToAliasMap(String alias, String name, Map<String, Set<String>> map) {
        this.ensureSetAvailable(alias, map);
        Set<String> set = map.get(alias);
        set.add(name);
        this.fireEvent();
    }

    private void ensureSetAvailable(String alias, Map<String, Set<String>> map) {
        if (!map.containsKey(alias)) {
            map.put(alias, new TreeSet());
        }
    }

    private void removeName(String alias, String name, Map<String, Set<String>> map) {
        this.ensureSetAvailable(alias, map);
        map.get(alias).remove(name);
        this.fireEvent();
    }

    private void replaceAliasInMap(String beforeName, String changedName, Map<String, Set<String>> map) {
        Set<String> removedNames = map.remove(beforeName);
        if (removedNames != null) {
            map.put(changedName, removedNames);
        }
    }

    private void fireEvent() {
        for (AxisMappingListener listener : this.listeners) {
            listener.hasChanged();
        }
    }

    private int getDataSourceCount(Map<String, Set<String>> map) {
        int count = 0;
        for (Set<String> strings : map.values()) {
            count += strings.size();
        }
        return count;
    }

    static interface AxisMappingListener {
        public void hasChanged();
    }
}

