/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.core.timeseries.datamodel;

import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.Guardian;

public abstract class TimeCoding {
    private final ProductData.UTC startTime;
    private final ProductData.UTC endTime;

    protected TimeCoding(ProductData.UTC startTime, ProductData.UTC endTime) {
        Guardian.assertNotNull((String)"startTime", (Object)startTime);
        Guardian.assertNotNull((String)"endTime", (Object)endTime);
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public abstract ProductData.UTC getTime(PixelPos var1);

    public ProductData.UTC getStartTime() {
        return this.startTime;
    }

    public ProductData.UTC getEndTime() {
        return this.endTime;
    }

    public boolean contains(TimeCoding timeCoding) {
        if (this.getStartTime().getAsDate().after(timeCoding.getStartTime().getAsDate())) {
            return false;
        }
        return !this.getEndTime().getAsDate().before(timeCoding.getEndTime().getAsDate());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeCoding that = (TimeCoding)o;
        boolean startEqual = this.areEqual(this.startTime, that.startTime);
        boolean endEqual = this.areEqual(this.endTime, that.endTime);
        return startEqual && endEqual;
    }

    private boolean areEqual(ProductData.UTC time1, ProductData.UTC time2) {
        return time1.getAsDate().getTime() == time2.getAsDate().getTime();
    }

    public int hashCode() {
        return 31 * this.startTime.hashCode() + this.endTime.hashCode();
    }
}

