/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.export.animations;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.io.BeamFileChooser;
import org.esa.beam.util.io.BeamFileFilter;
import org.esa.beam.visat.VisatApp;
import org.w3c.dom.Node;

public class AnimatedGifExport
extends ProgressMonitorSwingWorker<Void, Void> {
    private final File outputFile = this.fetchOutputFile();
    private static final String EXPORT_DIR_PREFERENCES_KEY = "user.export.dir";
    private RenderedImage[] frames;
    private int level;
    private ButtonGroup buttonGroup;

    public AnimatedGifExport(Component parentComponent, String title) {
        super(parentComponent, title);
    }

    protected Void doInBackground(ProgressMonitor pm) throws Exception {
        this.exportAnimation("50", this.outputFile, pm);
        return null;
    }

    public void createFrames(List<Band> bandsForVariable) {
        ArrayList<RenderedImage> images = new ArrayList<RenderedImage>();
        for (Band band : bandsForVariable) {
            images.add(band.getGeophysicalImage().getImage(this.level));
        }
        this.frames = images.toArray(new RenderedImage[images.size()]);
    }

    private void exportAnimation(String delayTime, File file, ProgressMonitor pm) {
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("gif").next();
        try {
            ImageOutputStream outputStream = ImageIO.createImageOutputStream(file);
            imageWriter.setOutput(outputStream);
            imageWriter.prepareWriteSequence(null);
            pm.beginTask("Exporting time series as animated gif", this.frames.length);
            for (int i = 0; i < this.frames.length; ++i) {
                RenderedImage currentImage = this.frames[i];
                ImageWriteParam writeParameters = imageWriter.getDefaultWriteParam();
                IIOMetadata metadata = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(currentImage), writeParameters);
                AnimatedGifExport.configure(metadata, delayTime, i);
                IIOImage image = new IIOImage(currentImage, null, metadata);
                imageWriter.writeToSequence(image, null);
                pm.worked(1);
            }
            imageWriter.endWriteSequence();
            outputStream.close();
            pm.done();
        }
        catch (IOException e) {
            VisatApp.getApp().handleError("Unable to create animated gif", (Throwable)e);
        }
    }

    private static void configure(IIOMetadata meta, String delayTime, int imageIndex) {
        String metaFormat = meta.getNativeMetadataFormatName();
        if (!"javax_imageio_gif_image_1.0".equals(metaFormat)) {
            throw new IllegalArgumentException("Unfamiliar gif metadata format: " + metaFormat);
        }
        Node root = meta.getAsTree(metaFormat);
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!"GraphicControlExtension".equals(child.getNodeName())) continue;
            IIOMetadataNode gce = (IIOMetadataNode)child;
            gce.setAttribute("userInputFlag", "FALSE");
            gce.setAttribute("delayTime", delayTime);
            break;
        }
        if (imageIndex == 0) {
            IIOMetadataNode parentNode = new IIOMetadataNode("ApplicationExtensions");
            IIOMetadataNode childNode = new IIOMetadataNode("ApplicationExtension");
            childNode.setAttribute("applicationID", "NETSCAPE");
            childNode.setAttribute("authenticationCode", "2.0");
            byte[] userObject = new byte[]{1, 0, 0};
            childNode.setUserObject(userObject);
            parentNode.appendChild(childNode);
            root.appendChild(parentNode);
        }
        try {
            meta.setFromTree(metaFormat, root);
        }
        catch (IIOInvalidTreeException e) {
            VisatApp.getApp().handleError(e.getMessage(), (Throwable)e);
        }
    }

    private File fetchOutputFile() {
        VisatApp visatApp = VisatApp.getApp();
        String lastDir = visatApp.getPreferences().getPropertyString(EXPORT_DIR_PREFERENCES_KEY, SystemUtils.getUserHomeDir().getPath());
        File currentDir = new File(lastDir);
        BeamFileChooser fileChooser = new BeamFileChooser();
        fileChooser.setCurrentDirectory(currentDir);
        fileChooser.addChoosableFileFilter((FileFilter)new BeamFileFilter("gif", "gif", "Animated GIF"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setDialogTitle(visatApp.getAppName() + " - " + "Export time series as animated GIF...");
        fileChooser.setFileSelectionMode(0);
        Dimension fileChooserSize = fileChooser.getPreferredSize();
        if (fileChooserSize != null) {
            fileChooser.setPreferredSize(new Dimension(fileChooserSize.width + 120, fileChooserSize.height));
        } else {
            fileChooser.setPreferredSize(new Dimension(512, 256));
        }
        RasterDataNode currentRaster = VisatApp.getApp().getSelectedProductSceneView().getRaster();
        int maxLevel = currentRaster.getSourceImage().getModel().getLevelCount() - 1;
        maxLevel = maxLevel > 10 ? 10 : maxLevel;
        JPanel levelPanel = new JPanel(new GridLayout(maxLevel, 1));
        levelPanel.setBorder(BorderFactory.createTitledBorder("Resolution Level"));
        this.buttonGroup = new ButtonGroup();
        for (int i = 0; i < maxLevel; ++i) {
            String level = Integer.toString(i);
            if (i == 0) {
                level = level + " (high, very slow)";
            } else if (i == maxLevel - 1) {
                level = level + " (low, fast)";
            }
            JRadioButton levelButton = new JRadioButton(level, true);
            this.buttonGroup.add(levelButton);
            levelPanel.add(levelButton);
            levelButton.setSelected(true);
        }
        JPanel accessory = new JPanel();
        accessory.setLayout(new BoxLayout(accessory, 1));
        accessory.add(levelPanel);
        fileChooser.setAccessory((JComponent)accessory);
        int result = fileChooser.showSaveDialog((Component)visatApp.getMainFrame());
        File file = fileChooser.getSelectedFile();
        File currentDirectory = fileChooser.getCurrentDirectory();
        if (currentDirectory != null) {
            visatApp.getPreferences().setPropertyString(EXPORT_DIR_PREFERENCES_KEY, currentDirectory.getPath());
        }
        if (result != 0) {
            return null;
        }
        if (file == null || file.getName().isEmpty()) {
            return null;
        }
        if (!visatApp.promptForOverwrite(file)) {
            return null;
        }
        this.parseLevel();
        return file;
    }

    private void parseLevel() {
        Enumeration<AbstractButton> buttonEnumeration = this.buttonGroup.getElements();
        while (buttonEnumeration.hasMoreElements()) {
            AbstractButton abstractButton = buttonEnumeration.nextElement();
            if (!abstractButton.isSelected()) continue;
            String buttonText = abstractButton.getText();
            int index = buttonText.indexOf(" (");
            if (index != -1) {
                buttonText = buttonText.substring(0, index);
            }
            this.level = Integer.parseInt(buttonText);
        }
    }
}

