/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.export.kmz;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.MapGeoCoding;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.dataop.maptransf.MapTransformDescriptor;
import org.esa.beam.framework.help.HelpSys;
import org.esa.beam.framework.ui.command.CommandEvent;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.framework.ui.product.ProductSceneView;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.timeseries.core.TimeSeriesMapper;
import org.esa.beam.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.beam.timeseries.core.timeseries.datamodel.TimeCoding;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.io.BeamFileChooser;
import org.esa.beam.util.io.BeamFileFilter;
import org.esa.beam.util.kmz.KmlFeature;
import org.esa.beam.util.kmz.KmlFolder;
import org.esa.beam.util.kmz.KmlGroundOverlay;
import org.esa.beam.util.kmz.KmzExporter;
import org.esa.beam.visat.VisatApp;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ExportTimeBasedKmz
extends ExecCommand {
    private static final String IMAGE_EXPORT_DIR_PREFERENCES_KEY = "user.image.export.dir";
    private final BeamFileFilter kmzFileFilter = new BeamFileFilter("KMZ", "kmz", "KMZ - Google Earth File Format");
    private int level = 2;
    private ProductSceneView view;

    public void actionPerformed(CommandEvent event) {
        VisatApp app = VisatApp.getApp();
        this.view = app.getSelectedProductSceneView();
        GeoCoding geoCoding = this.view.getProduct().getGeoCoding();
        boolean isGeographic = false;
        if (geoCoding instanceof MapGeoCoding) {
            MapGeoCoding mapGeoCoding = (MapGeoCoding)geoCoding;
            MapTransformDescriptor transformDescriptor = mapGeoCoding.getMapInfo().getMapProjection().getMapTransform().getDescriptor();
            String typeID = transformDescriptor.getTypeID();
            if (typeID.equals("Identity")) {
                isGeographic = true;
            }
        } else if (geoCoding instanceof CrsGeoCoding) {
            isGeographic = CRS.equalsIgnoreMetadata((Object)geoCoding.getMapCRS(), (Object)DefaultGeographicCRS.WGS84);
        }
        if (isGeographic) {
            File output = this.fetchOutputFile(this.view);
            if (output == null) {
                return;
            }
            String title = "KMZ Export";
            KmzSwingWorker worker = new KmzSwingWorker("KMZ Export", output, app);
            worker.executeWithBlocking();
        } else {
            String message = "Product must be in ''Geographic Lat/Lon'' projection.";
            app.showInfoDialog(message, null);
        }
    }

    protected File fetchOutputFile(ProductSceneView sceneView) {
        VisatApp visatApp = VisatApp.getApp();
        String lastDir = visatApp.getPreferences().getPropertyString(IMAGE_EXPORT_DIR_PREFERENCES_KEY, SystemUtils.getUserHomeDir().getPath());
        File currentDir = new File(lastDir);
        BeamFileChooser fileChooser = new BeamFileChooser();
        HelpSys.enableHelpKey((Component)fileChooser, (String)this.getHelpId());
        fileChooser.setCurrentDirectory(currentDir);
        fileChooser.addChoosableFileFilter((FileFilter)this.kmzFileFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setDialogTitle(visatApp.getAppName() + " - " + "Export time series as time based KMZ");
        RasterDataNode refRaster = sceneView.getRaster();
        fileChooser.setCurrentFilename("time_series_" + refRaster.getName());
        fileChooser.setFileSelectionMode(0);
        Dimension fileChooserSize = fileChooser.getPreferredSize();
        if (fileChooserSize != null) {
            fileChooser.setPreferredSize(new Dimension(fileChooserSize.width + 120, fileChooserSize.height));
        } else {
            fileChooser.setPreferredSize(new Dimension(512, 256));
        }
        int maxLevel = refRaster.getSourceImage().getModel().getLevelCount() - 1;
        maxLevel = maxLevel > 10 ? 10 : maxLevel;
        JPanel levelPanel = new JPanel(new GridLayout(maxLevel, 1));
        levelPanel.setBorder(BorderFactory.createTitledBorder("Resolution Level"));
        ButtonGroup buttonGroup = new ButtonGroup();
        RadioButtonActionListener radioButtonListener = new RadioButtonActionListener();
        for (int i = 0; i < maxLevel; ++i) {
            String buttonText = Integer.toString(i);
            if (i == 0) {
                buttonText = buttonText + " (high, very slow)";
            } else if (i == maxLevel - 1) {
                buttonText = buttonText + " (low, fast)";
            }
            JRadioButton button = new JRadioButton(buttonText, true);
            buttonGroup.add(button);
            levelPanel.add(button);
            button.addActionListener(radioButtonListener);
        }
        JPanel accessory = new JPanel();
        accessory.setLayout(new BoxLayout(accessory, 1));
        accessory.add(levelPanel);
        fileChooser.setAccessory((JComponent)accessory);
        int result = fileChooser.showSaveDialog((Component)visatApp.getMainFrame());
        File file = fileChooser.getSelectedFile();
        File currentDirectory = fileChooser.getCurrentDirectory();
        if (currentDirectory != null) {
            visatApp.getPreferences().setPropertyString(IMAGE_EXPORT_DIR_PREFERENCES_KEY, currentDirectory.getPath());
        }
        if (result != 0) {
            return null;
        }
        if (file == null || file.getName().isEmpty()) {
            return null;
        }
        if (!visatApp.promptForOverwrite(file)) {
            return null;
        }
        return file;
    }

    private KmlFeature createKmlFeature() {
        if (this.view.isRGB()) {
            return null;
        }
        TimeSeriesMapper timeSeriesMapper = TimeSeriesMapper.getInstance();
        AbstractTimeSeries timeSeries = timeSeriesMapper.getTimeSeries(this.view.getProduct());
        List<Band> bands = timeSeries.getBandsForVariable(AbstractTimeSeries.rasterToVariableName(this.view.getRaster().getName()));
        if (bands.isEmpty()) {
            return null;
        }
        RasterDataNode refRaster = (RasterDataNode)bands.get(0);
        KmlFolder folder = new KmlFolder(refRaster.getName(), refRaster.getDescription());
        for (RasterDataNode rasterDataNode : bands) {
            GeoCoding geoCoding = rasterDataNode.getGeoCoding();
            PixelPos upperLeftPP = new PixelPos(0.0f, 0.0f);
            PixelPos lowerRightPP = new PixelPos((float)rasterDataNode.getSceneRasterWidth(), (float)rasterDataNode.getSceneRasterHeight());
            GeoPos upperLeftGP = geoCoding.getGeoPos(upperLeftPP, null);
            GeoPos lowerRightGP = geoCoding.getGeoPos(lowerRightPP, null);
            double north = upperLeftGP.getLat();
            double south = lowerRightGP.getLat();
            double east = lowerRightGP.getLon();
            double west = upperLeftGP.getLon();
            if (geoCoding.isCrossingMeridianAt180()) {
                east += 360.0;
            }
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(west, east, north, south, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            TimeCoding timeCoding = timeSeries.getRasterTimeMap().get(rasterDataNode);
            if (timeCoding == null) continue;
            ProductData.UTC startTime = timeCoding.getStartTime();
            ProductData.UTC endTime = timeCoding.getEndTime();
            ImageManager imageManager = ImageManager.getInstance();
            ImageInfo imageInfo = rasterDataNode.getImageInfo(ProgressMonitor.NULL);
            RenderedImage levelImage = imageManager.createColoredBandImage(new RasterDataNode[]{rasterDataNode}, imageInfo, this.level);
            String name = rasterDataNode.getName();
            KmlGroundOverlay groundOverlay = new KmlGroundOverlay(name, levelImage, (BoundingBox)referencedEnvelope, startTime, endTime);
            groundOverlay.setIconName(name + rasterDataNode.getProduct().getRefNo());
            folder.addChild((KmlFeature)groundOverlay);
        }
        return folder;
    }

    public void updateState(CommandEvent event) {
        ProductSceneView view = VisatApp.getApp().getSelectedProductSceneView();
        this.setEnabled(view != null);
    }

    private class KmzSwingWorker
    extends ProgressMonitorSwingWorker {
        private final String title;
        private final File output;
        private final VisatApp app;
        private static final int ONE_MEGABYTE = 1036288;

        KmzSwingWorker(String title, File output, VisatApp app) {
            super((Component)ExportTimeBasedKmz.this.view, title);
            this.title = title;
            this.output = output;
            this.app = app;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground(ProgressMonitor pm) throws Exception {
            KmlFeature kmlFeature = ExportTimeBasedKmz.this.createKmlFeature();
            FileOutputStream fileOutputStream = new FileOutputStream(this.output);
            try (ZipOutputStream zipStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream, 5181440));){
                KmzExporter exporter = new KmzExporter();
                exporter.export(kmlFeature, zipStream, pm);
            }
            return null;
        }

        protected void done() {
            Throwable exception = null;
            try {
                this.get();
            }
            catch (InterruptedException e) {
                exception = e;
            }
            catch (ExecutionException e) {
                exception = e.getCause();
            }
            if (exception != null) {
                String message = String.format("Error occurred while exporting to KMZ.%n%s", exception.getMessage());
                this.app.showErrorDialog(this.title, message);
            }
        }
    }

    private class RadioButtonActionListener
    implements ActionListener {
        private RadioButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButton button = (JRadioButton)e.getSource();
            if (button.isSelected()) {
                String buttonText = button.getText();
                int index = buttonText.indexOf(" (");
                if (index != -1) {
                    buttonText = buttonText.substring(0, index);
                }
                ExportTimeBasedKmz.this.level = Integer.parseInt(buttonText);
            }
        }
    }
}

