/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.export.text;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.esa.beam.framework.datamodel.RasterDataNode;

abstract class CsvExporter {
    final List<String> header;
    final List<String> columns;
    final List<String> rows;
    private final PrintWriter out;

    CsvExporter(PrintWriter writer) {
        this.out = writer;
        this.header = new ArrayList<String>();
        this.columns = new ArrayList<String>();
        this.rows = new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportCsv(ProgressMonitor pm) {
        this.setUpHeader();
        this.setUpColumns();
        this.setUpRows(pm);
        StringBuilder builder = new StringBuilder();
        String sep = this.getSeparator();
        for (String headerString : this.header) {
            builder.append("#").append(headerString).append("\n");
        }
        builder.append("\n");
        for (int i = 0; i < this.columns.size(); ++i) {
            String column = this.columns.get(i);
            builder.append(column);
            if (i >= this.columns.size() - 1) continue;
            builder.append(sep);
        }
        builder.append("\n");
        try {
            this.out.print(builder.toString());
            for (String row : this.rows) {
                this.out.print(row);
                this.out.print("\n");
            }
        }
        finally {
            if (this.out != null) {
                this.out.close();
            }
        }
    }

    abstract void setUpHeader();

    abstract void setUpColumns();

    abstract void setUpRows(ProgressMonitor var1);

    abstract String getSeparator();

    static double getValue(RasterDataNode raster, int pixelX, int pixelY, int currentLevel) {
        RenderedImage image = raster.getGeophysicalImage().getImage(currentLevel);
        Rectangle pixelRect = new Rectangle(pixelX, pixelY, 1, 1);
        Raster data = image.getData(pixelRect);
        MultiLevelImage validMaskImage = raster.getValidMaskImage();
        Raster validMaskData = null;
        if (validMaskImage != null) {
            RenderedImage validMask = validMaskImage.getImage(currentLevel);
            validMaskData = validMask.getData(pixelRect);
        }
        double value = validMaskData == null || validMaskData.getSample(pixelX, pixelY, 0) > 0 ? data.getSampleDouble(pixelX, pixelY, 0) : Double.NaN;
        return value;
    }
}

