/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.export.text;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.PlacemarkGroup;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.help.HelpSys;
import org.esa.beam.framework.ui.SelectExportMethodDialog;
import org.esa.beam.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.beam.timeseries.export.text.TimeCsvExporter;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.io.BeamFileChooser;
import org.esa.beam.util.io.BeamFileFilter;
import org.esa.beam.visat.VisatApp;

public class ExportTimeBasedText
extends ProgressMonitorSwingWorker<String, Void> {
    private static final String DLG_TITLE = "Exporting time series pin pixels";
    private static final String ERR_MSG_BASE = "Time series pin pixels cannot be exported:\n";
    private static final String EXPORT_DIR_PREFERENCES_KEY = "user.export.dir";
    private static final BeamFileFilter csvFileFilter = new BeamFileFilter("CSV", "csv", "Comma separated values");
    private final AbstractTimeSeries timeSeries;
    private final PrintWriter writer;
    private final StringBuffer clipboardText;

    private ExportTimeBasedText(Component parentComponent, AbstractTimeSeries timeSeries, PrintWriter writer, StringBuffer clipboardText) {
        super(parentComponent, DLG_TITLE);
        this.timeSeries = timeSeries;
        this.writer = writer;
        this.clipboardText = clipboardText;
    }

    protected String doInBackground(ProgressMonitor pm) throws Exception {
        ArrayList<List<Band>> bandList = new ArrayList<List<Band>>();
        List<String> timeVariables = this.timeSeries.getEoVariables();
        for (String timeVariable : timeVariables) {
            bandList.add(this.timeSeries.getBandsForVariable(timeVariable));
        }
        PlacemarkGroup pinGroup = this.timeSeries.getTsProduct().getPinGroup();
        ProductNode[] placemarkArray = pinGroup.toArray();
        if (placemarkArray.length == 0) {
            return "There are no pins which could be exported.";
        }
        ArrayList<Placemark> placemarks = new ArrayList<Placemark>();
        for (ProductNode placemark : placemarkArray) {
            placemarks.add((Placemark)placemark);
        }
        TimeCsvExporter exporter = new TimeCsvExporter(bandList, placemarks, this.writer);
        exporter.exportCsv(pm);
        return null;
    }

    public void done() {
        String errorMessage;
        try {
            errorMessage = (String)this.get();
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
        }
        if (errorMessage != null) {
            VisatApp.getApp().showErrorDialog(DLG_TITLE, ERR_MSG_BASE + errorMessage);
        } else if (this.clipboardText != null) {
            SystemUtils.copyToClipboard((String)this.clipboardText.toString());
            this.clipboardText.setLength(0);
        }
    }

    public static void export(Component parent, AbstractTimeSeries timeSeries, String helpID) {
        StringBuffer clipboardText;
        PrintWriter writer;
        String questionText = "How do you want to export the pixel values?\n";
        int method = SelectExportMethodDialog.run((Component)VisatApp.getApp().getMainFrame(), (String)DLG_TITLE, (String)"How do you want to export the pixel values?\n", (String)helpID);
        int initialBufferSize = 256000;
        if (method == 0) {
            StringWriter stringWriter = new StringWriter(256000);
            writer = new PrintWriter(stringWriter);
            clipboardText = stringWriter.getBuffer();
        } else if (method == 1) {
            FileWriter fileWriter;
            File file = ExportTimeBasedText.fetchOutputFile(helpID);
            if (file == null) {
                return;
            }
            try {
                fileWriter = new FileWriter(file);
            }
            catch (IOException e) {
                VisatApp.getApp().showErrorDialog(DLG_TITLE, "Time series pin pixels cannot be exported:\nFailed to create file '" + file + "':\n" + e.getMessage());
                return;
            }
            writer = new PrintWriter(new BufferedWriter(fileWriter, 256000));
            clipboardText = null;
        } else {
            return;
        }
        ExportTimeBasedText exportTimeBasedText = new ExportTimeBasedText(parent, timeSeries, writer, clipboardText);
        exportTimeBasedText.executeWithBlocking();
    }

    private static File fetchOutputFile(String helpID) {
        VisatApp visatApp = VisatApp.getApp();
        String lastDir = visatApp.getPreferences().getPropertyString(EXPORT_DIR_PREFERENCES_KEY, SystemUtils.getUserHomeDir().getPath());
        File currentDir = new File(lastDir);
        BeamFileChooser fileChooser = new BeamFileChooser();
        HelpSys.enableHelpKey((Component)fileChooser, (String)helpID);
        fileChooser.setCurrentDirectory(currentDir);
        fileChooser.addChoosableFileFilter((FileFilter)csvFileFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setDialogTitle(visatApp.getAppName() + " - " + "Export time series as CSV file...");
        fileChooser.setFileSelectionMode(0);
        Dimension fileChooserSize = fileChooser.getPreferredSize();
        if (fileChooserSize != null) {
            fileChooser.setPreferredSize(new Dimension(fileChooserSize.width + 120, fileChooserSize.height));
        } else {
            fileChooser.setPreferredSize(new Dimension(512, 256));
        }
        int result = fileChooser.showSaveDialog((Component)visatApp.getMainFrame());
        File file = fileChooser.getSelectedFile();
        File currentDirectory = fileChooser.getCurrentDirectory();
        if (currentDirectory != null) {
            visatApp.getPreferences().setPropertyString(EXPORT_DIR_PREFERENCES_KEY, currentDirectory.getPath());
        }
        if (result != 0) {
            return null;
        }
        if (file == null || file.getName().isEmpty()) {
            return null;
        }
        if (!visatApp.promptForOverwrite(file)) {
            return null;
        }
        return file;
    }
}

