/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.export.text;

import com.bc.ceres.core.ProgressMonitor;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.ui.product.ProductSceneView;
import org.esa.beam.timeseries.core.TimeSeriesMapper;
import org.esa.beam.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.beam.timeseries.core.timeseries.datamodel.TimeCoding;
import org.esa.beam.timeseries.export.text.CsvExporter;
import org.esa.beam.visat.VisatApp;

class TimeCsvExporter
extends CsvExporter {
    private final List<List<Band>> variablesList;
    private final List<Placemark> pins;
    private final int level;
    private final boolean exportImageCoords = true;
    private final boolean exportLonLat = true;
    private final boolean exportUnit = true;

    TimeCsvExporter(List<List<Band>> rasterList, List<Placemark> pins, PrintWriter writer) {
        super(writer);
        this.variablesList = new ArrayList<List<Band>>(rasterList);
        this.pins = new ArrayList<Placemark>(pins);
        this.level = 0;
    }

    @Override
    void setUpHeader() {
        if (!this.variablesList.isEmpty()) {
            // empty if block
        }
        this.header.add("Time Series Tool pin time series export table");
        this.header.add("");
        this.header.add("Product:\t" + this.resolveProductName());
        this.header.add("Created on:\t" + new Date());
    }

    private String resolveProductName() {
        for (List<Band> bandList : this.variablesList) {
            if (bandList.isEmpty()) continue;
            for (Band band : bandList) {
                if (band == null) continue;
                return band.getProduct().getName();
            }
        }
        return "Time Series Product";
    }

    @Override
    void setUpColumns() {
        this.columns.add("Name");
        this.columns.add("X");
        this.columns.add("Y");
        this.columns.add("Lon");
        this.columns.add("Lat");
        this.columns.add("Variable");
        this.columns.add("Unit");
        ProductSceneView sceneView = VisatApp.getApp().getSelectedProductSceneView();
        AbstractTimeSeries timeSeries = TimeSeriesMapper.getInstance().getTimeSeries(sceneView.getProduct());
        for (List<Band> bandList : this.variablesList) {
            if (bandList.isEmpty()) continue;
            for (Band band : bandList) {
                TimeCoding timeCoding = timeSeries.getRasterTimeMap().get(band);
                if (timeCoding == null) continue;
                Date date = timeCoding.getStartTime().getAsDate();
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy", Locale.getDefault());
                this.columns.add(sdf.format(date));
            }
        }
    }

    @Override
    void setUpRows(ProgressMonitor pm) {
        pm.beginTask("Exporting pin data as csv-file...", this.pins.size());
        for (Placemark pin : this.pins) {
            for (List<Band> bandList : this.variablesList) {
                if (bandList.isEmpty()) continue;
                this.rows.add(this.setUpRow(pin, bandList));
            }
            pm.worked(1);
        }
        pm.done();
    }

    private String setUpRow(Placemark pin, List<Band> bandList) {
        Band refBand = bandList.get(0);
        StringBuilder row = new StringBuilder();
        row.append(pin.getLabel());
        row.append(this.getSeparator());
        PixelPos pixelPos = pin.getPixelPos();
        this.exportImageCoords(row, pixelPos);
        this.exportLatLon(refBand, row, pixelPos);
        row.append(AbstractTimeSeries.rasterToVariableName(refBand.getName()));
        row.append(this.getSeparator());
        row.append(refBand.getUnit());
        row.append(this.getSeparator());
        for (int i = 0; i < bandList.size(); ++i) {
            Band band = bandList.get(i);
            row.append(TimeCsvExporter.getValue((RasterDataNode)band, (int)pixelPos.x, (int)pixelPos.y, this.level));
            if (i >= bandList.size() - 1) continue;
            row.append(this.getSeparator());
        }
        return row.toString();
    }

    private void exportLatLon(Band refBand, StringBuilder row, PixelPos pixelPos) {
        GeoPos geoPos = new GeoPos();
        refBand.getGeoCoding().getGeoPos(pixelPos, geoPos);
        row.append(geoPos.getLon());
        row.append(this.getSeparator());
        row.append(geoPos.getLat());
        row.append(this.getSeparator());
    }

    private void exportImageCoords(StringBuilder row, PixelPos pixelPos) {
        DecimalFormat formatter = new DecimalFormat("0.000");
        row.append(formatter.format(pixelPos.getX()));
        row.append(this.getSeparator());
        row.append(formatter.format(pixelPos.getY()));
        row.append(this.getSeparator());
    }

    @Override
    String getSeparator() {
        return "\t";
    }
}

