/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import org.esa.beam.timeseries.core.timeseries.datamodel.ProductLocation;
import org.esa.beam.timeseries.core.timeseries.datamodel.ProductLocationType;
import org.esa.beam.timeseries.ui.ProductLocationsPaneModel;

public class DefaultProductLocationsPaneModel
extends AbstractListModel
implements ProductLocationsPaneModel {
    private final List<ProductLocation> productLocationList = new ArrayList<ProductLocation>();

    @Override
    public int getSize() {
        return this.productLocationList.size();
    }

    @Override
    public ProductLocation getElementAt(int index) {
        return this.productLocationList.get(index);
    }

    @Override
    public void addFiles(File ... files) {
        int startIndex = this.productLocationList.size();
        for (File file : files) {
            this.productLocationList.add(new ProductLocation(ProductLocationType.FILE, file.getAbsolutePath()));
        }
        int stopIndex = this.productLocationList.size() - 1;
        this.fireIntervalAdded(this, startIndex, stopIndex);
    }

    @Override
    public void addDirectory(File directory, boolean recursive) {
        ProductLocationType locationType = recursive ? ProductLocationType.DIRECTORY_REC : ProductLocationType.DIRECTORY;
        this.productLocationList.add(new ProductLocation(locationType, directory.getPath()));
        int index = this.productLocationList.size() - 1;
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void remove(int ... indices) {
        if (indices.length > 0) {
            ArrayList<ProductLocation> toRemoveList = new ArrayList<ProductLocation>();
            for (int index : indices) {
                toRemoveList.add(this.productLocationList.get(index));
            }
            this.productLocationList.removeAll(toRemoveList);
            this.fireContentsChanged(this, indices[0], indices[indices.length - 1]);
        }
    }

    @Override
    public List<ProductLocation> getProductLocations() {
        return new ArrayList<ProductLocation>(this.productLocationList);
    }
}

