/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import org.esa.beam.timeseries.ui.Variable;
import org.esa.beam.timeseries.ui.VariableSelectionPaneModel;

public class DefaultVariableSelectionPaneModel
extends AbstractListModel
implements VariableSelectionPaneModel {
    private final List<Variable> variableList = new ArrayList<Variable>();

    @Override
    public int getSize() {
        return this.variableList.size();
    }

    @Override
    public Variable getElementAt(int index) {
        return this.variableList.get(index);
    }

    @Override
    public void set(Variable ... variables) {
        int index = this.variableList.size();
        this.variableList.clear();
        this.fireIntervalRemoved(this, 0, index);
        this.add(variables);
    }

    @Override
    public void add(Variable ... variables) {
        int startIndex = this.variableList.size();
        this.variableList.addAll(Arrays.asList(variables));
        int stopIndex = Math.max(0, this.variableList.size() - 1);
        this.fireIntervalAdded(this, startIndex, stopIndex);
    }

    @Override
    public void setSelectedVariableAt(int index, boolean selected) {
        Variable variable = this.variableList.get(index);
        if (variable.isSelected() != selected) {
            variable.setSelected(selected);
            this.fireContentsChanged(this, index, index);
        }
    }

    @Override
    public List<String> getSelectedVariableNames() {
        ArrayList<String> nameList = new ArrayList<String>();
        for (Variable variable : this.variableList) {
            if (!variable.isSelected()) continue;
            nameList.add(variable.getName());
        }
        return nameList;
    }
}

