/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.ui;

import com.bc.ceres.swing.TableLayout;
import com.jidesoft.swing.FolderChooser;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.esa.beam.framework.dataio.ProductIOPlugIn;
import org.esa.beam.framework.dataio.ProductIOPlugInManager;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.tool.ToolButtonFactory;
import org.esa.beam.timeseries.core.timeseries.datamodel.ProductLocation;
import org.esa.beam.timeseries.core.timeseries.datamodel.ProductLocationType;
import org.esa.beam.timeseries.ui.DefaultProductLocationsPaneModel;
import org.esa.beam.timeseries.ui.ProductLocationsPaneModel;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.io.BeamFileChooser;
import org.esa.beam.util.io.BeamFileFilter;
import org.esa.beam.visat.VisatApp;

public class ProductLocationsPane
extends JPanel {
    private static final String PROPERTY_KEY_LAST_OPEN_TS_DIR = "timeseries.file.lastOpenDir";
    private ProductLocationsPaneModel model;
    private JList sourceList;
    private AbstractButton addButton;
    private AbstractButton removeButton;

    public ProductLocationsPane() {
        this(new DefaultProductLocationsPaneModel());
    }

    public ProductLocationsPane(ProductLocationsPaneModel model) {
        this.model = model;
        this.createPane();
    }

    public void setModel(ProductLocationsPaneModel model, boolean enabled) {
        this.model = model;
        this.updatePane(enabled);
    }

    private void createPane() {
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setColumnFill(0, TableLayout.Fill.BOTH);
        tableLayout.setColumnFill(1, TableLayout.Fill.HORIZONTAL);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setTableWeightY(Double.valueOf(1.0));
        tableLayout.setColumnWeightX(0, Double.valueOf(1.0));
        tableLayout.setColumnWeightX(1, Double.valueOf(0.0));
        tableLayout.setColumnWeightY(1, Double.valueOf(0.0));
        tableLayout.setCellRowspan(0, 0, Integer.valueOf(2));
        this.setLayout((LayoutManager)tableLayout);
        this.sourceList = new JList(this.model);
        this.sourceList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof ProductLocation) {
                    ProductLocation location = (ProductLocation)value;
                    String path = location.getPath();
                    if (location.getProductLocationType() != ProductLocationType.FILE && !path.endsWith(File.separator)) {
                        path = path + File.separator;
                    }
                    if (location.getProductLocationType() == ProductLocationType.DIRECTORY) {
                        path = path + "*";
                    }
                    if (location.getProductLocationType() == ProductLocationType.DIRECTORY_REC) {
                        path = path + "**";
                    }
                    label.setText(path);
                }
                return label;
            }
        });
        this.addButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Plus24.gif"), (boolean)false);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = new JPopupMenu("Add");
                Rectangle buttonBounds = ProductLocationsPane.this.addButton.getBounds();
                popup.add(new AddDirectoryAction(false));
                popup.add(new AddDirectoryAction(true));
                popup.add(new AddFileAction());
                popup.show(ProductLocationsPane.this.addButton, 1, buttonBounds.height + 1);
            }
        });
        this.removeButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Minus24.gif"), (boolean)false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLocationsPane.this.model.remove(ProductLocationsPane.this.sourceList.getSelectedIndices());
            }
        });
        this.add(new JScrollPane(this.sourceList));
        this.add(this.addButton);
        this.add((Component)this.removeButton, TableLayout.cell((int)1, (int)1));
    }

    private void updatePane(boolean enabled) {
        this.sourceList.setModel(this.model);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
    }

    private class AddFileAction
    extends AbstractAction {
        private AddFileAction() {
            super("Add Product(s)");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VisatApp visatApp = VisatApp.getApp();
            PropertyMap preferences = visatApp.getPreferences();
            String lastDir = preferences.getPropertyString(ProductLocationsPane.PROPERTY_KEY_LAST_OPEN_TS_DIR, SystemUtils.getUserHomeDir().getPath());
            String lastFormat = preferences.getPropertyString("app.file.lastOpenFormat", "ALL_FILES");
            BeamFileChooser fileChooser = new BeamFileChooser();
            fileChooser.setCurrentDirectory(new File(lastDir));
            fileChooser.setAcceptAllFileFilterUsed(true);
            fileChooser.setDialogTitle("Select Product(s)");
            fileChooser.setMultiSelectionEnabled(true);
            FileFilter actualFileFilter = fileChooser.getAcceptAllFileFilter();
            Iterator allReaderPlugIns = ProductIOPlugInManager.getInstance().getAllReaderPlugIns();
            while (allReaderPlugIns.hasNext()) {
                ProductIOPlugIn plugIn = (ProductIOPlugIn)allReaderPlugIns.next();
                BeamFileFilter productFileFilter = plugIn.getProductFileFilter();
                fileChooser.addChoosableFileFilter((FileFilter)productFileFilter);
                if ("ALL_FILES".equals(lastFormat) || !productFileFilter.getFormatName().equals(lastFormat)) continue;
                actualFileFilter = productFileFilter;
            }
            fileChooser.setFileFilter(actualFileFilter);
            int result = fileChooser.showDialog((Component)visatApp.getMainFrame(), "Open Product");
            if (result != 0) {
                return;
            }
            String currentDir = fileChooser.getCurrentDirectory().getAbsolutePath();
            if (currentDir != null) {
                preferences.setPropertyString(ProductLocationsPane.PROPERTY_KEY_LAST_OPEN_TS_DIR, currentDir);
            }
            if (fileChooser.getFileFilter() instanceof BeamFileFilter) {
                String currentFormat = ((BeamFileFilter)fileChooser.getFileFilter()).getFormatName();
                if (currentFormat != null) {
                    preferences.setPropertyString("app.file.lastOpenFormat", currentFormat);
                }
            } else {
                preferences.setPropertyString("app.file.lastOpenFormat", "ALL_FILES");
            }
            File[] selectedFiles = fileChooser.getSelectedFiles();
            ProductLocationsPane.this.model.addFiles(selectedFiles);
        }
    }

    private class AddDirectoryAction
    extends AbstractAction {
        private boolean recursive;

        private AddDirectoryAction(boolean recursive) {
            this("Add Directory" + (recursive ? " Recursive" : ""));
            this.recursive = recursive;
        }

        protected AddDirectoryAction(String title) {
            super(title);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FolderChooser folderChooser = new FolderChooser();
            VisatApp visatApp = VisatApp.getApp();
            PropertyMap preferences = visatApp.getPreferences();
            String lastDir = preferences.getPropertyString(ProductLocationsPane.PROPERTY_KEY_LAST_OPEN_TS_DIR, SystemUtils.getUserHomeDir().getPath());
            folderChooser.setCurrentDirectory(new File(lastDir));
            int result = folderChooser.showOpenDialog((Component)ProductLocationsPane.this);
            if (result != 0) {
                return;
            }
            File currentDir = folderChooser.getSelectedFolder();
            ProductLocationsPane.this.model.addDirectory(currentDir, this.recursive);
            if (currentDir != null) {
                preferences.setPropertyString(ProductLocationsPane.PROPERTY_KEY_LAST_OPEN_TS_DIR, currentDir.getAbsolutePath());
            }
        }
    }
}

