/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.ui;

import com.bc.ceres.swing.TableLayout;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.CheckBoxListSelectionModel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.beam.timeseries.ui.DefaultVariableSelectionPaneModel;
import org.esa.beam.timeseries.ui.Variable;
import org.esa.beam.timeseries.ui.VariableSelectionPaneModel;

public class VariableSelectionPane
extends JPanel {
    private VariableSelectionPaneModel model;
    private CheckBoxList variableList;
    private CheckBoxSelectionListener checkBoxSelectionListener;

    public VariableSelectionPane() {
        this(new DefaultVariableSelectionPaneModel());
    }

    public VariableSelectionPane(VariableSelectionPaneModel variableSelectionPaneModel) {
        this.model = variableSelectionPaneModel;
        this.createPane();
    }

    public void setModel(VariableSelectionPaneModel model) {
        this.model = model;
        this.updatePane();
    }

    public VariableSelectionPaneModel getModel() {
        return this.model;
    }

    private void createPane() {
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setTableWeightY(Double.valueOf(1.0));
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        this.setLayout((LayoutManager)tableLayout);
        this.variableList = new CheckBoxList((ListModel)this.model);
        this.variableList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof Variable) {
                    Variable variable = (Variable)value;
                    label.setText(variable.getName());
                }
                return label;
            }
        });
        this.variableList.setSelectionMode(0);
        this.checkBoxSelectionListener = new CheckBoxSelectionListener(this.variableList);
        this.variableList.getCheckBoxListSelectionModel().addListSelectionListener((ListSelectionListener)this.checkBoxSelectionListener);
        this.add(new JScrollPane((Component)this.variableList));
    }

    private void updatePane() {
        this.variableList.getCheckBoxListSelectionModel().removeListSelectionListener((ListSelectionListener)this.checkBoxSelectionListener);
        this.variableList.setModel((ListModel)this.model);
        this.variableList.setCheckBoxListSelectedIndices(this.getSelectedIndices(this.model));
        CheckBoxListSelectionModel selectionModel = this.variableList.getCheckBoxListSelectionModel();
        selectionModel.addListSelectionListener((ListSelectionListener)this.checkBoxSelectionListener);
    }

    private int[] getSelectedIndices(VariableSelectionPaneModel variableModel) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i = 0; i < variableModel.getSize(); ++i) {
            if (!variableModel.getElementAt(i).isSelected()) continue;
            indexList.add(i);
        }
        int[] indices = new int[indexList.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)indexList.get(i);
        }
        return indices;
    }

    private class CheckBoxSelectionListener
    implements ListSelectionListener {
        private final CheckBoxList variableList;

        private CheckBoxSelectionListener(CheckBoxList variableList) {
            this.variableList = variableList;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                CheckBoxListSelectionModel selectionModel = this.variableList.getCheckBoxListSelectionModel();
                for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                    VariableSelectionPane.this.model.setSelectedVariableAt(i, selectionModel.isSelectedIndex(i));
                }
            }
        }
    }
}

