/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.ui.assistant;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.esa.beam.timeseries.ui.DefaultProductLocationsPaneModel;
import org.esa.beam.timeseries.ui.DefaultVariableSelectionPaneModel;
import org.esa.beam.timeseries.ui.ProductLocationsPaneModel;
import org.esa.beam.timeseries.ui.VariableSelectionPaneModel;

class TimeSeriesAssistantModel {
    private final ProductLocationsPaneModel productLocationsModel;
    private final VariableSelectionPaneModel variableSelectionPaneModel;
    private String timeSeriesName;
    private List<ChangeListener> changeListenerList;

    TimeSeriesAssistantModel() {
        this(new DefaultProductLocationsPaneModel(), new DefaultVariableSelectionPaneModel());
    }

    private TimeSeriesAssistantModel(ProductLocationsPaneModel productLocationsModel, VariableSelectionPaneModel variableSelectionPaneModel) {
        this.productLocationsModel = productLocationsModel;
        this.variableSelectionPaneModel = variableSelectionPaneModel;
        this.timeSeriesName = "TimeSeries";
        ListDataListenerDelegate dataListenerDelegate = new ListDataListenerDelegate();
        productLocationsModel.addListDataListener(dataListenerDelegate);
        variableSelectionPaneModel.addListDataListener(dataListenerDelegate);
    }

    public ProductLocationsPaneModel getProductLocationsModel() {
        return this.productLocationsModel;
    }

    public VariableSelectionPaneModel getVariableSelectionModel() {
        return this.variableSelectionPaneModel;
    }

    public void setTimeSeriesName(String timeSeriesName) {
        if (!this.timeSeriesName.equals(timeSeriesName)) {
            this.timeSeriesName = timeSeriesName;
            this.fireChangeEvent();
        }
    }

    public String getTimeSeriesName() {
        return this.timeSeriesName;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeListenerList == null) {
            this.changeListenerList = new ArrayList<ChangeListener>();
        }
        if (!this.changeListenerList.contains(changeListener)) {
            this.changeListenerList.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListenerList != null) {
            this.changeListenerList.remove(changeListener);
        }
    }

    private void fireChangeEvent() {
        if (this.changeListenerList != null) {
            for (ChangeListener changeListener : this.changeListenerList) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }
    }

    private class ListDataListenerDelegate
    implements ListDataListener {
        private ListDataListenerDelegate() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            TimeSeriesAssistantModel.this.fireChangeEvent();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            TimeSeriesAssistantModel.this.fireChangeEvent();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            TimeSeriesAssistantModel.this.fireChangeEvent();
        }
    }
}

