/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.ui.graph;

import com.bc.jexp.ParseException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.ui.product.ProductSceneView;
import org.esa.beam.timeseries.core.TimeSeriesMapper;
import org.esa.beam.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.beam.timeseries.core.timeseries.datamodel.AxisMapping;
import org.esa.beam.timeseries.core.timeseries.datamodel.TimeCoding;
import org.esa.beam.timeseries.ui.graph.TimeSeriesGraphDisplayController;
import org.esa.beam.timeseries.ui.graph.TimeSeriesGraphUpdater;
import org.esa.beam.timeseries.ui.graph.TimeSeriesType;
import org.esa.beam.timeseries.ui.graph.WorkerChain;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.logging.BeamLogManager;
import org.esa.beam.visat.VisatApp;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYErrorRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

class TimeSeriesGraphModel
implements TimeSeriesGraphUpdater.TimeSeriesDataHandler,
TimeSeriesGraphDisplayController.PinSupport {
    private static final String QUALIFIER_RASTER = "_r_";
    private static final String QUALIFIER_INSITU = "_i_";
    private static final Color DEFAULT_FOREGROUND_COLOR = Color.BLACK;
    private static final Color DEFAULT_BACKGROUND_COLOR = new Color(225, 225, 225);
    private static final String NO_DATA_MESSAGE = "No data to display";
    private static final int CURSOR_COLLECTION_INDEX_OFFSET = 0;
    private static final int PIN_COLLECTION_INDEX_OFFSET = 1;
    private static final int INSITU_COLLECTION_INDEX_OFFSET = 2;
    private static final Stroke PIN_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);
    private static final Stroke CURSOR_STROKE = new BasicStroke();
    private final Map<AbstractTimeSeries, TimeSeriesGraphDisplayController> displayControllerMap;
    private final XYPlot timeSeriesPlot;
    private final List<List<Band>> eoVariableBands;
    private final AtomicInteger version = new AtomicInteger(0);
    private final TimeSeriesGraphUpdater.WorkerChainSupport workerChainSupport;
    private final Validation validation;
    private final WorkerChain workerChain;
    private final Map<String, Paint> paintMap = new HashMap<String, Paint>();
    private TimeSeriesGraphDisplayController displayController;
    private boolean isShowingSelectedPins;
    private boolean isShowingAllPins;
    private AxisMapping displayAxisMapping;
    private boolean showCursorTimeSeries = true;

    TimeSeriesGraphModel(XYPlot plot, Validation validation) {
        this.timeSeriesPlot = plot;
        this.validation = validation;
        validation.addValidationListener(new ValidationListener(){

            @Override
            public void expressionChanged() {
                TimeSeriesGraphModel.this.updateTimeSeries(null, TimeSeriesType.INSITU);
                TimeSeriesGraphModel.this.updateTimeSeries(null, TimeSeriesType.PIN);
            }
        });
        this.eoVariableBands = new ArrayList<List<Band>>();
        this.displayControllerMap = new WeakHashMap<AbstractTimeSeries, TimeSeriesGraphDisplayController>();
        this.workerChainSupport = this.createWorkerChainSupport();
        this.workerChain = new WorkerChain();
        this.initPlot();
    }

    void adaptToTimeSeries(AbstractTimeSeries timeSeries) {
        boolean hasData;
        this.version.incrementAndGet();
        this.eoVariableBands.clear();
        boolean bl = hasData = timeSeries != null;
        if (hasData) {
            this.displayController = this.displayControllerMap.get(timeSeries);
            if (this.displayController == null) {
                this.displayController = new TimeSeriesGraphDisplayController(this);
                this.displayControllerMap.put(timeSeries, this.displayController);
            }
            this.displayController.adaptTo(timeSeries);
            for (String eoVariableName : this.displayController.getEoVariablesToDisplay()) {
                this.eoVariableBands.add(timeSeries.getBandsForVariable(eoVariableName));
            }
            this.displayAxisMapping = this.createDisplayAxisMapping(timeSeries);
        } else {
            this.displayAxisMapping = new AxisMapping();
        }
        this.validation.adaptTo(timeSeries, this.displayAxisMapping);
        this.updatePlot(hasData);
    }

    AtomicInteger getVersion() {
        return this.version;
    }

    void updateAnnotation(RasterDataNode raster) {
        this.removeAnnotation();
        AbstractTimeSeries timeSeries = this.getTimeSeries();
        TimeCoding timeCoding = timeSeries.getRasterTimeMap().get(raster);
        if (timeCoding != null) {
            ProductData.UTC startTime = timeCoding.getStartTime();
            Millisecond timePeriod = new Millisecond(startTime.getAsDate(), ProductData.UTC.UTC_TIME_ZONE, Locale.getDefault());
            double millisecond = timePeriod.getFirstMillisecond();
            Range valueRange = null;
            for (int i = 0; i < this.timeSeriesPlot.getRangeAxisCount(); ++i) {
                valueRange = Range.combine(valueRange, (Range)this.timeSeriesPlot.getRangeAxis(i).getRange());
            }
            if (valueRange != null) {
                XYLineAnnotation annotation = new XYLineAnnotation(millisecond, valueRange.getLowerBound(), millisecond, valueRange.getUpperBound());
                this.timeSeriesPlot.addAnnotation((XYAnnotation)annotation, true);
            }
        }
    }

    void removeAnnotation() {
        this.timeSeriesPlot.clearAnnotations();
    }

    void setIsShowingSelectedPins(boolean isShowingSelectedPins) {
        if (isShowingSelectedPins && this.isShowingAllPins) {
            throw new IllegalStateException("isShowingSelectedPins && isShowingAllPins");
        }
        this.isShowingSelectedPins = isShowingSelectedPins;
        this.updateTimeSeries(null, TimeSeriesType.PIN);
        this.updateTimeSeries(null, TimeSeriesType.INSITU);
    }

    void setIsShowingAllPins(boolean isShowingAllPins) {
        if (isShowingAllPins && this.isShowingSelectedPins) {
            throw new IllegalStateException("isShowingAllPins && isShowingSelectedPins");
        }
        this.isShowingAllPins = isShowingAllPins;
        this.updateTimeSeries(null, TimeSeriesType.PIN);
        this.updateTimeSeries(null, TimeSeriesType.INSITU);
    }

    void setIsShowingCursorTimeSeries(boolean showCursorTimeSeries) {
        this.showCursorTimeSeries = showCursorTimeSeries;
    }

    synchronized void updateTimeSeries(TimeSeriesGraphUpdater.Position cursorPosition, TimeSeriesType type) {
        if (this.getTimeSeries() == null) {
            return;
        }
        TimeSeriesGraphUpdater.PositionSupport positionSupport = this.createPositionSupport();
        TimeSeriesGraphUpdater w = new TimeSeriesGraphUpdater(this.getTimeSeries(), this.createVersionSafeDataSources(), this, this.displayAxisMapping, this.workerChainSupport, cursorPosition, positionSupport, type, this.showCursorTimeSeries, this.version.get());
        boolean chained = type != TimeSeriesType.CURSOR;
        this.workerChain.setOrExecuteNextWorker(w, chained);
    }

    boolean isShowCursorTimeSeries() {
        return this.showCursorTimeSeries;
    }

    @Override
    public void addTimeSeries(List<TimeSeries> timeSeriesList, TimeSeriesType type) {
        int collectionOffset;
        int timeSeriesCount;
        if (TimeSeriesType.INSITU.equals((Object)type)) {
            timeSeriesCount = this.displayAxisMapping.getInsituCount();
            collectionOffset = 2;
        } else {
            timeSeriesCount = this.displayAxisMapping.getRasterCount();
            collectionOffset = TimeSeriesType.CURSOR.equals((Object)type) ? 0 : 1;
        }
        String[] aliasNames = this.getAliasNames();
        for (int aliasIdx = 0; aliasIdx < aliasNames.length; ++aliasIdx) {
            int targetCollectionIndex = collectionOffset + aliasIdx * 3;
            TimeSeriesCollection targetTimeSeriesCollection = (TimeSeriesCollection)this.timeSeriesPlot.getDataset(targetCollectionIndex);
            if (targetTimeSeriesCollection == null) continue;
            targetTimeSeriesCollection.removeAllSeries();
        }
        if (timeSeriesCount == 0) {
            return;
        }
        int numPositions = timeSeriesList.size() / timeSeriesCount;
        int timeSeriesIndexOffset = 0;
        for (int posIdx = 0; posIdx < numPositions; ++posIdx) {
            Shape posShape = this.getShapeForPosition(type, posIdx);
            for (int aliasIdx = 0; aliasIdx < aliasNames.length; ++aliasIdx) {
                int targetCollectionIndex = collectionOffset + aliasIdx * 3;
                TimeSeriesCollection targetTimeSeriesCollection = (TimeSeriesCollection)this.timeSeriesPlot.getDataset(targetCollectionIndex);
                if (targetTimeSeriesCollection == null) continue;
                XYItemRenderer renderer = this.timeSeriesPlot.getRenderer(targetCollectionIndex);
                int dataSourceCount = this.getDataSourceCount(type, aliasNames[aliasIdx]);
                for (int ignoredIndex = 0; ignoredIndex < dataSourceCount; ++ignoredIndex) {
                    TimeSeries currentTimeSeries = timeSeriesList.get(timeSeriesIndexOffset);
                    targetTimeSeriesCollection.addSeries(currentTimeSeries);
                    int timeSeriesTargetIdx = targetTimeSeriesCollection.getSeriesCount() - 1;
                    renderer.setSeriesShape(timeSeriesTargetIdx, posShape);
                    renderer.setSeriesPaint(timeSeriesTargetIdx, renderer.getSeriesPaint(timeSeriesTargetIdx % dataSourceCount));
                    renderer.setSeriesVisibleInLegend(timeSeriesTargetIdx, Boolean.valueOf(!currentTimeSeries.isEmpty()));
                    ++timeSeriesIndexOffset;
                }
                ValueAxis axisForDataset = this.timeSeriesPlot.getDomainAxisForDataset(targetCollectionIndex);
                axisForDataset.configure();
            }
        }
        this.updateAnnotation(this.getCurrentView().getRaster());
    }

    @Override
    public TimeSeries getValidatedTimeSeries(TimeSeries timeSeries, String dataSourceName, TimeSeriesType type) {
        try {
            return this.validation.validate(timeSeries, dataSourceName, type);
        }
        catch (ParseException e) {
            BeamLogManager.getSystemLogger().log(Level.SEVERE, e.getMessage(), e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean isShowingSelectedPins() {
        return this.isShowingSelectedPins;
    }

    @Override
    public Placemark[] getSelectedPins() {
        return this.getCurrentView().getSelectedPins();
    }

    @Override
    public boolean isShowingAllPins() {
        return this.isShowingAllPins;
    }

    private TimeSeriesGraphUpdater.WorkerChainSupport createWorkerChainSupport() {
        return new TimeSeriesGraphUpdater.WorkerChainSupport(){

            @Override
            public void removeWorkerAndStartNext(TimeSeriesGraphUpdater worker) {
                TimeSeriesGraphModel.this.workerChain.removeCurrentWorkerAndExecuteNext(worker);
            }
        };
    }

    private TimeSeriesGraphUpdater.PositionSupport createPositionSupport() {
        return new TimeSeriesGraphUpdater.PositionSupport(){
            private final GeoCoding geoCoding;
            private final PixelPos pixelPos;
            {
                this.geoCoding = TimeSeriesGraphModel.this.getTimeSeries().getTsProduct().getGeoCoding();
                this.pixelPos = new PixelPos();
            }

            @Override
            public TimeSeriesGraphUpdater.Position transformGeoPos(GeoPos geoPos) {
                this.geoCoding.getPixelPos(geoPos, this.pixelPos);
                return new TimeSeriesGraphUpdater.Position((int)this.pixelPos.getX(), (int)this.pixelPos.getY(), 0);
            }
        };
    }

    private void initPlot() {
        ValueAxis domainAxis = this.timeSeriesPlot.getDomainAxis();
        domainAxis.setAutoRange(true);
        XYLineAndShapeRenderer xyRenderer = new XYLineAndShapeRenderer(true, true);
        xyRenderer.setBaseLegendTextPaint((Paint)DEFAULT_FOREGROUND_COLOR);
        this.timeSeriesPlot.setRenderer((XYItemRenderer)xyRenderer);
        this.timeSeriesPlot.setBackgroundPaint((Paint)DEFAULT_BACKGROUND_COLOR);
        this.timeSeriesPlot.setNoDataMessage(NO_DATA_MESSAGE);
        this.timeSeriesPlot.setDrawingSupplier(null);
    }

    private void updatePlot(boolean hasData) {
        for (int i = 0; i < this.timeSeriesPlot.getDatasetCount(); ++i) {
            this.timeSeriesPlot.setDataset(i, null);
        }
        this.timeSeriesPlot.clearRangeAxes();
        if (!hasData) {
            return;
        }
        this.paintMap.clear();
        Set<String> aliasNamesSet = this.displayAxisMapping.getAliasNames();
        String[] aliasNames = aliasNamesSet.toArray(new String[aliasNamesSet.size()]);
        for (String aliasName : aliasNamesSet) {
            this.consumeColors(aliasName, this.displayAxisMapping.getRasterNames(aliasName), QUALIFIER_RASTER);
            this.consumeColors(aliasName, this.displayAxisMapping.getInsituNames(aliasName), QUALIFIER_INSITU);
        }
        for (int aliasIdx = 0; aliasIdx < aliasNames.length; ++aliasIdx) {
            String aliasName;
            aliasName = aliasNames[aliasIdx];
            this.timeSeriesPlot.setRangeAxis(aliasIdx, (ValueAxis)this.createValueAxis(aliasName));
            int aliasIndexOffset = aliasIdx * 3;
            int cursorCollectionIndex = aliasIndexOffset + 0;
            int pinCollectionIndex = aliasIndexOffset + 1;
            int insituCollectionIndex = aliasIndexOffset + 2;
            TimeSeriesCollection cursorDataset = new TimeSeriesCollection();
            this.timeSeriesPlot.setDataset(cursorCollectionIndex, (XYDataset)cursorDataset);
            TimeSeriesCollection pinDataset = new TimeSeriesCollection();
            this.timeSeriesPlot.setDataset(pinCollectionIndex, (XYDataset)pinDataset);
            TimeSeriesCollection insituDataset = new TimeSeriesCollection();
            this.timeSeriesPlot.setDataset(insituCollectionIndex, (XYDataset)insituDataset);
            this.timeSeriesPlot.mapDatasetToRangeAxis(cursorCollectionIndex, aliasIdx);
            this.timeSeriesPlot.mapDatasetToRangeAxis(pinCollectionIndex, aliasIdx);
            this.timeSeriesPlot.mapDatasetToRangeAxis(insituCollectionIndex, aliasIdx);
            XYErrorRenderer pinRenderer = this.createXYErrorRenderer();
            XYErrorRenderer cursorRenderer = this.createXYErrorRenderer();
            XYErrorRenderer insituRenderer = this.createXYErrorRenderer();
            pinRenderer.setBaseStroke(PIN_STROKE);
            cursorRenderer.setBaseStroke(CURSOR_STROKE);
            insituRenderer.setBaseLinesVisible(false);
            insituRenderer.setBaseShapesFilled(false);
            List<String> rasterNamesSet = this.displayAxisMapping.getRasterNames(aliasName);
            String[] rasterNames = rasterNamesSet.toArray(new String[rasterNamesSet.size()]);
            for (int i = 0; i < rasterNames.length; ++i) {
                String paintKey = aliasName + QUALIFIER_RASTER + rasterNames[i];
                Paint paint = this.paintMap.get(paintKey);
                cursorRenderer.setSeriesPaint(i, paint);
                pinRenderer.setSeriesPaint(i, paint);
            }
            List<String> insituNamesSet = this.displayAxisMapping.getInsituNames(aliasName);
            String[] insituNames = insituNamesSet.toArray(new String[insituNamesSet.size()]);
            for (int i = 0; i < insituNames.length; ++i) {
                String paintKey = aliasName + QUALIFIER_INSITU + insituNames[i];
                Paint paint = this.paintMap.get(paintKey);
                insituRenderer.setSeriesPaint(i, paint);
            }
            this.timeSeriesPlot.setRenderer(cursorCollectionIndex, (XYItemRenderer)cursorRenderer);
            this.timeSeriesPlot.setRenderer(pinCollectionIndex, (XYItemRenderer)pinRenderer);
            this.timeSeriesPlot.setRenderer(insituCollectionIndex, (XYItemRenderer)insituRenderer);
        }
    }

    private void consumeColors(String aliasName, List<String> names, String identifier) {
        int registeredPaints = this.paintMap.size();
        for (int i = 0; i < names.size(); ++i) {
            Paint paint = this.displayController.getPaint(registeredPaints + i);
            this.paintMap.put(aliasName + identifier + names.get(i), paint);
        }
    }

    private XYErrorRenderer createXYErrorRenderer() {
        XYErrorRenderer renderer = new XYErrorRenderer();
        renderer.setDrawXError(false);
        renderer.setDrawYError(false);
        renderer.setBaseLinesVisible(true);
        renderer.setAutoPopulateSeriesStroke(false);
        renderer.setAutoPopulateSeriesPaint(false);
        renderer.setAutoPopulateSeriesFillPaint(false);
        renderer.setAutoPopulateSeriesOutlinePaint(false);
        renderer.setAutoPopulateSeriesOutlineStroke(false);
        renderer.setAutoPopulateSeriesShape(false);
        StandardXYToolTipGenerator tipGenerator = new StandardXYToolTipGenerator("Value: {2}   Date: {1}", (DateFormat)new SimpleDateFormat(), (NumberFormat)new DecimalFormat());
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)tipGenerator);
        return renderer;
    }

    private NumberAxis createValueAxis(String aliasName) {
        String unit = this.getUnit(this.displayAxisMapping, aliasName);
        String axisLabel = TimeSeriesGraphModel.getAxisLabel(aliasName, unit);
        NumberAxis valueAxis = new NumberAxis(axisLabel);
        valueAxis.setAutoRange(true);
        return valueAxis;
    }

    private AxisMapping createDisplayAxisMapping(AbstractTimeSeries timeSeries) {
        List<String> eoVariables = this.displayController.getEoVariablesToDisplay();
        if (eoVariables.size() == 0) {
            Product.AutoGrouping autoGrouping = this.getCurrentView().getProduct().getAutoGrouping();
            for (String[] strings : autoGrouping) {
                eoVariables.add(strings[0]);
            }
        }
        List<String> insituVariables = this.displayController.getInsituVariablesToDisplay();
        AxisMapping axisMapping = timeSeries.getAxisMapping();
        return this.createDisplayAxisMapping(eoVariables, insituVariables, axisMapping);
    }

    private AxisMapping createDisplayAxisMapping(List<String> eoVariables, List<String> insituVariables, AxisMapping axisMapping) {
        String aliasName;
        AxisMapping displayAxisMapping = new AxisMapping();
        for (String eoVariable : eoVariables) {
            aliasName = axisMapping.getRasterAlias(eoVariable);
            if (aliasName == null) {
                displayAxisMapping.addRasterName(eoVariable, eoVariable);
                continue;
            }
            displayAxisMapping.addRasterName(aliasName, eoVariable);
        }
        for (String insituVariable : insituVariables) {
            aliasName = axisMapping.getInsituAlias(insituVariable);
            if (aliasName == null) {
                displayAxisMapping.addInsituName(insituVariable, insituVariable);
                continue;
            }
            displayAxisMapping.addInsituName(aliasName, insituVariable);
        }
        return displayAxisMapping;
    }

    private String getUnit(AxisMapping axisMapping, String aliasName) {
        List<String> rasterNames = axisMapping.getRasterNames(aliasName);
        for (List<Band> eoVariableBandList : this.eoVariableBands) {
            for (String rasterName : rasterNames) {
                Band raster = eoVariableBandList.get(0);
                if (!raster.getName().startsWith(rasterName)) continue;
                return raster.getUnit();
            }
        }
        return "";
    }

    private static String getAxisLabel(String variableName, String unit) {
        if (StringUtils.isNotNullAndNotEmpty((String)unit)) {
            return String.format("%s (%s)", variableName, unit);
        }
        return variableName;
    }

    private String[] getAliasNames() {
        Set<String> aliasNamesSet = this.displayAxisMapping.getAliasNames();
        return aliasNamesSet.toArray(new String[aliasNamesSet.size()]);
    }

    private Shape getShapeForPosition(TimeSeriesType type, int posIdx) {
        Shape posShape = TimeSeriesType.CURSOR.equals((Object)type) ? TimeSeriesGraphDisplayController.CURSOR_SHAPE : this.displayController.getShape(posIdx);
        return posShape;
    }

    private int getDataSourceCount(TimeSeriesType type, String aliasName) {
        if (TimeSeriesType.INSITU.equals((Object)type)) {
            return this.displayAxisMapping.getInsituNames(aliasName).size();
        }
        return this.displayAxisMapping.getRasterNames(aliasName).size();
    }

    private TimeSeriesGraphUpdater.VersionSafeDataSources createVersionSafeDataSources() {
        return new TimeSeriesGraphUpdater.VersionSafeDataSources(this.displayController.getPinPositionsToDisplay(), this.getVersion().get()){

            @Override
            public int getCurrentVersion() {
                return TimeSeriesGraphModel.this.version.get();
            }
        };
    }

    private AbstractTimeSeries getTimeSeries() {
        ProductSceneView sceneView = this.getCurrentView();
        if (sceneView == null) {
            return null;
        }
        Product sceneViewProduct = sceneView.getProduct();
        return TimeSeriesMapper.getInstance().getTimeSeries(sceneViewProduct);
    }

    private ProductSceneView getCurrentView() {
        return VisatApp.getApp().getSelectedProductSceneView();
    }

    static interface Validation {
        public TimeSeries validate(TimeSeries var1, String var2, TimeSeriesType var3) throws ParseException;

        public void adaptTo(Object var1, AxisMapping var2);

        public void addValidationListener(ValidationListener var1);
    }

    static interface ValidationListener {
        public void expressionChanged();
    }
}

