/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.ui.graph;

import com.bc.ceres.glayer.support.ImageLayer;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.ui.PixelPositionListener;
import org.esa.beam.framework.ui.application.support.AbstractToolView;
import org.esa.beam.framework.ui.product.ProductSceneView;
import org.esa.beam.timeseries.core.TimeSeriesMapper;
import org.esa.beam.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.beam.timeseries.core.timeseries.datamodel.TimeSeriesChangeEvent;
import org.esa.beam.timeseries.core.timeseries.datamodel.TimeSeriesListener;
import org.esa.beam.timeseries.ui.graph.TimeSeriesGraphForm;
import org.esa.beam.timeseries.ui.graph.TimeSeriesGraphModel;
import org.esa.beam.timeseries.ui.graph.TimeSeriesGraphUpdater;
import org.esa.beam.timeseries.ui.graph.TimeSeriesType;
import org.esa.beam.timeseries.ui.graph.TimeSeriesValidator;
import org.esa.beam.visat.VisatApp;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;

public class TimeSeriesGraphToolView
extends AbstractToolView {
    private static final String DEFAULT_RANGE_LABEL = "Value";
    private static final String DEFAULT_DOMAIN_LABEL = "Time";
    private final TimeSeriesPPL pixelPosListener = new TimeSeriesPPL();
    private final PropertyChangeListener pinSelectionListener = new PinSelectionListener();
    private final PropertyChangeListener sliderListener = new SliderListener();
    private final TimeSeriesListener timeSeriesGraphTSL = new TimeSeriesGraphTSL();
    private String titleBase;
    private JFreeChart chart;
    private TimeSeriesGraphForm graphForm;
    private TimeSeriesGraphModel graphModel;
    private ProductSceneView currentView;
    private final TimeSeriesValidator validator = new TimeSeriesValidator();

    protected JComponent createControl() {
        this.titleBase = this.getDescriptor().getTitle();
        boolean displayLegend = true;
        boolean showTooltips = true;
        boolean showUrls = false;
        this.chart = ChartFactory.createTimeSeriesChart(null, (String)DEFAULT_DOMAIN_LABEL, (String)DEFAULT_RANGE_LABEL, null, (boolean)true, (boolean)true, (boolean)false);
        this.graphModel = new TimeSeriesGraphModel(this.chart.getXYPlot(), this.validator);
        this.graphForm = new TimeSeriesGraphForm(this.graphModel, this.chart, this.validator, this.getDescriptor().getHelpId());
        VisatApp visatApp = VisatApp.getApp();
        visatApp.addInternalFrameListener((InternalFrameListener)new TimeSeriesIFL());
        ProductSceneView view = visatApp.getSelectedProductSceneView();
        if (view != null) {
            this.maySetCurrentView(view);
        }
        return this.graphForm.getControl();
    }

    private void maySetCurrentView(ProductSceneView view) {
        String viewProductType = view.getProduct().getProductType();
        if (view != this.currentView && !view.isRGB() && viewProductType.equals("org.esa.beam.glob.timeseries") && TimeSeriesMapper.getInstance().getTimeSeries(view.getProduct()) != null) {
            this.setCurrentView(view);
        }
    }

    private void setCurrentView(ProductSceneView newView) {
        if (this.currentView == newView) {
            return;
        }
        if (this.currentView != null) {
            AbstractTimeSeries timeSeries = TimeSeriesMapper.getInstance().getTimeSeries(this.currentView.getProduct());
            timeSeries.removeTimeSeriesListener(this.timeSeriesGraphTSL);
            this.currentView.removePixelPositionListener((PixelPositionListener)this.pixelPosListener);
            this.currentView.removePropertyChangeListener("selectedPin", this.pinSelectionListener);
            this.currentView.removePropertyChangeListener("timeProperty", this.sliderListener);
        }
        this.currentView = newView;
        this.graphForm.setButtonsEnabled(this.currentView != null);
        if (this.currentView != null) {
            Product currentProduct = this.currentView.getProduct();
            AbstractTimeSeries timeSeries = TimeSeriesMapper.getInstance().getTimeSeries(currentProduct);
            timeSeries.addTimeSeriesListener(this.timeSeriesGraphTSL);
            this.currentView.addPixelPositionListener((PixelPositionListener)this.pixelPosListener);
            this.currentView.addPropertyChangeListener("selectedPin", this.pinSelectionListener);
            this.currentView.addPropertyChangeListener("timeProperty", this.sliderListener);
            RasterDataNode raster = this.currentView.getRaster();
            this.graphModel.adaptToTimeSeries(timeSeries);
            this.graphModel.updateAnnotation(raster);
            this.graphModel.updateTimeSeries(null, TimeSeriesType.INSITU);
            this.graphModel.updateTimeSeries(null, TimeSeriesType.PIN);
            String variableName = AbstractTimeSeries.rasterToVariableName(raster.getName());
            this.setTitle(String.format("%s - %s", this.titleBase, variableName));
        } else {
            this.graphModel.removeAnnotation();
            this.graphModel.adaptToTimeSeries(null);
            this.graphModel.updateTimeSeries(null, TimeSeriesType.INSITU);
            this.graphModel.updateTimeSeries(null, TimeSeriesType.PIN);
            this.setTitle(this.titleBase);
        }
    }

    private void updateTimeSeries(AbstractTimeSeries timeSeries) {
        this.graphModel.adaptToTimeSeries(timeSeries);
        this.graphModel.updateTimeSeries(null, TimeSeriesType.INSITU);
        this.graphModel.updateTimeSeries(null, TimeSeriesType.PIN);
    }

    private class SliderListener
    implements PropertyChangeListener {
        private SliderListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TimeSeriesGraphToolView.this.graphModel.updateAnnotation(TimeSeriesGraphToolView.this.currentView.getRaster());
        }
    }

    private class TimeSeriesGraphTSL
    extends TimeSeriesListener {
        private TimeSeriesGraphTSL() {
        }

        @Override
        public void timeSeriesChanged(TimeSeriesChangeEvent event) {
            int type = event.getType();
            if (type == 8 || type == 16) {
                TimeSeriesGraphToolView.this.graphModel.updateAnnotation(TimeSeriesGraphToolView.this.currentView.getRaster());
                TimeSeriesGraphToolView.this.updateTimeSeries(event.getTimeSeries());
            } else if (type == 64 || type == 128 || type == 2 || type == 4) {
                TimeSeriesGraphToolView.this.updateTimeSeries(event.getTimeSeries());
            }
        }

        public void nodeChanged(ProductNodeEvent event) {
            String propertyName = event.getPropertyName();
            if (propertyName.equals("pixelPos") || propertyName.equals("label")) {
                TimeSeriesGraphToolView.this.graphModel.updateTimeSeries(null, TimeSeriesType.PIN);
                TimeSeriesGraphToolView.this.graphModel.updateTimeSeries(null, TimeSeriesType.INSITU);
            }
        }

        public void nodeAdded(ProductNodeEvent event) {
            ProductNode node = event.getSourceNode();
            if (node instanceof Placemark) {
                this.handlePlacemarkChanged();
            } else if (node instanceof RasterDataNode && TimeSeriesGraphToolView.this.currentView != null) {
                TimeSeriesGraphToolView.this.graphModel.adaptToTimeSeries(this.getTimeSeries());
                TimeSeriesGraphToolView.this.graphModel.updateTimeSeries(null, TimeSeriesType.INSITU);
                TimeSeriesGraphToolView.this.graphModel.updateTimeSeries(null, TimeSeriesType.PIN);
            }
        }

        public void nodeRemoved(ProductNodeEvent event) {
            ProductNode node = event.getSourceNode();
            if (node instanceof Placemark) {
                this.handlePlacemarkChanged();
            } else if (node instanceof RasterDataNode && TimeSeriesGraphToolView.this.currentView != null) {
                TimeSeriesGraphToolView.this.graphModel.adaptToTimeSeries(this.getTimeSeries());
                TimeSeriesGraphToolView.this.graphModel.updateTimeSeries(null, TimeSeriesType.INSITU);
                TimeSeriesGraphToolView.this.graphModel.updateTimeSeries(null, TimeSeriesType.PIN);
            }
        }

        private AbstractTimeSeries getTimeSeries() {
            Product product = TimeSeriesGraphToolView.this.currentView.getProduct();
            return TimeSeriesMapper.getInstance().getTimeSeries(product);
        }

        private void handlePlacemarkChanged() {
            boolean placemarksSet = TimeSeriesGraphToolView.this.currentView.getProduct().getPinGroup().getNodeCount() > 0;
            TimeSeriesGraphToolView.this.graphForm.setExportEnabled(placemarksSet);
            TimeSeriesGraphToolView.this.updateTimeSeries(this.getTimeSeries());
        }
    }

    private class PinSelectionListener
    implements PropertyChangeListener {
        private PinSelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (TimeSeriesGraphToolView.this.graphModel.isShowingSelectedPins()) {
                TimeSeriesGraphToolView.this.graphModel.updateTimeSeries(null, TimeSeriesType.PIN);
                TimeSeriesGraphToolView.this.graphModel.updateTimeSeries(null, TimeSeriesType.INSITU);
            }
        }
    }

    private class TimeSeriesPPL
    implements PixelPositionListener {
        private TimeSeriesPPL() {
        }

        public void pixelPosChanged(ImageLayer imageLayer, int pixelX, int pixelY, int currentLevel, boolean pixelPosValid, MouseEvent e) {
            if (!TimeSeriesGraphToolView.this.graphModel.isShowCursorTimeSeries()) {
                return;
            }
            if (pixelPosValid && TimeSeriesGraphToolView.this.isVisible() && TimeSeriesGraphToolView.this.currentView != null) {
                TimeSeriesGraphUpdater.Position position = new TimeSeriesGraphUpdater.Position(pixelX, pixelY, currentLevel);
                TimeSeriesGraphToolView.this.graphModel.updateTimeSeries(position, TimeSeriesType.CURSOR);
            }
            boolean autorange = e.isShiftDown();
            XYPlot xyPlot = TimeSeriesGraphToolView.this.chart.getXYPlot();
            for (int i = 0; i < xyPlot.getRangeAxisCount(); ++i) {
                xyPlot.getRangeAxis(i).setAutoRange(autorange);
            }
            TimeSeriesGraphToolView.this.graphModel.updateAnnotation(TimeSeriesGraphToolView.this.currentView.getRaster());
        }

        public void pixelPosNotAvailable() {
            if (!TimeSeriesGraphToolView.this.graphModel.isShowCursorTimeSeries()) {
                return;
            }
            TimeSeriesGraphToolView.this.graphModel.updateTimeSeries(null, TimeSeriesType.CURSOR);
        }
    }

    private class TimeSeriesIFL
    extends InternalFrameAdapter {
        private TimeSeriesIFL() {
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            Container contentPane = e.getInternalFrame().getContentPane();
            if (contentPane instanceof ProductSceneView) {
                TimeSeriesGraphToolView.this.maySetCurrentView((ProductSceneView)contentPane);
            }
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
            Container contentPane = e.getInternalFrame().getContentPane();
            if (contentPane == TimeSeriesGraphToolView.this.currentView) {
                TimeSeriesGraphToolView.this.setCurrentView(null);
            }
        }
    }
}

