/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.ui.graph;

import com.bc.jexp.Namespace;
import com.bc.jexp.ParseException;
import com.bc.jexp.Parser;
import com.bc.jexp.Symbol;
import com.bc.jexp.Term;
import com.bc.jexp.Variable;
import com.bc.jexp.impl.DefaultNamespace;
import com.bc.jexp.impl.ParserImpl;
import com.bc.jexp.impl.SymbolFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.esa.beam.framework.ui.ExpressionPane;
import org.esa.beam.timeseries.core.timeseries.datamodel.AxisMapping;
import org.esa.beam.timeseries.ui.graph.TimeSeriesGraphForm;
import org.esa.beam.timeseries.ui.graph.TimeSeriesGraphModel;
import org.esa.beam.timeseries.ui.graph.TimeSeriesType;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.visat.VisatApp;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;

class TimeSeriesValidator
implements TimeSeriesGraphForm.ValidatorUI,
TimeSeriesGraphModel.Validation {
    private static final String QUALIFIER_RASTER = "r.";
    private static final String QUALIFIER_INSITU = "i.";
    private final Map<Object, Map<String, String>> timeSeriesExpressionsMap = new HashMap<Object, Map<String, String>>();
    private final Set<TimeSeriesGraphModel.ValidationListener> validationListeners = new HashSet<TimeSeriesGraphModel.ValidationListener>();
    private final Parser parser = new ParserImpl();
    private Map<String, String> currentExpressionMap;
    private List<String> qualifiedSourceNames;
    private DefaultNamespace namespace;
    private JComboBox sourceNamesDropDown;
    private JTextField expressionTextField;
    private boolean hasUI = false;

    TimeSeriesValidator() {
    }

    @Override
    public JComponent createUI() {
        this.expressionTextField = new JTextField("");
        this.expressionTextField.setEditable(false);
        this.expressionTextField.setEnabled(false);
        this.expressionTextField.setColumns(30);
        this.expressionTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TimeSeriesValidator.this.expressionTextField.isEnabled()) {
                    TimeSeriesValidator.this.showExpressionEditor();
                }
            }
        });
        this.sourceNamesDropDown = new JComboBox();
        this.sourceNamesDropDown.setPreferredSize(new Dimension(120, 20));
        this.sourceNamesDropDown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    String selectedSourceName = e.getItem().toString();
                    String expression = TimeSeriesValidator.this.getExpressionFor(selectedSourceName);
                    TimeSeriesValidator.this.expressionTextField.setText(expression == null ? "" : expression);
                }
            }
        });
        this.sourceNamesDropDown.setEnabled(false);
        JButton editExpressionButton = new JButton("...");
        editExpressionButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSeriesValidator.this.showExpressionEditor();
            }
        });
        JPanel uiPanel = new JPanel();
        uiPanel.add(new JLabel("Valid expression:"));
        uiPanel.add(this.sourceNamesDropDown);
        uiPanel.add(this.expressionTextField);
        uiPanel.add(editExpressionButton);
        this.hasUI = true;
        JPanel stretchablePanel = new JPanel(new BorderLayout());
        stretchablePanel.add((Component)uiPanel, "Center");
        return stretchablePanel;
    }

    @Override
    public void adaptTo(Object timeSeriesKey, AxisMapping axisMapping) {
        if (this.timeSeriesExpressionsMap.containsKey(timeSeriesKey)) {
            this.currentExpressionMap = this.timeSeriesExpressionsMap.get(timeSeriesKey);
        } else {
            this.currentExpressionMap = new HashMap<String, String>();
            this.timeSeriesExpressionsMap.put(timeSeriesKey, this.currentExpressionMap);
        }
        this.qualifiedSourceNames = this.extractQualifiedSourceNames(axisMapping);
        this.namespace = new DefaultNamespace();
        for (String qualifiedSourceName : this.qualifiedSourceNames) {
            this.namespace.registerSymbol((Symbol)SymbolFactory.createVariable((String)qualifiedSourceName, (double)0.0));
        }
        if (this.qualifiedSourceNames.size() > 0 && this.hasUI) {
            this.expressionTextField.setEnabled(true);
            this.sourceNamesDropDown.setEnabled(true);
            this.sourceNamesDropDown.setModel(new DefaultComboBoxModel<String>(this.getSourceNames()));
            String expression = this.getExpressionFor(this.getSelectedSourceName());
            this.expressionTextField.setText(expression == null ? "" : expression);
        }
    }

    @Override
    public TimeSeries validate(TimeSeries timeSeries, String sourceName, TimeSeriesType type) throws ParseException {
        String qualifiedSourceName = this.createQualifiedSourcename(sourceName, type);
        Symbol symbol = this.namespace.resolveSymbol(qualifiedSourceName);
        if (symbol == null) {
            throw new ParseException("No variable for identifier '" + qualifiedSourceName + "' registered.");
        }
        String expression = this.getExpressionFor(qualifiedSourceName);
        if (expression == null || expression.trim().isEmpty()) {
            return timeSeries;
        }
        Variable variable = (Variable)symbol;
        Term term = this.parser.parse(expression, (Namespace)this.namespace);
        int seriesCount = timeSeries.getItemCount();
        TimeSeries validatedSeries = new TimeSeries(timeSeries.getKey());
        for (int i = 0; i < seriesCount; ++i) {
            TimeSeriesDataItem dataItem = timeSeries.getDataItem(i);
            Number value = dataItem.getValue();
            variable.assignD(null, value.doubleValue());
            if (!term.evalB(null)) continue;
            validatedSeries.add(dataItem);
        }
        return validatedSeries;
    }

    @Override
    public void addValidationListener(TimeSeriesGraphModel.ValidationListener listener) {
        this.validationListeners.add(listener);
    }

    boolean setExpression(String qualifiedSourceName, String expression) {
        Symbol symbol = this.namespace.resolveSymbol(qualifiedSourceName);
        if (symbol == null) {
            return false;
        }
        if (this.isExpressionValid(expression, qualifiedSourceName)) {
            this.currentExpressionMap.put(qualifiedSourceName, expression);
            this.fireExpressionChanged();
            return true;
        }
        return false;
    }

    private void showExpressionEditor() {
        MyExpressionPane expressionPane = new MyExpressionPane();
        expressionPane.setEmptyExpressionAllowed(true);
        expressionPane.setCode(this.expressionTextField.getText());
        String sourceName = this.getSelectedSourceName();
        int status = expressionPane.showModalDialog((Window)VisatApp.getApp().getMainFrame(), "Valid Expression for Source '" + sourceName + "'");
        if (1 == status) {
            String expression = expressionPane.getCode();
            this.expressionTextField.setText(expression);
            this.setExpression(sourceName, expression);
        }
    }

    private boolean isExpressionValid(String expression, String qualifiedSorceName) {
        if (expression == null || expression.trim().isEmpty()) {
            return true;
        }
        if (expression.trim().equals(qualifiedSorceName.trim())) {
            return false;
        }
        try {
            DefaultNamespace expressionValidationNamespace = new DefaultNamespace();
            expressionValidationNamespace.registerSymbol((Symbol)SymbolFactory.createVariable((String)qualifiedSorceName, (double)0.0));
            Term term = this.parser.parse(expression, (Namespace)expressionValidationNamespace);
            return term != null && term.isB();
        }
        catch (ParseException ignored) {
            return false;
        }
    }

    private void fireExpressionChanged() {
        for (TimeSeriesGraphModel.ValidationListener validationListener : this.validationListeners) {
            validationListener.expressionChanged();
        }
    }

    private String getSelectedSourceName() {
        return this.sourceNamesDropDown.getSelectedItem().toString();
    }

    private String[] getSourceNames() {
        return this.qualifiedSourceNames.toArray(new String[this.qualifiedSourceNames.size()]);
    }

    private void collectSourceNames(ArrayList<String> names, List<String> sourceNames, String qualifier) {
        for (String sourceName : sourceNames) {
            String qualifiedSourceName = qualifier + sourceName;
            names.add(qualifiedSourceName);
        }
    }

    private List<String> extractQualifiedSourceNames(AxisMapping axisMapping) {
        ArrayList<String> names = new ArrayList<String>();
        for (String alias : axisMapping.getAliasNames()) {
            this.collectSourceNames(names, axisMapping.getInsituNames(alias), QUALIFIER_INSITU);
            this.collectSourceNames(names, axisMapping.getRasterNames(alias), QUALIFIER_RASTER);
        }
        return names;
    }

    private String createQualifiedSourcename(String sourceName, TimeSeriesType type) {
        String qualifiedSourceName = TimeSeriesType.INSITU.equals((Object)type) ? QUALIFIER_INSITU + sourceName : QUALIFIER_RASTER + sourceName;
        return qualifiedSourceName;
    }

    private String getExpressionFor(String qualifiedSourceName) {
        return this.currentExpressionMap.get(qualifiedSourceName);
    }

    private class MyExpressionPane
    extends ExpressionPane {
        public MyExpressionPane() {
            super(true, null, new PropertyMap());
            this.initParser();
            this.initLeftAccessory();
        }

        private void initParser() {
            String sourceName = TimeSeriesValidator.this.getSelectedSourceName();
            Variable sourceVariable = SymbolFactory.createVariable((String)sourceName, (double)0.0);
            DefaultNamespace namespace = new DefaultNamespace();
            namespace.registerSymbol((Symbol)sourceVariable);
            this.setParser((Parser)new ParserImpl((Namespace)namespace, true));
        }

        private void initLeftAccessory() {
            String sourceName = TimeSeriesValidator.this.getSelectedSourceName();
            JButton insertButton = this.createInsertButton(sourceName);
            JPanel sourcePane = new JPanel(new BorderLayout());
            sourcePane.add((Component)new JLabel("Data Source:"), "North");
            sourcePane.add(insertButton);
            JPanel patternInsertionPane = this.createPatternInsertionPane();
            JPanel leftAccessory = new JPanel(new BorderLayout(4, 4));
            leftAccessory.add((Component)sourcePane, "North");
            leftAccessory.add(patternInsertionPane);
            this.setLeftAccessory(leftAccessory);
        }
    }
}

