/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.ui.manager;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.TableLayout;
import com.jidesoft.combobox.DateComboBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.ui.ModalDialog;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.beam.timeseries.core.timeseries.datamodel.GridTimeCoding;
import org.esa.beam.timeseries.core.timeseries.datamodel.ProductLocation;
import org.esa.beam.timeseries.core.timeseries.datamodel.TimeCoding;

class EditTimeSpanAction
extends AbstractAction {
    private final AbstractTimeSeries timeSeries;

    EditTimeSpanAction(AbstractTimeSeries timeSeries) {
        this.timeSeries = timeSeries;
        this.setEnabled(timeSeries != null);
        URL editTimeSpanIconImageURL = UIUtils.getImageURL((String)"/org/esa/beam/timeseries/ui/icons/timeseries-rangeedit24.png", EditTimeSpanAction.class);
        this.putValue("SwingLargeIconKey", new ImageIcon(editTimeSpanIconImageURL));
        this.putValue("ActionCommandKey", this.getClass().getName());
        this.putValue("ShortDescription", "Edit time span");
        this.putValue("componentName", "EditTimeSpan");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Window window = null;
        if (source instanceof Component) {
            window = SwingUtilities.getWindowAncestor((Component)source);
        }
        EditTimeSpanDialog dialog = new EditTimeSpanDialog(window, this.timeSeries);
        dialog.show();
    }

    private static class EditTimeSpanDialog
    extends ModalDialog {
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", Locale.ENGLISH);
        private AbstractTimeSeries timeSeries;
        private DateComboBox startTimeBox;
        private DateComboBox endTimeBox;
        private JLabel startTimeLabel;
        private JLabel endTimeLabel;
        private JCheckBox autoAdjustBox;

        private EditTimeSpanDialog(Window window, AbstractTimeSeries timeSeries) {
            super(window, "Edit Time Span", 33, null);
            this.timeSeries = timeSeries;
            this.createUserInterface();
        }

        protected void onOK() {
            this.timeSeries.setAutoAdjustingTimeCoding(this.autoAdjustBox.isSelected());
            ProductData.UTC startTime = ProductData.UTC.create((Date)this.startTimeBox.getDate(), (long)0L);
            ProductData.UTC endTime = ProductData.UTC.create((Date)this.endTimeBox.getDate(), (long)0L);
            this.timeSeries.setTimeCoding(new GridTimeCoding(startTime, endTime));
            super.onOK();
        }

        protected boolean verifyUserInput() {
            if (this.endTimeBox.getCalendar().compareTo(this.startTimeBox.getCalendar()) < 0) {
                this.showErrorDialog("End time is before start time.");
                return false;
            }
            return true;
        }

        private void createUserInterface() {
            boolean isAutoAdjustingTimeCoding = this.timeSeries.isAutoAdjustingTimeCoding();
            TableLayout tableLayout = new TableLayout(2);
            tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
            tableLayout.setTableWeightX(Double.valueOf(1.0));
            tableLayout.setTableFill(TableLayout.Fill.BOTH);
            tableLayout.setTablePadding(4, 4);
            tableLayout.setCellColspan(0, 0, Integer.valueOf(2));
            JPanel content = new JPanel((LayoutManager)tableLayout);
            this.autoAdjustBox = this.createAutoAdjustBox(isAutoAdjustingTimeCoding);
            this.startTimeLabel = new JLabel("Start time:");
            this.startTimeBox = this.createDateComboBox();
            TimeCoding timeCoding = this.timeSeries.getTimeCoding();
            this.startTimeBox.setCalendar(timeCoding.getStartTime().getAsCalendar());
            this.endTimeLabel = new JLabel("End time:");
            this.endTimeBox = this.createDateComboBox();
            this.endTimeBox.setCalendar(timeCoding.getEndTime().getAsCalendar());
            content.add(this.autoAdjustBox);
            content.add(this.startTimeLabel);
            content.add((Component)this.startTimeBox);
            content.add(this.endTimeLabel);
            content.add((Component)this.endTimeBox);
            this.setUiEnabled(!isAutoAdjustingTimeCoding);
            this.setContent(content);
        }

        private JCheckBox createAutoAdjustBox(boolean autoAdjustingTimeCoding) {
            JCheckBox autoAdjustBox = new JCheckBox("Auto adjust time information", autoAdjustingTimeCoding);
            autoAdjustBox.addActionListener(new AutoAdjustBoxListener(autoAdjustBox));
            return autoAdjustBox;
        }

        private List<Product> getCompatibleProducts() {
            ArrayList<Product> result = new ArrayList<Product>();
            for (ProductLocation productLocation : this.timeSeries.getProductLocations()) {
                for (Product product : productLocation.getProducts(ProgressMonitor.NULL).values()) {
                    for (String variable : this.timeSeries.getEoVariables()) {
                        if (!this.timeSeries.isProductCompatible(product, variable) || !this.timeSeries.isEoVariableSelected(variable)) continue;
                        result.add(product);
                    }
                }
            }
            return result;
        }

        private ProductData.UTC getMaxEndTime(ProductData.UTC endTime1, ProductData.UTC endTime2) {
            ProductData.UTC endTime = endTime1.getAsDate().before(endTime2.getAsDate()) ? endTime2 : endTime1;
            return endTime;
        }

        private ProductData.UTC getMinStartTime(ProductData.UTC startTime1, ProductData.UTC startTime2) {
            ProductData.UTC startTime = startTime1.getAsDate().after(startTime2.getAsDate()) ? startTime2 : startTime1;
            return startTime;
        }

        private DateComboBox createDateComboBox() {
            DateComboBox box = new DateComboBox();
            box.setTimeDisplayed(true);
            box.setFormat((DateFormat)this.dateFormat);
            box.setShowNoneButton(false);
            box.setShowTodayButton(false);
            box.setShowOKButton(true);
            box.setEditable(false);
            return box;
        }

        private void setUiEnabled(boolean enable) {
            this.startTimeBox.setEnabled(enable);
            this.startTimeLabel.setEnabled(enable);
            this.endTimeBox.setEnabled(enable);
            this.endTimeLabel.setEnabled(enable);
        }

        private class AutoAdjustBoxListener
        implements ActionListener {
            private final JCheckBox autoAdjustBox;

            private AutoAdjustBoxListener(JCheckBox autoAdjustBox) {
                this.autoAdjustBox = autoAdjustBox;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = this.autoAdjustBox.isSelected();
                EditTimeSpanDialog.this.setUiEnabled(!selected);
                if (!selected) {
                    return;
                }
                ProductData.UTC autoStartTime = null;
                ProductData.UTC autoEndTime = null;
                List compatibleProducts = EditTimeSpanDialog.this.getCompatibleProducts();
                for (Product product : compatibleProducts) {
                    TimeCoding varTimeCoding = GridTimeCoding.create(product);
                    if (autoStartTime == null) {
                        TimeCoding tsTimeCoding = EditTimeSpanDialog.this.timeSeries.getTimeCoding();
                        autoStartTime = tsTimeCoding.getStartTime();
                        autoEndTime = tsTimeCoding.getEndTime();
                    }
                    if (varTimeCoding == null) continue;
                    autoStartTime = EditTimeSpanDialog.this.getMinStartTime(autoStartTime, varTimeCoding.getStartTime());
                    autoEndTime = EditTimeSpanDialog.this.getMaxEndTime(autoEndTime, varTimeCoding.getEndTime());
                }
                if (autoStartTime == null) {
                    try {
                        autoEndTime = autoStartTime = ProductData.UTC.parse((String)"1970-01-01", (String)"yyyy-MM-dd");
                    }
                    catch (ParseException ignore) {
                        // empty catch block
                    }
                }
                EditTimeSpanDialog.this.startTimeBox.setDate(autoStartTime.getAsDate());
                EditTimeSpanDialog.this.endTimeBox.setDate(autoEndTime.getAsDate());
            }
        }
    }
}

