/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.ui.manager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PinDescriptor;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.PlacemarkDescriptor;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.application.support.AbstractToolView;
import org.esa.beam.framework.ui.product.ProductTreeListener;
import org.esa.beam.framework.ui.product.ProductTreeListenerAdapter;
import org.esa.beam.timeseries.core.TimeSeriesMapper;
import org.esa.beam.timeseries.core.insitu.InsituSource;
import org.esa.beam.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.beam.timeseries.core.timeseries.datamodel.TimeSeriesChangeEvent;
import org.esa.beam.timeseries.core.timeseries.datamodel.TimeSeriesListener;
import org.esa.beam.timeseries.ui.manager.TimeSeriesManagerForm;
import org.esa.beam.visat.VisatApp;

public class TimeSeriesManagerToolView
extends AbstractToolView {
    private final AppContext appContext;
    private JPanel controlPanel;
    private Product selectedProduct;
    private String prefixTitle;
    private final WeakHashMap<Product, TimeSeriesManagerForm> formMap = new WeakHashMap();
    private TimeSeriesManagerForm activeForm;
    private final TimeSeriesManagerTSL timeSeriesManagerTSL;

    public TimeSeriesManagerToolView() {
        this.appContext = VisatApp.getApp();
        this.timeSeriesManagerTSL = new TimeSeriesManagerTSL();
    }

    protected JComponent createControl() {
        this.controlPanel = new JPanel(new BorderLayout());
        this.controlPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.prefixTitle = this.getDescriptor().getTitle();
        this.setSelectedProduct(this.appContext.getSelectedProduct());
        VisatApp.getApp().addProductTreeListener((ProductTreeListener)new TSManagerPTL());
        this.realizeActiveForm();
        this.updateTitle();
        return this.controlPanel;
    }

    Product getSelectedProduct() {
        return this.selectedProduct;
    }

    private void productClosed(Product product) {
        this.formMap.remove(product);
        this.setSelectedProduct(null);
    }

    private void updateTitle() {
        Product product = this.getSelectedProduct();
        String suffix = product != null ? " - " + product.getDisplayName() : "";
        this.getDescriptor().setTitle(this.prefixTitle + suffix);
    }

    private void setSelectedProduct(Product newProduct) {
        Product oldProduct = this.selectedProduct;
        if (newProduct != oldProduct) {
            AbstractTimeSeries timeSeries;
            if (oldProduct != null && (timeSeries = TimeSeriesMapper.getInstance().getTimeSeries(oldProduct)) != null) {
                timeSeries.removeTimeSeriesListener(this.timeSeriesManagerTSL);
            }
            this.selectedProduct = newProduct;
            this.realizeActiveForm();
            this.updateTitle();
            if (newProduct != null && (timeSeries = TimeSeriesMapper.getInstance().getTimeSeries(newProduct)) != null) {
                timeSeries.addTimeSeriesListener(this.timeSeriesManagerTSL);
            }
        }
    }

    private void realizeActiveForm() {
        JPanel controlPanel = this.controlPanel;
        if (controlPanel.getComponentCount() > 0) {
            controlPanel.remove(0);
        }
        this.activeForm = this.getOrCreateActiveForm(this.getSelectedProduct());
        controlPanel.add((Component)this.activeForm.getControl(), "Center");
        controlPanel.validate();
        controlPanel.repaint();
    }

    private TimeSeriesManagerForm getOrCreateActiveForm(Product product) {
        if (this.formMap.containsKey(product)) {
            this.activeForm = this.formMap.get(product);
        } else {
            this.activeForm = new TimeSeriesManagerForm(this.getDescriptor());
            this.formMap.put(product, this.activeForm);
        }
        this.activeForm.updateFormControl(product);
        return this.activeForm;
    }

    private void updateInsituPins() {
        AbstractTimeSeries timeSeries = TimeSeriesMapper.getInstance().getTimeSeries(this.selectedProduct);
        timeSeries.clearInsituPlacemarks();
        this.addPlacemarks(timeSeries);
    }

    private void addPlacemarks(AbstractTimeSeries timeSeries) {
        InsituSource insituSource = timeSeries.getInsituSource();
        List<String> selectedInsituVariables = this.getSelectedInsituVariables(timeSeries, insituSource);
        TreeSet<GeoPos> geoPoses = new TreeSet<GeoPos>(this.createGeoPosComparator());
        for (String selectedInsituVariable : selectedInsituVariables) {
            geoPoses.addAll(insituSource.getInsituPositionsFor(selectedInsituVariable));
        }
        Product tsProduct = timeSeries.getTsProduct();
        GeoCoding geoCoding = tsProduct.getGeoCoding();
        PixelPos pixelPos = new PixelPos();
        for (GeoPos geoPos : geoPoses) {
            geoCoding.getPixelPos(geoPos, pixelPos);
            if (!AbstractTimeSeries.isPixelValid(tsProduct, pixelPos)) continue;
            String name = insituSource.hasStationNames() ? insituSource.getNameFor(geoPos) : geoPos.getLatString() + "_" + geoPos.getLonString();
            String pinName = "Insitu_" + name;
            String pinLabel = name;
            String pinDescription = name;
            Placemark placemark = Placemark.createPointPlacemark((PlacemarkDescriptor)PinDescriptor.getInstance(), (String)pinName, (String)pinLabel, (String)pinDescription, null, (GeoPos)new GeoPos(geoPos), (GeoCoding)geoCoding);
            timeSeries.registerRelation(placemark, geoPos);
        }
    }

    private Comparator<GeoPos> createGeoPosComparator() {
        return new Comparator<GeoPos>(){

            @Override
            public int compare(GeoPos o1, GeoPos o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };
    }

    private List<String> getSelectedInsituVariables(AbstractTimeSeries timeSeries, InsituSource insituSource) {
        String[] parameterNames = insituSource.getParameterNames();
        ArrayList<String> selectedInsituVariables = new ArrayList<String>();
        for (String parameterName : parameterNames) {
            if (!timeSeries.isInsituVariableSelected(parameterName)) continue;
            selectedInsituVariables.add(parameterName);
        }
        return selectedInsituVariables;
    }

    private class TimeSeriesManagerTSL
    extends TimeSeriesListener {
        private TimeSeriesManagerTSL() {
        }

        @Override
        public void timeSeriesChanged(TimeSeriesChangeEvent event) {
            int type = event.getType();
            if (type == 2 || type == 4) {
                TimeSeriesManagerToolView.this.activeForm.updateFormControl(TimeSeriesManagerToolView.this.getSelectedProduct());
            } else if (type == 64) {
                TimeSeriesManagerToolView.this.updateInsituPins();
            }
        }

        public void nodeChanged(ProductNodeEvent event) {
            TimeSeriesManagerToolView.this.activeForm.updateFormControl(TimeSeriesManagerToolView.this.getSelectedProduct());
        }
    }

    private class TSManagerPTL
    extends ProductTreeListenerAdapter {
        private TSManagerPTL() {
        }

        public void productRemoved(Product product) {
            TimeSeriesManagerToolView.this.productClosed(product);
        }

        public void productNodeSelected(ProductNode productNode, int clickCount) {
            TimeSeriesManagerToolView.this.setSelectedProduct(this.getProduct(productNode));
        }

        private Product getProduct(ProductNode productNode) {
            ProductNodeGroup productNodeGroup;
            while (productNode instanceof ProductNodeGroup && (productNodeGroup = (ProductNodeGroup)productNode).getNodeCount() > 0) {
                productNode = productNodeGroup.get(0);
            }
            return productNode.getProduct();
        }
    }
}

