/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.ui.matrix;

import java.awt.Rectangle;
import javax.swing.table.AbstractTableModel;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.math.MathUtils;

class MatrixTableModel
extends AbstractTableModel {
    private int size = 0;
    private Band band = null;
    private int centerPixelX = Integer.MIN_VALUE;
    private int centerPixelY = Integer.MIN_VALUE;

    MatrixTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.size;
    }

    @Override
    public int getColumnCount() {
        return this.size;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Double.class;
    }

    @Override
    public Double getValueAt(int rowIndex, int columnIndex) {
        int pixelY;
        if (this.unableToFetchValues()) {
            return null;
        }
        int centerOffset = MathUtils.floorInt((double)((double)this.size / 2.0));
        int pixelX = this.centerPixelX - centerOffset + columnIndex;
        if (this.band.isPixelValid(pixelX, pixelY = this.centerPixelY - centerOffset + rowIndex)) {
            return ProductUtils.getGeophysicalSampleDouble((Band)this.band, (int)pixelX, (int)pixelY, (int)0);
        }
        Rectangle imageRectangle = new Rectangle(this.band.getSceneRasterWidth(), this.band.getSceneRasterHeight());
        if (imageRectangle.contains(pixelX, pixelY)) {
            return Double.NaN;
        }
        return null;
    }

    public void setMatrixSize(int matrixSize) {
        if (this.size != matrixSize) {
            this.size = matrixSize;
            this.fireTableStructureChanged();
        }
    }

    public void setBand(Band band) {
        if (this.band != band) {
            this.band = band;
            this.fireTableDataChanged();
        }
    }

    public Band getBand() {
        return this.band;
    }

    public void setCenterPixel(int pixelX, int pixelY) {
        if (this.centerPixelX != pixelX || this.centerPixelY != pixelY) {
            this.centerPixelX = pixelX;
            this.centerPixelY = pixelY;
            this.fireTableDataChanged();
        }
    }

    public void clearMatrix() {
        this.setCenterPixel(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    private boolean unableToFetchValues() {
        return this.band == null || this.centerPixelX == Integer.MIN_VALUE || this.centerPixelY == Integer.MIN_VALUE;
    }
}

