/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.ui.matrix;

import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.swing.LayerCanvas;
import com.bc.ceres.swing.TableLayout;
import com.jidesoft.grid.JideTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.help.HelpSys;
import org.esa.beam.framework.ui.PixelPositionListener;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.application.PageComponentDescriptor;
import org.esa.beam.framework.ui.application.support.AbstractToolView;
import org.esa.beam.framework.ui.product.ProductSceneView;
import org.esa.beam.framework.ui.tool.ToolButtonFactory;
import org.esa.beam.timeseries.core.TimeSeriesMapper;
import org.esa.beam.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.beam.timeseries.core.timeseries.datamodel.TimeCoding;
import org.esa.beam.timeseries.core.timeseries.datamodel.TimeSeriesListener;
import org.esa.beam.timeseries.ui.matrix.MatrixCellRenderer;
import org.esa.beam.timeseries.ui.matrix.MatrixTableModel;
import org.esa.beam.util.math.MathUtils;
import org.esa.beam.visat.VisatApp;

public class TimeSeriesMatrixToolView
extends AbstractToolView {
    private static final int MATRIX_MINIMUM = 3;
    private static final int MATRIX_DEFAULT_VALUE = 3;
    private static final int MATRIX_MAXIMUM = 15;
    private static final int MATRIX_STEP_SIZE = 2;
    private JSpinner matrixSizeSpinner;
    private JLabel dateLabel;
    private ProductSceneView currentView;
    private AbstractTimeSeries timeSeries;
    private final SceneViewListener sceneViewListener;
    private final TimeSeriesPPL pixelPosListener = new TimeSeriesPPL();
    private final MatrixMouseWheelListener mouseWheelListener;
    private final TimeSeriesListener timeSeriesMatrixTSL;
    private static final String DATE_PREFIX = "Date: ";
    private MatrixTableModel matrixModel;
    private final SimpleDateFormat dateFormat;
    private MatrixCellRenderer matrixCellRenderer;

    public TimeSeriesMatrixToolView() {
        this.sceneViewListener = new SceneViewListener();
        this.mouseWheelListener = new MatrixMouseWheelListener();
        this.timeSeriesMatrixTSL = new TimeSeriesMatrixTSL();
        this.dateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", Locale.getDefault());
    }

    protected JComponent createControl() {
        VisatApp.getApp().addInternalFrameListener((InternalFrameListener)this.sceneViewListener);
        this.dateLabel = new JLabel(String.format("Date:  %s", this.getStartDateString()));
        this.matrixSizeSpinner = new JSpinner(new SpinnerNumberModel(3, 3, 15, 2));
        JComponent editor = this.matrixSizeSpinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            ((JSpinner.DefaultEditor)editor).getTextField().setEditable(false);
        }
        this.matrixSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TimeSeriesMatrixToolView.this.matrixModel.setMatrixSize((Integer)TimeSeriesMatrixToolView.this.matrixSizeSpinner.getModel().getValue());
            }
        });
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTableWeightX(Double.valueOf(0.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        tableLayout.setColumnWeightX(0, Double.valueOf(1.0));
        tableLayout.setRowWeightY(1, Double.valueOf(1.0));
        tableLayout.setCellColspan(0, 0, Integer.valueOf(2));
        JPanel panel = new JPanel((LayoutManager)tableLayout);
        panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel buttonPanel = this.createButtonPanel();
        JPanel tablePanel = this.createTablePanel();
        panel.add(this.dateLabel);
        panel.add(tablePanel);
        panel.add(buttonPanel);
        this.setCurrentView(VisatApp.getApp().getSelectedProductSceneView());
        return panel;
    }

    public void componentShown() {
        this.addMouseWheelListener();
    }

    public void componentOpened() {
        this.addMouseWheelListener();
    }

    public void componentClosed() {
        this.removeMouseWheelListener();
    }

    public void componentHidden() {
        this.removeMouseWheelListener();
    }

    private JPanel createTablePanel() {
        JPanel mainPanel = new JPanel(new BorderLayout(4, 4));
        this.matrixModel = new MatrixTableModel();
        JideTable matrixTable = new JideTable((TableModel)this.matrixModel);
        this.matrixCellRenderer = new MatrixCellRenderer(this.matrixModel);
        matrixTable.setDefaultRenderer(Double.class, (TableCellRenderer)this.matrixCellRenderer);
        matrixTable.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        mainPanel.add("Center", (Component)matrixTable);
        return mainPanel;
    }

    private String getStartDateString() {
        String startDateString = "";
        if (this.currentView != null && this.timeSeries != null) {
            TimeCoding timeCoding = this.timeSeries.getRasterTimeMap().get(this.currentView.getRaster());
            Date startDate = timeCoding.getStartTime().getAsDate();
            startDateString = this.dateFormat.format(startDate);
        }
        return startDateString;
    }

    private JPanel createButtonPanel() {
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setRowPadding(0, new Insets(0, 4, 4, 4));
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        JPanel buttonPanel = new JPanel((LayoutManager)tableLayout);
        AbstractButton helpButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Help22.png"), (boolean)false);
        helpButton.setToolTipText("Help");
        buttonPanel.add(this.matrixSizeSpinner);
        buttonPanel.add(tableLayout.createVerticalSpacer());
        buttonPanel.add(helpButton);
        PageComponentDescriptor descriptor = this.getDescriptor();
        if (descriptor.getHelpId() != null) {
            HelpSys.enableHelpOnButton((Component)helpButton, (String)descriptor.getHelpId());
            HelpSys.enableHelpKey((Component)buttonPanel, (String)descriptor.getHelpId());
        }
        return buttonPanel;
    }

    private void setCurrentView(ProductSceneView newView) {
        if (this.currentView == newView) {
            return;
        }
        if (this.currentView != null) {
            this.currentView.removePixelPositionListener((PixelPositionListener)this.pixelPosListener);
            this.removeMouseWheelListener();
            if (this.timeSeries != null) {
                this.timeSeries.removeTimeSeriesListener(this.timeSeriesMatrixTSL);
            }
        }
        this.currentView = newView;
        if (this.isTimeSeriesView(this.currentView)) {
            this.currentView.addPixelPositionListener((PixelPositionListener)this.pixelPosListener);
            this.timeSeries = TimeSeriesMapper.getInstance().getTimeSeries(this.currentView.getProduct());
            this.timeSeries.addTimeSeriesListener(this.timeSeriesMatrixTSL);
            this.addMouseWheelListener();
            RasterDataNode raster = this.currentView.getRaster();
            if (raster instanceof Band) {
                this.matrixModel.setBand((Band)raster);
                this.matrixModel.setMatrixSize((Integer)this.matrixSizeSpinner.getValue());
                this.matrixCellRenderer.setInvalidColor(this.currentView.getLayerCanvas().getBackground());
                this.updateDateLabel((Band)this.currentView.getRaster());
            }
        } else {
            this.timeSeries = null;
            this.matrixModel.setMatrixSize(0);
        }
    }

    private void updateDateLabel(Band band) {
        String dateString = "";
        if (band != null) {
            TimeCoding timeCoding = this.timeSeries.getRasterTimeMap().get(band);
            Date startTime = timeCoding.getStartTime().getAsDate();
            dateString = this.dateFormat.format(startTime);
        }
        this.dateLabel.setText(String.format("Date:  %s", dateString));
    }

    private Band getNextBand(Band currentBand, int direction) {
        String varName = AbstractTimeSeries.rasterToVariableName(currentBand.getName());
        List<Band> bandList = this.timeSeries.getBandsForVariable(varName);
        int currentIndex = bandList.indexOf(currentBand);
        if (direction < 0) {
            if (currentIndex > 0) {
                return bandList.get(currentIndex - 1);
            }
        } else if (currentIndex + 1 < bandList.size()) {
            return bandList.get(currentIndex + 1);
        }
        return currentBand;
    }

    private boolean isTimeSeriesView(ProductSceneView view) {
        if (view != null) {
            RasterDataNode viewRaster = view.getRaster();
            String viewProductType = viewRaster.getProduct().getProductType();
            return !view.isRGB() && viewProductType.equals("org.esa.beam.glob.timeseries") && TimeSeriesMapper.getInstance().getTimeSeries(view.getProduct()) != null;
        }
        return false;
    }

    private void addMouseWheelListener() {
        LayerCanvas layerCanvas;
        List<MouseWheelListener> listeners;
        if (this.currentView != null && !(listeners = Arrays.asList((layerCanvas = this.currentView.getLayerCanvas()).getMouseWheelListeners())).contains(this.mouseWheelListener)) {
            layerCanvas.addMouseWheelListener((MouseWheelListener)this.mouseWheelListener);
        }
    }

    private void removeMouseWheelListener() {
        if (this.currentView != null) {
            this.currentView.getLayerCanvas().removeMouseWheelListener((MouseWheelListener)this.mouseWheelListener);
        }
    }

    private class TimeSeriesMatrixTSL
    extends TimeSeriesListener {
        private TimeSeriesMatrixTSL() {
        }

        public void nodeRemoved(ProductNodeEvent event) {
            ProductNode node = event.getSourceNode();
            if (node == TimeSeriesMatrixToolView.this.matrixModel.getBand()) {
                Band band = TimeSeriesMatrixToolView.this.matrixModel.getBand();
                Band nextBand = TimeSeriesMatrixToolView.this.getNextBand(band, 1);
                if (nextBand == band) {
                    nextBand = TimeSeriesMatrixToolView.this.getNextBand(band, -1);
                }
                if (nextBand == band) {
                    nextBand = null;
                }
                TimeSeriesMatrixToolView.this.updateDateLabel(nextBand);
            }
        }
    }

    private class MatrixMouseWheelListener
    implements MouseWheelListener {
        private MatrixMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Band nextBand;
            if (e.isAltDown() && (nextBand = TimeSeriesMatrixToolView.this.getNextBand(TimeSeriesMatrixToolView.this.matrixModel.getBand(), e.getWheelRotation())) != null) {
                TimeSeriesMatrixToolView.this.matrixModel.setBand(nextBand);
                TimeSeriesMatrixToolView.this.updateDateLabel(nextBand);
            }
        }
    }

    private class TimeSeriesPPL
    implements PixelPositionListener {
        private TimeSeriesPPL() {
        }

        public void pixelPosChanged(ImageLayer imageLayer, int pixelX, int pixelY, int currentLevel, boolean pixelPosValid, MouseEvent e) {
            if (TimeSeriesMatrixToolView.this.isVisible() && TimeSeriesMatrixToolView.this.currentView != null) {
                AffineTransform i2mTransform = imageLayer.getImageToModelTransform(currentLevel);
                Point2D modelP = i2mTransform.transform(new Point2D.Double((double)pixelX + 0.5, (double)pixelY + 0.5), null);
                AffineTransform m2iTransform = imageLayer.getModelToImageTransform();
                Point2D levelZeroP = m2iTransform.transform(modelP, null);
                TimeSeriesMatrixToolView.this.matrixModel.setCenterPixel(MathUtils.floorInt((double)levelZeroP.getX()), MathUtils.floorInt((double)levelZeroP.getY()));
            }
        }

        public void pixelPosNotAvailable() {
            TimeSeriesMatrixToolView.this.matrixModel.clearMatrix();
        }
    }

    private class SceneViewListener
    extends InternalFrameAdapter {
        private SceneViewListener() {
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            Container contentPane = e.getInternalFrame().getContentPane();
            if (contentPane instanceof ProductSceneView) {
                TimeSeriesMatrixToolView.this.setCurrentView((ProductSceneView)contentPane);
            }
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
            Container contentPane = e.getInternalFrame().getContentPane();
            if (TimeSeriesMatrixToolView.this.currentView == contentPane) {
                TimeSeriesMatrixToolView.this.setCurrentView(null);
            }
        }
    }
}

