/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.ui.player;

import com.bc.ceres.swing.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.help.HelpSys;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.application.PageComponentDescriptor;
import org.esa.beam.framework.ui.product.ProductSceneView;
import org.esa.beam.framework.ui.tool.ToolButtonFactory;
import org.esa.beam.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.beam.timeseries.core.timeseries.datamodel.TimeCoding;
import org.esa.beam.timeseries.export.animations.AnimatedGifExport;

class TimeSeriesPlayerForm
extends JPanel {
    private final ImageIcon playIcon = new ImageIcon(this.getClass().getResource("icons/timeseries-play24.png"));
    private final ImageIcon stopIcon = new ImageIcon(this.getClass().getResource("icons/timeseries-stop24.png"));
    private final ImageIcon pauseIcon = UIUtils.loadImageIcon((String)"icons/Pause24.png");
    private final ImageIcon blendIcon = new ImageIcon(this.getClass().getResource("icons/timeseries-blend24.png"));
    private final ImageIcon repeatIcon = new ImageIcon(this.getClass().getResource("icons/timeseries-repeat24.png"));
    private final ImageIcon minusIcon = UIUtils.loadImageIcon((String)"icons/Remove16.png");
    private final ImageIcon plusIcon = UIUtils.loadImageIcon((String)"icons/Add16.png");
    private final ImageIcon exportIcon = UIUtils.loadImageIcon((String)"icons/Export24.gif");
    private final JSlider timeSlider;
    private final AbstractButton playButton;
    private final AbstractButton stopButton;
    private final JLabel dateLabel;
    private final JSlider speedSlider;
    private final JLabel speedLabel;
    private final JLabel speedUnit;
    private final AbstractButton blendButton;
    private Timer timer;
    private final AbstractButton repeatButton;
    private final AbstractButton minusButton;
    private final AbstractButton plusButton;
    private final AbstractButton exportButton;
    private int stepsPerTimespan = 1;
    private int timerDelay = 1250;
    private AbstractTimeSeries timeSeries;
    private ProductSceneView currentView;
    private static final String DATE_SEPARATOR = " ";

    TimeSeriesPlayerForm(PageComponentDescriptor descriptor) {
        this.setLayout(new BorderLayout(4, 4));
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setPreferredSize(new Dimension(350, 200));
        JPanel firstPanel = new JPanel((LayoutManager)TimeSeriesPlayerForm.createLayout());
        firstPanel.setPreferredSize(new Dimension(300, 150));
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        JPanel secondPanel = new JPanel(new BorderLayout());
        this.dateLabel = new JLabel("Date: ");
        this.timeSlider = this.createTimeSlider();
        this.playButton = this.createPlayButton();
        this.stopButton = this.createStopButton();
        this.repeatButton = this.createRepeatButton();
        this.blendButton = this.createBlendButton();
        this.speedLabel = new JLabel("Speed:");
        this.minusButton = this.createMinusButton();
        this.speedSlider = this.createSpeedSlider();
        this.speedUnit = new JLabel();
        this.plusButton = this.createPlusButton();
        this.exportButton = this.createExportButton();
        AbstractButton helpButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Help22.png"), (boolean)false);
        helpButton.setToolTipText("Help");
        this.updateSpeedUnit();
        this.setUIEnabled(false);
        buttonsPanel.add(this.playButton);
        buttonsPanel.add(this.stopButton);
        buttonsPanel.add(this.repeatButton);
        buttonsPanel.add(new JSeparator(1));
        buttonsPanel.add(this.blendButton);
        buttonsPanel.add(new JSeparator(1));
        buttonsPanel.add(this.speedLabel);
        buttonsPanel.add(this.minusButton);
        buttonsPanel.add(this.speedSlider);
        buttonsPanel.add(this.plusButton);
        buttonsPanel.add(this.speedUnit);
        buttonsPanel.add(new JLabel("           "));
        secondPanel.add((Component)this.exportButton, "North");
        secondPanel.add((Component)helpButton, "South");
        if (descriptor.getHelpId() != null) {
            HelpSys.enableHelpOnButton((Component)helpButton, (String)descriptor.getHelpId());
            HelpSys.enableHelpKey((Component)buttonsPanel, (String)descriptor.getHelpId());
        }
        firstPanel.add(this.dateLabel);
        firstPanel.add(this.timeSlider);
        firstPanel.add(buttonsPanel);
        this.add("Center", firstPanel);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add("East", secondPanel);
    }

    List<Band> getBandList(String rasterName) {
        String variableName = AbstractTimeSeries.rasterToVariableName(rasterName);
        return this.timeSeries.getBandsForVariable(variableName);
    }

    void setTimeSeries(AbstractTimeSeries timeSeries) {
        this.timeSeries = timeSeries;
    }

    Timer getTimer() {
        return this.timer;
    }

    void setView(ProductSceneView view) {
        this.currentView = view;
    }

    int getStepsPerTimespan() {
        return this.stepsPerTimespan;
    }

    JSlider getTimeSlider() {
        return this.timeSlider;
    }

    void configureTimeSlider(RasterDataNode raster) {
        if (this.timeSeries != null) {
            List<Band> bandList = this.getBandList(raster.getName());
            this.timeSlider.setMinimum(0);
            int nodeCount = bandList.size();
            int maximum = (nodeCount - 1) * this.stepsPerTimespan;
            this.timeSlider.setMaximum(maximum);
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            if (nodeCount > 1) {
                this.setUIEnabled(true);
                labelTable.put(0, new JLabel(this.createSliderLabelFormattedText(bandList, 0)));
                labelTable.put(maximum, new JLabel(this.createSliderLabelFormattedText(bandList, maximum / this.stepsPerTimespan)));
                this.timeSlider.setLabelTable(labelTable);
            } else {
                this.timeSlider.setLabelTable(null);
                this.setUIEnabled(false);
            }
            int index = bandList.indexOf(raster);
            if (index != -1) {
                this.timeSlider.setValue(index * this.stepsPerTimespan);
            }
        } else {
            this.timeSlider.setLabelTable(null);
            this.setUIEnabled(false);
        }
    }

    private String createSliderLabelText(List<Band> bandList, int index) {
        Band band = bandList.get(index);
        TimeCoding timeCoding = this.timeSeries.getRasterTimeMap().get(band);
        if (timeCoding != null) {
            ProductData.UTC utcStartTime = timeCoding.getStartTime();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy");
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String dateText = dateFormat.format(utcStartTime.getAsCalendar().getTime());
            String timeText = timeFormat.format(utcStartTime.getAsCalendar().getTime());
            return dateText + DATE_SEPARATOR + timeText;
        }
        return "";
    }

    private String createSliderLabelFormattedText(List<Band> bandList, int index) {
        String labelText = this.createSliderLabelText(bandList, index);
        String[] strings = labelText.split(DATE_SEPARATOR);
        return String.format("<html><p align=\"center\"> <font size=\"2\">%s<br>%s</font></p>", strings[0], strings[1]);
    }

    private JSlider createTimeSlider() {
        final JSlider timeSlider = new JSlider(0, 0, 0, 0);
        timeSlider.setMajorTickSpacing(this.stepsPerTimespan);
        timeSlider.setMinorTickSpacing(1);
        timeSlider.setPaintTrack(true);
        timeSlider.setSnapToTicks(true);
        timeSlider.setPaintTicks(true);
        timeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = timeSlider.getValue() / TimeSeriesPlayerForm.this.stepsPerTimespan;
                List<Band> bandList = TimeSeriesPlayerForm.this.getBandList(TimeSeriesPlayerForm.this.currentView.getRaster().getName());
                String labelText = TimeSeriesPlayerForm.this.createSliderLabelText(bandList, index);
                TimeSeriesPlayerForm.this.dateLabel.setText("Date: " + labelText);
            }
        });
        timeSlider.setPreferredSize(new Dimension(320, 60));
        return timeSlider;
    }

    private AbstractButton createPlayButton() {
        ActionListener playAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int currentValue = TimeSeriesPlayerForm.this.timeSlider.getValue();
                if (currentValue == TimeSeriesPlayerForm.this.timeSlider.getMaximum() && TimeSeriesPlayerForm.this.repeatButton.isSelected()) {
                    currentValue = 0;
                } else if (currentValue == TimeSeriesPlayerForm.this.timeSlider.getMaximum() && !TimeSeriesPlayerForm.this.repeatButton.isSelected()) {
                    TimeSeriesPlayerForm.this.playButton.setSelected(false);
                    TimeSeriesPlayerForm.this.timer.stop();
                    TimeSeriesPlayerForm.this.playButton.setIcon(TimeSeriesPlayerForm.this.playIcon);
                    TimeSeriesPlayerForm.this.playButton.setRolloverIcon(TimeSeriesPlayerForm.this.playIcon);
                    currentValue = 0;
                } else {
                    ++currentValue;
                }
                TimeSeriesPlayerForm.this.timeSlider.setValue(currentValue);
            }
        };
        this.timer = new Timer(this.timerDelay, playAction);
        final AbstractButton playButton = ToolButtonFactory.createButton((Icon)this.playIcon, (boolean)false);
        playButton.setToolTipText("Play the time series");
        playButton.setRolloverIcon(this.playIcon);
        playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (playButton.getIcon() == TimeSeriesPlayerForm.this.playIcon) {
                    TimeSeriesPlayerForm.this.timer.start();
                    playButton.setIcon(TimeSeriesPlayerForm.this.pauseIcon);
                    playButton.setRolloverIcon(TimeSeriesPlayerForm.this.pauseIcon);
                } else {
                    TimeSeriesPlayerForm.this.timer.stop();
                    int newValue = TimeSeriesPlayerForm.this.timeSlider.getValue() / TimeSeriesPlayerForm.this.stepsPerTimespan * TimeSeriesPlayerForm.this.stepsPerTimespan;
                    TimeSeriesPlayerForm.this.timeSlider.setValue(newValue);
                    playButton.setIcon(TimeSeriesPlayerForm.this.playIcon);
                    playButton.setRolloverIcon(TimeSeriesPlayerForm.this.playIcon);
                }
            }
        });
        return playButton;
    }

    private AbstractButton createStopButton() {
        AbstractButton stopButton = ToolButtonFactory.createButton((Icon)this.stopIcon, (boolean)false);
        stopButton.setToolTipText("Stop playing the time series");
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSeriesPlayerForm.this.timer.stop();
                TimeSeriesPlayerForm.this.timeSlider.setValue(0);
                TimeSeriesPlayerForm.this.playButton.setIcon(TimeSeriesPlayerForm.this.playIcon);
                TimeSeriesPlayerForm.this.playButton.setRolloverIcon(TimeSeriesPlayerForm.this.playIcon);
                TimeSeriesPlayerForm.this.playButton.setSelected(false);
            }
        });
        return stopButton;
    }

    private AbstractButton createRepeatButton() {
        AbstractButton repeatButton = ToolButtonFactory.createButton((Icon)this.repeatIcon, (boolean)true);
        repeatButton.setToolTipText("Toggle repeat");
        return repeatButton;
    }

    private AbstractButton createBlendButton() {
        final AbstractButton blendButton = ToolButtonFactory.createButton((Icon)this.blendIcon, (boolean)true);
        blendButton.setToolTipText("Toggle blending mode");
        blendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (blendButton.isSelected()) {
                    TimeSeriesPlayerForm.this.stepsPerTimespan = 8;
                    TimeSeriesPlayerForm.this.timeSlider.setValue(0);
                    TimeSeriesPlayerForm.this.timer.setDelay(TimeSeriesPlayerForm.this.calculateTimerDelay());
                    TimeSeriesPlayerForm.this.configureTimeSlider(TimeSeriesPlayerForm.this.currentView.getRaster());
                } else {
                    TimeSeriesPlayerForm.this.stepsPerTimespan = 1;
                    TimeSeriesPlayerForm.this.timeSlider.setValue(0);
                    TimeSeriesPlayerForm.this.timer.setDelay(TimeSeriesPlayerForm.this.calculateTimerDelay());
                    TimeSeriesPlayerForm.this.configureTimeSlider(TimeSeriesPlayerForm.this.currentView.getRaster());
                }
            }
        });
        return blendButton;
    }

    private AbstractButton createMinusButton() {
        AbstractButton minusButton = ToolButtonFactory.createButton((Icon)this.minusIcon, (boolean)false);
        minusButton.setToolTipText("Decrease playing speed");
        minusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimeSeriesPlayerForm.this.speedSlider.getValue() > TimeSeriesPlayerForm.this.speedSlider.getMinimum()) {
                    TimeSeriesPlayerForm.this.speedSlider.setValue(TimeSeriesPlayerForm.this.speedSlider.getValue() - 1);
                }
            }
        });
        return minusButton;
    }

    private JSlider createSpeedSlider() {
        JSlider speedSlider = new JSlider(1, 10);
        speedSlider.setToolTipText("Choose the playing speed");
        speedSlider.setSnapToTicks(true);
        speedSlider.setPaintTrack(true);
        speedSlider.setPaintTicks(true);
        speedSlider.setPaintLabels(true);
        speedSlider.setValue(6);
        speedSlider.setPreferredSize(new Dimension(80, speedSlider.getPreferredSize().height));
        speedSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TimeSeriesPlayerForm.this.timerDelay = TimeSeriesPlayerForm.this.calculateTimerDelay();
                TimeSeriesPlayerForm.this.timer.setDelay(TimeSeriesPlayerForm.this.timerDelay);
                TimeSeriesPlayerForm.this.updateSpeedUnit();
            }
        });
        return speedSlider;
    }

    private AbstractButton createPlusButton() {
        AbstractButton plusButton = ToolButtonFactory.createButton((Icon)this.plusIcon, (boolean)false);
        plusButton.setToolTipText("Increase playing speed");
        plusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimeSeriesPlayerForm.this.speedSlider.getValue() < TimeSeriesPlayerForm.this.speedSlider.getMaximum()) {
                    TimeSeriesPlayerForm.this.speedSlider.setValue(TimeSeriesPlayerForm.this.speedSlider.getValue() + 1);
                }
            }
        });
        return plusButton;
    }

    private AbstractButton createExportButton() {
        AbstractButton exportButton = ToolButtonFactory.createButton((Icon)this.exportIcon, (boolean)false);
        exportButton.setToolTipText("Export as animated gif");
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimatedGifExport export = new AnimatedGifExport(TimeSeriesPlayerForm.this, "Export time series as animated gif");
                String varName = AbstractTimeSeries.rasterToVariableName(TimeSeriesPlayerForm.this.currentView.getRaster().getName());
                export.createFrames(TimeSeriesPlayerForm.this.timeSeries.getBandsForVariable(varName));
                export.executeWithBlocking();
            }
        });
        return exportButton;
    }

    private void setUIEnabled(boolean enable) {
        this.dateLabel.setEnabled(enable);
        this.timeSlider.setPaintLabels(enable);
        this.timeSlider.setEnabled(enable);
        this.playButton.setEnabled(enable);
        this.stopButton.setEnabled(enable);
        this.repeatButton.setEnabled(enable);
        this.blendButton.setEnabled(enable);
        this.speedLabel.setEnabled(enable);
        this.minusButton.setEnabled(enable);
        this.speedSlider.setEnabled(enable);
        this.speedUnit.setEnabled(enable);
        this.plusButton.setEnabled(enable);
        this.exportButton.setEnabled(enable);
    }

    private int calculateTimerDelay() {
        return 250 / this.stepsPerTimespan * (11 - this.speedSlider.getValue());
    }

    private void updateSpeedUnit() {
        double fps = 1.0 / ((double)(this.timerDelay * this.stepsPerTimespan) / 1000.0);
        DecimalFormat formatter = new DecimalFormat("0.00");
        this.speedUnit.setText(formatter.format(fps) + " FPS");
        this.speedUnit.setToolTipText(formatter.format(fps) + " Frames per second");
    }

    private static TableLayout createLayout() {
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setRowPadding(0, new Insets(4, 4, 4, 0));
        tableLayout.setColumnWeightX(0, Double.valueOf(1.0));
        tableLayout.setRowWeightY(1, Double.valueOf(1.0));
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setRowFill(1, TableLayout.Fill.BOTH);
        return tableLayout;
    }
}

