/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.timeseries.ui.player;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.support.LayerUtils;
import com.bc.ceres.glevel.MultiLevelSource;
import java.awt.Container;
import java.lang.reflect.Field;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.ui.application.support.AbstractToolView;
import org.esa.beam.framework.ui.product.ProductSceneImage;
import org.esa.beam.framework.ui.product.ProductSceneView;
import org.esa.beam.glevel.BandImageMultiLevelSource;
import org.esa.beam.timeseries.core.TimeSeriesMapper;
import org.esa.beam.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.beam.timeseries.core.timeseries.datamodel.TimeSeriesChangeEvent;
import org.esa.beam.timeseries.core.timeseries.datamodel.TimeSeriesListener;
import org.esa.beam.timeseries.ui.player.BlendImageLayer;
import org.esa.beam.timeseries.ui.player.TimeSeriesPlayerForm;
import org.esa.beam.util.math.MathUtils;
import org.esa.beam.visat.VisatApp;

public class TimeSeriesPlayerToolView
extends AbstractToolView {
    public static final String TIME_PROPERTY = "timeProperty";
    private final SceneViewListener sceneViewListener = new SceneViewListener();
    private final TimeSeriesListener timeSeriesPlayerTSL = new TimeSeriesPlayerTSL();
    private ProductSceneView currentView;
    private TimeSeriesPlayerForm form;

    protected JComponent createControl() {
        VisatApp.getApp().addInternalFrameListener((InternalFrameListener)this.sceneViewListener);
        this.form = new TimeSeriesPlayerForm(this.getDescriptor());
        this.form.getTimeSlider().addChangeListener(new SliderChangeListener());
        ProductSceneView view = VisatApp.getApp().getSelectedProductSceneView();
        if (view != null) {
            String viewProductType = view.getProduct().getProductType();
            if (!view.isRGB() && viewProductType.equals("org.esa.beam.glob.timeseries") && TimeSeriesMapper.getInstance().getTimeSeries(view.getProduct()) != null) {
                this.setCurrentView(view);
            }
        }
        return this.form;
    }

    private void setCurrentView(ProductSceneView newView) {
        if (this.currentView != newView) {
            if (this.currentView != null) {
                AbstractTimeSeries timeSeries = TimeSeriesMapper.getInstance().getTimeSeries(this.currentView.getProduct());
                timeSeries.removeTimeSeriesListener(this.timeSeriesPlayerTSL);
            }
            this.currentView = newView;
            this.form.setView(this.currentView);
            if (this.currentView != null) {
                Product currentProduct = this.currentView.getProduct();
                AbstractTimeSeries timeSeries = TimeSeriesMapper.getInstance().getTimeSeries(currentProduct);
                timeSeries.addTimeSeriesListener(this.timeSeriesPlayerTSL);
                this.form.setTimeSeries(timeSeries);
                this.exchangeRasterInProductSceneView(this.currentView.getRaster());
                this.reconfigureBaseImageLayer(this.currentView);
                this.form.configureTimeSlider(this.currentView.getRaster());
            } else {
                this.form.setTimeSeries(null);
                this.form.configureTimeSlider(null);
                this.form.getTimer().stop();
            }
        }
    }

    private void exchangeRasterInProductSceneView(RasterDataNode nextRaster) {
        RasterDataNode currentRaster = this.currentView.getRaster();
        ImageInfo imageInfoClone = currentRaster.getImageInfo(ProgressMonitor.NULL).createDeepCopy();
        nextRaster.setImageInfo(imageInfoClone);
        this.currentView.setRasters(new RasterDataNode[]{nextRaster});
        this.currentView.setImageInfo(imageInfoClone.createDeepCopy());
        VisatApp.getApp().getSelectedInternalFrame().setTitle(nextRaster.getDisplayName());
    }

    private void reconfigureBaseImageLayer(ProductSceneView sceneView) {
        Band band;
        Layer rootLayer = this.currentView.getRootLayer();
        ImageLayer baseImageLayer = (ImageLayer)LayerUtils.getChildLayerById((Layer)rootLayer, (String)"org.esa.beam.layers.baseImage");
        List<Band> bandList = this.form.getBandList(this.currentView.getRaster().getName());
        int nextIndex = bandList.indexOf(band = (Band)sceneView.getRaster()) + 1;
        if (nextIndex >= bandList.size()) {
            nextIndex = 0;
        }
        if (!(baseImageLayer instanceof BlendImageLayer)) {
            Band nextBand = bandList.get(nextIndex);
            BandImageMultiLevelSource nextLevelSource = BandImageMultiLevelSource.create((RasterDataNode)nextBand, (ProgressMonitor)ProgressMonitor.NULL);
            BlendImageLayer blendLayer = new BlendImageLayer(baseImageLayer.getMultiLevelSource(), (MultiLevelSource)nextLevelSource);
            List children = rootLayer.getChildren();
            int baseIndex = children.indexOf(baseImageLayer);
            children.remove(baseIndex);
            blendLayer.setId("org.esa.beam.layers.baseImage");
            blendLayer.setName(band.getDisplayName());
            blendLayer.setTransparency(0.0);
            children.add(baseIndex, blendLayer);
            this.configureSceneView(sceneView, (MultiLevelSource)blendLayer.getBaseMultiLevelSource());
        }
    }

    private void configureSceneView(ProductSceneView sceneView, MultiLevelSource multiLevelSource) {
        try {
            Field sceneImageField = ProductSceneView.class.getDeclaredField("sceneImage");
            sceneImageField.setAccessible(true);
            Object sceneImage = sceneImageField.get(sceneView);
            Field multiLevelSourceField = ProductSceneImage.class.getDeclaredField("bandImageMultiLevelSource");
            multiLevelSourceField.setAccessible(true);
            multiLevelSourceField.set(sceneImage, multiLevelSource);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private class TimeSeriesPlayerTSL
    extends TimeSeriesListener {
        private TimeSeriesPlayerTSL() {
        }

        @Override
        public void timeSeriesChanged(TimeSeriesChangeEvent event) {
            if (event.getType() == 8 || event.getType() == 16) {
                TimeSeriesPlayerToolView.this.form.configureTimeSlider(TimeSeriesPlayerToolView.this.currentView.getRaster());
            }
        }

        public void nodeAdded(ProductNodeEvent event) {
            ProductNode productNode = event.getSourceNode();
            if (this.isValidProductNode(productNode) && TimeSeriesPlayerToolView.this.currentView != null) {
                TimeSeriesPlayerToolView.this.form.configureTimeSlider((RasterDataNode)productNode);
            }
        }

        public void nodeRemoved(ProductNodeEvent event) {
            ProductNode productNode = event.getSourceNode();
            if (this.isValidProductNode(productNode) && TimeSeriesPlayerToolView.this.currentView != null && TimeSeriesPlayerToolView.this.currentView.getRaster() == productNode) {
                TimeSeriesPlayerToolView.this.form.configureTimeSlider((RasterDataNode)productNode);
            }
        }

        public void nodeChanged(ProductNodeEvent event) {
            String propertyName = event.getPropertyName();
            if (propertyName.equals("imageInfo")) {
                this.adjustImageInfos(event);
            }
        }

        private boolean isValidProductNode(ProductNode productNode) {
            return productNode instanceof RasterDataNode && !(productNode instanceof Mask);
        }

        private void adjustImageInfos(ProductNodeEvent event) {
            ProductNode node = event.getSourceNode();
            if (this.isValidProductNode(node)) {
                RasterDataNode raster = (RasterDataNode)node;
                ImageLayer baseImageLayer = TimeSeriesPlayerToolView.this.currentView.getBaseImageLayer();
                ImageInfo imageInfo = raster.getImageInfo();
                if (baseImageLayer instanceof BlendImageLayer) {
                    BlendImageLayer blendLayer = (BlendImageLayer)baseImageLayer;
                    blendLayer.getBlendMultiLevelSource().setImageInfo(imageInfo.createDeepCopy());
                }
            }
        }
    }

    private class SliderChangeListener
    implements ChangeListener {
        private int value;

        private SliderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (TimeSeriesPlayerToolView.this.currentView == null) {
                return;
            }
            int currentValue = TimeSeriesPlayerToolView.this.form.getTimeSlider().getValue();
            if (currentValue == this.value || currentValue == -1) {
                return;
            }
            if (TimeSeriesPlayerToolView.this.currentView.getBaseImageLayer() instanceof BlendImageLayer) {
                BlendImageLayer blendLayer = (BlendImageLayer)TimeSeriesPlayerToolView.this.currentView.getBaseImageLayer();
                int stepsPerTimespan = TimeSeriesPlayerToolView.this.form.getStepsPerTimespan();
                float transparency = (float)(currentValue % stepsPerTimespan) / (float)stepsPerTimespan;
                blendLayer.setBlendFactor(transparency);
                List<Band> bandList = TimeSeriesPlayerToolView.this.form.getBandList(TimeSeriesPlayerToolView.this.currentView.getRaster().getName());
                this.value = currentValue;
                int firstBandIndex = MathUtils.floorInt((double)((float)currentValue / (float)stepsPerTimespan));
                int secondBandIndex = MathUtils.ceilInt((double)((float)currentValue / (float)stepsPerTimespan));
                BandImageMultiLevelSource newSource = BandImageMultiLevelSource.create((RasterDataNode)((RasterDataNode)bandList.get(secondBandIndex)), (ProgressMonitor)ProgressMonitor.NULL);
                if (secondBandIndex == firstBandIndex) {
                    TimeSeriesPlayerToolView.this.exchangeRasterInProductSceneView((RasterDataNode)bandList.get(firstBandIndex));
                    blendLayer.setBaseLayer(newSource);
                    TimeSeriesPlayerToolView.this.configureSceneView(TimeSeriesPlayerToolView.this.currentView, (MultiLevelSource)blendLayer.getBaseMultiLevelSource());
                    blendLayer.setName(TimeSeriesPlayerToolView.this.currentView.getRaster().getDisplayName());
                    TimeSeriesPlayerToolView.this.currentView.firePropertyChange(TimeSeriesPlayerToolView.TIME_PROPERTY, -1, firstBandIndex);
                } else {
                    if (transparency == 1.0f / (float)stepsPerTimespan) {
                        blendLayer.setBlendLayer(newSource);
                    }
                    TimeSeriesPlayerToolView.this.currentView.getLayerCanvas().repaint();
                }
            }
        }
    }

    private class SceneViewListener
    extends InternalFrameAdapter {
        private SceneViewListener() {
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            Container contentPane = e.getInternalFrame().getContentPane();
            if (contentPane instanceof ProductSceneView) {
                ProductSceneView view = (ProductSceneView)contentPane;
                RasterDataNode viewRaster = view.getRaster();
                String viewProductType = viewRaster.getProduct().getProductType();
                if (TimeSeriesPlayerToolView.this.currentView != view && !view.isRGB() && viewProductType.equals("org.esa.beam.glob.timeseries") && TimeSeriesMapper.getInstance().getTimeSeries(view.getProduct()) != null) {
                    TimeSeriesPlayerToolView.this.setCurrentView(view);
                }
            }
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
            Container contentPane = e.getInternalFrame().getContentPane();
            if (TimeSeriesPlayerToolView.this.currentView == contentPane) {
                TimeSeriesPlayerToolView.this.setCurrentView(null);
            }
        }
    }
}

