/*
 * Decompiled with CFR 0.152.
 */
package com.bc.swing;

import com.jidesoft.swing.ContentContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class TitledPane
extends ContentContainer {
    private static final long serialVersionUID = 6219377186428413528L;
    public static final String ACTIVATED_PROPERTY_NAME = "activated";
    public static final Color DEFAULT_TITLE_BG_ACTIVE = new Color(82, 109, 165);
    public static final Color DEFAULT_TITLE_FG = Color.white;
    public static final Color DEFAULT_TITLE_BG_DEACTIVE = Color.lightGray.darker();
    private JLabel _titleBar;
    private Component _content;
    private boolean _activated;

    public TitledPane() {
        this(" ", null, null);
    }

    public TitledPane(String title) {
        this(title, null, null);
    }

    public TitledPane(String title, JComponent content) {
        this(title, null, content);
    }

    public TitledPane(String title, Icon icon, JComponent content) {
        this.setLayout(new BorderLayout());
        this._titleBar = new JLabel();
        this._titleBar.setLayout(new FlowLayout(2, 2, 0));
        this._titleBar.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 1));
        if (icon != null) {
            this._titleBar.setIcon(icon);
        }
        if (title != null) {
            this._titleBar.setText(title);
        }
        this.add(this._titleBar, "North");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TitledPane.this.requestFocus();
            }
        });
        this.setContent(content);
        this.setActivated(true);
    }

    public boolean isActivated() {
        return this._activated;
    }

    public void setActivated(boolean activated) {
        boolean oldValue = this._activated;
        if (oldValue != activated) {
            this._activated = activated;
            this.getTitleBar().setBackground(activated ? DEFAULT_TITLE_BG_ACTIVE : DEFAULT_TITLE_BG_DEACTIVE);
            this.firePropertyChange(ACTIVATED_PROPERTY_NAME, oldValue, this._activated);
        }
    }

    public String getTitle() {
        return this.getTitleBar().getText();
    }

    public void setTitle(String title) {
        this.getTitleBar().setText(title);
    }

    public Icon getIcon() {
        return this.getTitleBar().getIcon();
    }

    public void setIcon(Icon icon) {
        this.getTitleBar().setIcon(icon);
    }

    public JLabel getTitleBar() {
        return this._titleBar;
    }

    public Component getContent() {
        return this._content;
    }

    public void setContent(Component content) {
        this.setContent(content, true);
    }

    protected void setContent(Component content, boolean add) {
        if (this._content != content) {
            if (add) {
                this.removeContent();
                this._content = content;
                this.addContent();
            } else {
                this._content = content;
            }
        }
    }

    public static JButton createTitleBarButton(String name, String toolTipText, ActionListener actionListener) {
        ImageIcon imageIcon = null;
        URL url = TitledPane.class.getResource("/com/bc/swing/icons/" + name + ".gif");
        if (url != null) {
            imageIcon = new ImageIcon(url);
        }
        return TitledPane.createTitleBarButton(imageIcon, name, toolTipText, actionListener);
    }

    public static JButton createTitleBarButton(Icon icon, String name, String toolTipText, ActionListener actionListener) {
        String text;
        Dimension iconSize;
        if (icon != null) {
            iconSize = new Dimension(icon.getIconWidth(), icon.getIconHeight());
            text = null;
        } else {
            iconSize = new Dimension(15, 15);
            text = name;
        }
        JButton button = new JButton();
        button.setName(name);
        button.setIcon(icon);
        button.setText(text);
        button.setToolTipText(toolTipText);
        button.addActionListener(actionListener);
        button.setBorder(null);
        button.setBorderPainted(false);
        button.setBackground(DEFAULT_TITLE_BG_ACTIVE);
        button.setMinimumSize(iconSize);
        button.setPreferredSize(iconSize);
        button.setDefaultCapable(false);
        button.setContentAreaFilled(false);
        return button;
    }

    protected boolean isContentInstalled() {
        return TitledPane.getComponentIndex((Container)((Object)this), this._content) != -1;
    }

    protected void addContent() {
        if (this._content != null) {
            this.add(this._content, "Center");
        }
    }

    protected void removeContent() {
        if (this._content != null) {
            this.remove(this._content);
        }
    }

    protected static int getComponentIndex(Container container, Component component) {
        if (container != null && component != null) {
            Component[] components = container.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (components[i] != component) continue;
                return i;
            }
        }
        return -1;
    }
}

