/*
 * Decompiled with CFR 0.152.
 */
package com.bc.swing.desktop;

import com.bc.swing.desktop.InternalFrameLayoutManager;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class DefaultInternalFrameLayoutManager
implements InternalFrameLayoutManager {
    @Override
    public void moveFrameToVisible(JDesktopPane desktopPane, JInternalFrame internalFrame) {
        int y;
        int delta = 128;
        int x = internalFrame.getX();
        if (x > desktopPane.getWidth() - 128) {
            x = desktopPane.getWidth() - 128;
        }
        if (x < 0) {
            x = 0;
        }
        if ((y = internalFrame.getY()) > desktopPane.getHeight() - 128) {
            y = desktopPane.getHeight() - 128;
        }
        if (y < 0) {
            y = 0;
        }
        internalFrame.setLocation(x, y);
    }

    @Override
    public void cascadeFrames(JDesktopPane desktopPane, JInternalFrame[] frames) {
        if (frames.length == 0) {
            return;
        }
        int delta = 24;
        int x = 0;
        int y = 0;
        int nCols = 0;
        int nRows = 0;
        for (int i = 0; i < frames.length; ++i) {
            frames[i].setLocation(x, y);
            y += 24;
            if ((x += 24) > desktopPane.getWidth() - 24) {
                x = ++nCols * 24;
                y = nRows * 24;
            }
            if (y <= desktopPane.getHeight() - 24) continue;
            x = nCols * 24;
            y = ++nRows * 24;
        }
    }

    @Override
    public void tileFramesEvenly(JDesktopPane desktopPane, JInternalFrame[] frames) {
        if (frames.length == 0) {
            return;
        }
        Dimension d = this.getTileSubdivision(desktopPane, frames.length);
        int widthTot = desktopPane.getWidth();
        int heightTot = desktopPane.getHeight();
        int y = 0;
        for (int j = 0; j < d.height; ++j) {
            int h = heightTot / d.height;
            if (j == d.height - 1) {
                h = heightTot - h * (d.height - 1);
            }
            int x = 0;
            for (int i = 0; i < d.width; ++i) {
                int tileIndex;
                int w = widthTot / d.width;
                if (i == d.width - 1) {
                    w = widthTot - w * (d.width - 1);
                }
                if ((tileIndex = j * d.width + i) < frames.length) {
                    JInternalFrame internalFrame = frames[tileIndex];
                    try {
                        internalFrame.setMaximum(false);
                    }
                    catch (PropertyVetoException e) {
                        // empty catch block
                    }
                    internalFrame.setBounds(x, y, w, h);
                }
                x += w;
            }
            y += h;
        }
    }

    @Override
    public void tileFramesHorizontally(JDesktopPane desktopPane, JInternalFrame[] frames) {
        if (frames.length == 0) {
            return;
        }
        int widthTot = desktopPane.getWidth();
        int heightTot = desktopPane.getHeight();
        int x = 0;
        int n = frames.length;
        for (int i = 0; i < n; ++i) {
            int w = widthTot / n;
            if (i == n - 1) {
                w = widthTot - w * (n - 1);
            }
            try {
                frames[i].setMaximum(false);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            frames[i].setBounds(x, 0, w, heightTot);
            x += w;
        }
    }

    @Override
    public void tileFramesVertically(JDesktopPane desktopPane, JInternalFrame[] frames) {
        if (frames.length == 0) {
            return;
        }
        int widthTot = desktopPane.getWidth();
        int heightTot = desktopPane.getHeight();
        int y = 0;
        int n = frames.length;
        for (int i = 0; i < n; ++i) {
            int h = heightTot / n;
            if (i == n - 1) {
                h = heightTot - h * (n - 1);
            }
            try {
                frames[i].setMaximum(false);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            frames[i].setBounds(0, y, widthTot, h);
            y += h;
        }
    }

    private Dimension getTileSubdivision(JDesktopPane desktopPane, int numTiles) {
        double ratio2;
        int numHorTiles = (int)Math.round(Math.sqrt(numTiles));
        if (numHorTiles == 0) {
            numHorTiles = 1;
        }
        int numVerTiles = numTiles / numHorTiles;
        while (numHorTiles * numVerTiles < numTiles) {
            ++numVerTiles;
        }
        double horTileSize1 = (double)desktopPane.getWidth() / (double)numHorTiles;
        double verTileSize1 = (double)desktopPane.getHeight() / (double)numVerTiles;
        double ratio1 = verTileSize1 != 0.0 ? horTileSize1 / verTileSize1 : 1.0;
        double horTileSize2 = (double)desktopPane.getWidth() / (double)numVerTiles;
        double verTileSize2 = (double)desktopPane.getHeight() / (double)numHorTiles;
        double d = ratio2 = verTileSize2 != 0.0 ? horTileSize2 / verTileSize2 : 1.0;
        if (Math.abs(1.0 - ratio1) < Math.abs(1.0 - ratio2)) {
            return new Dimension(numHorTiles, numVerTiles);
        }
        return new Dimension(numVerTiles, numHorTiles);
    }
}

