/*
 * Decompiled with CFR 0.152.
 */
package com.bc.swing.desktop;

import com.bc.swing.desktop.DefaultInternalFrameLayoutManager;
import com.bc.swing.desktop.InternalFrameLayoutManager;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class TabbedDesktopPane
extends JPanel {
    private static final long serialVersionUID = -9125146428340482204L;
    private JDesktopPane desktopPane;
    private JideTabbedPane tabbedPane;
    private InternalFrameHandler frameListener;
    private JMenu windowMenu;
    private WindowMenuListener windowMenuListener;
    private InternalFrameLayoutManager frameLayoutManager;

    public TabbedDesktopPane() {
        this((JTabbedPane)new JideTabbedPane(1, 1), new JDesktopPane());
    }

    public TabbedDesktopPane(JTabbedPane tabbedPane, JDesktopPane desktopPane) {
        super(new BorderLayout());
        this.tabbedPane = (JideTabbedPane)tabbedPane;
        this.desktopPane = desktopPane;
        this.frameListener = new InternalFrameHandler();
        this.windowMenu = null;
        this.windowMenuListener = new WindowMenuListener();
        this.frameLayoutManager = new DefaultInternalFrameLayoutManager();
        this.initUI();
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public InternalFrameLayoutManager getFrameLayoutManager() {
        return this.frameLayoutManager;
    }

    public void setFrameLayoutManager(InternalFrameLayoutManager frameLayoutManager) {
        this.frameLayoutManager = frameLayoutManager;
    }

    public JMenu getWindowMenu() {
        return this.windowMenu;
    }

    public void setWindowMenu(JMenu windowMenu) {
        JMenu windowMenuOld = this.windowMenu;
        if (windowMenuOld != windowMenu) {
            if (windowMenuOld != null) {
                windowMenuOld.removeMenuListener(this.windowMenuListener);
            }
            this.windowMenu = windowMenu;
            if (this.windowMenu != null) {
                this.windowMenu.addMenuListener(this.windowMenuListener);
            }
            this.firePropertyChange("windowMenu", windowMenuOld, this.windowMenu);
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp != this.tabbedPane && comp != this.desktopPane) {
            throw new IllegalStateException("use addFrame method to add internal frames");
        }
        super.addImpl(comp, constraints, index);
    }

    @Override
    public void remove(int index) {
        Component comp = this.getComponent(index);
        if (comp != this.tabbedPane && comp != this.desktopPane) {
            throw new IllegalStateException("use removeFrame method to remove internal frames");
        }
        super.remove(index);
    }

    public JInternalFrame getSelectedFrame() {
        return this.desktopPane.getSelectedFrame();
    }

    public JInternalFrame[] getAllFrames() {
        return this.desktopPane.getAllFrames();
    }

    public JInternalFrame[] getVisibleFrames() {
        JInternalFrame[] allFrames = this.getAllFrames();
        return this.getVisibleFrames(allFrames);
    }

    public void addFrame(final JInternalFrame internalFrame) {
        if (!internalFrame.isVisible()) {
            internalFrame.setVisible(true);
        }
        internalFrame.addInternalFrameListener(this.frameListener);
        this.desktopPane.add(internalFrame);
        this.addTabFor(internalFrame);
        if (internalFrame.isSelected()) {
            this.selectTabFor(internalFrame);
        } else {
            try {
                internalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        internalFrame.addPropertyChangeListener("title", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                InternalFrameProxy placeHolder = TabbedDesktopPane.this.getPlaceHolderFor(internalFrame);
                int index = TabbedDesktopPane.this.tabbedPane.indexOfComponent((Component)placeHolder);
                if (index > -1) {
                    TabbedDesktopPane.this.tabbedPane.setTitleAt(index, internalFrame.getTitle());
                }
            }
        });
    }

    public void closeFrame(JInternalFrame internalFrame) {
        internalFrame.removeInternalFrameListener(this.frameListener);
        try {
            internalFrame.setClosed(true);
        }
        catch (PropertyVetoException e) {
            internalFrame.dispose();
        }
        this.removeTabFor(internalFrame);
        this.desktopPane.remove(internalFrame);
    }

    public void closeAllFrames() {
        JInternalFrame[] allFrames = this.getAllFrames();
        for (int i = allFrames.length - 1; i >= 0; --i) {
            this.closeFrame(allFrames[i]);
        }
    }

    public void moveFrameToVisible(JInternalFrame internalFrame) {
        this.frameLayoutManager.moveFrameToVisible(this.desktopPane, internalFrame);
    }

    public void cascadeFrames() {
        this.frameLayoutManager.cascadeFrames(this.desktopPane, this.reverseFrames(this.getVisibleFrames()));
    }

    public void tileFramesEvenly() {
        this.frameLayoutManager.tileFramesEvenly(this.desktopPane, this.sortFrames(this.getVisibleFrames()));
    }

    public void tileFramesHorizontally() {
        this.frameLayoutManager.tileFramesHorizontally(this.desktopPane, this.sortFrames(this.getVisibleFrames()));
    }

    public void tileFramesVertically() {
        this.frameLayoutManager.tileFramesVertically(this.desktopPane, this.sortFrames(this.getVisibleFrames()));
    }

    private void initUI() {
        this.initTabbedPaneMaxHeight();
        this.updateTabbedPaneVisibility();
        this.desktopPane.setBackground(new Color(51, 102, 153).darker());
        this.tabbedPane.addChangeListener((ChangeListener)new TabbedPaneChangeHandler());
        this.tabbedPane.addMouseListener((MouseListener)new PopupMenuHandler());
        this.tabbedPane.setBackground(this.desktopPane.getBackground());
        this.tabbedPane.setShowCloseButtonOnTab(true);
        this.tabbedPane.setCloseAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InternalFrameProxy placeHolder;
                JInternalFrame selectedFrame;
                Object component = e.getSource();
                if (component instanceof InternalFrameProxy && (selectedFrame = (placeHolder = (InternalFrameProxy)component).getInternalFrame()) != null) {
                    TabbedDesktopPane.this.closeFrame(selectedFrame);
                }
            }
        });
        this.tabbedPane.setShowCloseButton(true);
        this.tabbedPane.setTabShape(6);
        this.tabbedPane.setTabResizeMode(3);
        this.add((Component)this.tabbedPane, "North");
        this.add((Component)this.desktopPane, "Center");
    }

    private void initTabbedPaneMaxHeight() {
    }

    private void updateTabbedPaneVisibility() {
        this.tabbedPane.setVisible(this.tabbedPane.getTabCount() > 0);
    }

    private void addTabFor(JInternalFrame internalFrame) {
        InternalFrameProxy placeHolder = this.getPlaceHolderFor(internalFrame);
        if (placeHolder == null) {
            this.tabbedPane.addTab(internalFrame.getTitle(), (Component)new InternalFrameProxy(internalFrame));
            this.updateTabbedPaneVisibility();
        }
    }

    private void removeTabFor(JInternalFrame internalFrame) {
        InternalFrameProxy placeHolder = this.getPlaceHolderFor(internalFrame);
        if (placeHolder != null) {
            this.tabbedPane.remove((Component)placeHolder);
            this.updateTabbedPaneVisibility();
        }
    }

    private void selectTabFor(JInternalFrame internalFrame) {
        InternalFrameProxy placeHolder = this.getPlaceHolderFor(internalFrame);
        if (placeHolder != null) {
            this.tabbedPane.setSelectedComponent((Component)placeHolder);
        }
    }

    private InternalFrameProxy getPlaceHolderFor(JInternalFrame internalFrame) {
        int n = this.tabbedPane.getComponentCount();
        for (int i = 0; i < n; ++i) {
            InternalFrameProxy placeHolder;
            Component component = this.tabbedPane.getComponent(i);
            if (!(component instanceof InternalFrameProxy) || (placeHolder = (InternalFrameProxy)component).getInternalFrame() != internalFrame) continue;
            return placeHolder;
        }
        return null;
    }

    private void updateWindowMenu() {
        if (this.windowMenu == null) {
            return;
        }
        this.windowMenu.removeAll();
        JInternalFrame[] allFrames = this.getAllFrames();
        this.sortFrames(allFrames);
        JInternalFrame[] visibleFrames = this.getVisibleFrames(allFrames);
        JMenuItem cascadeMenuItem = new JMenuItem("Cascade");
        cascadeMenuItem.setMnemonic('C');
        cascadeMenuItem.setEnabled(visibleFrames.length > 1);
        cascadeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedDesktopPane.this.cascadeFrames();
            }
        });
        this.windowMenu.add(cascadeMenuItem);
        JMenuItem tileEMenuItem = new JMenuItem("Tile Evenly");
        tileEMenuItem.setMnemonic('E');
        tileEMenuItem.setEnabled(visibleFrames.length > 1);
        tileEMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedDesktopPane.this.tileFramesEvenly();
            }
        });
        this.windowMenu.add(tileEMenuItem);
        JMenuItem tileHMenuItem = new JMenuItem("Tile Horizontally");
        tileHMenuItem.setMnemonic('H');
        tileHMenuItem.setEnabled(visibleFrames.length > 1);
        tileHMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedDesktopPane.this.tileFramesHorizontally();
            }
        });
        this.windowMenu.add(tileHMenuItem);
        JMenuItem tileVMenuItem = new JMenuItem("Tile Vertically");
        tileVMenuItem.setMnemonic('V');
        tileVMenuItem.setEnabled(visibleFrames.length > 1);
        tileVMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedDesktopPane.this.tileFramesVertically();
            }
        });
        this.windowMenu.add(tileVMenuItem);
        this.windowMenu.addSeparator();
        JMenuItem closeAllMenuItem = new JMenuItem("Close All");
        closeAllMenuItem.setMnemonic('A');
        closeAllMenuItem.setEnabled(allFrames.length > 0);
        closeAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedDesktopPane.this.closeAllFrames();
            }
        });
        this.windowMenu.add(closeAllMenuItem);
        if (allFrames.length > 0) {
            this.windowMenu.addSeparator();
            for (int i = 0; i < allFrames.length; ++i) {
                final JInternalFrame frame = allFrames[i];
                int windowNo = i + 1;
                char mnemonic = windowNo >= 10 ? (char)(65 + (windowNo - 10)) : (char)(48 + windowNo);
                JCheckBoxMenuItem selectMenuItem = new JCheckBoxMenuItem(mnemonic + " " + frame.getTitle());
                selectMenuItem.setSelected(frame == this.getSelectedFrame());
                selectMenuItem.setMnemonic(mnemonic);
                selectMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            frame.setSelected(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                });
                this.windowMenu.add(selectMenuItem);
            }
        }
    }

    private JInternalFrame[] sortFrames(JInternalFrame[] frames) {
        Arrays.sort(frames, new FrameComparator());
        return frames;
    }

    private JInternalFrame[] reverseFrames(JInternalFrame[] visibleFrames) {
        int n = visibleFrames.length;
        for (int i = 0; i < n / 2; ++i) {
            int j = n - 1 - i;
            JInternalFrame frame = visibleFrames[j];
            visibleFrames[j] = visibleFrames[i];
            visibleFrames[i] = frame;
        }
        return visibleFrames;
    }

    private JInternalFrame[] getVisibleFrames(JInternalFrame[] frames) {
        ArrayList<JInternalFrame> list = new ArrayList<JInternalFrame>();
        for (JInternalFrame frame : frames) {
            if (!frame.isVisible() || frame.isIcon()) continue;
            list.add(frame);
        }
        return list.toArray(new JInternalFrame[list.size()]);
    }

    private class PopupMenuHandler
    extends MouseAdapter {
        private PopupMenuHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Component component;
            int index;
            if (e.getButton() == 2) {
                TabbedDesktopPane.this.closeFrame(TabbedDesktopPane.this.getSelectedFrame());
            }
            if (e.isPopupTrigger() && (index = TabbedDesktopPane.this.tabbedPane.indexAtLocation(e.getX(), e.getY())) >= 0 && (component = TabbedDesktopPane.this.tabbedPane.getComponentAt(index)) instanceof InternalFrameProxy) {
                InternalFrameProxy internalFrameProxy = (InternalFrameProxy)component;
                JInternalFrame thisFrame = internalFrameProxy.getInternalFrame();
                this.showPopupMenu(thisFrame, e);
            }
        }

        private void showPopupMenu(final JInternalFrame thisFrame, MouseEvent e) {
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem closeMenuItem = new JMenuItem("Close");
            closeMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedDesktopPane.this.closeFrame(thisFrame);
                }
            });
            popupMenu.add(closeMenuItem);
            if (TabbedDesktopPane.this.tabbedPane.getTabCount() > 1) {
                JMenuItem closeAllButThisMenuItem = new JMenuItem("Close All But This");
                closeAllButThisMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JInternalFrame[] allFrames;
                        for (JInternalFrame otherFrame : allFrames = TabbedDesktopPane.this.getAllFrames()) {
                            if (otherFrame == thisFrame) continue;
                            TabbedDesktopPane.this.closeFrame(otherFrame);
                        }
                    }
                });
                popupMenu.add(closeAllButThisMenuItem);
                JMenuItem closeAllMenuItem = new JMenuItem("Close All");
                closeAllMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TabbedDesktopPane.this.closeAllFrames();
                    }
                });
                popupMenu.add(closeAllMenuItem);
            }
            popupMenu.show((Component)TabbedDesktopPane.this.tabbedPane, e.getX(), e.getY());
        }
    }

    private static class FrameComparator
    implements Comparator<JInternalFrame> {
        private FrameComparator() {
        }

        @Override
        public int compare(JInternalFrame f1, JInternalFrame f2) {
            if (f1.getTitle() != null && f2.getTitle() != null) {
                return f1.getTitle().compareTo(f2.getTitle());
            }
            if (f1.getTitle() != null) {
                return 1;
            }
            if (f2.getTitle() != null) {
                return -1;
            }
            return 0;
        }
    }

    private class WindowMenuListener
    implements MenuListener {
        private WindowMenuListener() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            TabbedDesktopPane.this.updateWindowMenu();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }

    private class TabbedPaneChangeHandler
    implements ChangeListener {
        private TabbedPaneChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Component selectedComponent = TabbedDesktopPane.this.tabbedPane.getSelectedComponent();
            if (selectedComponent instanceof InternalFrameProxy) {
                InternalFrameProxy placeHolder = (InternalFrameProxy)selectedComponent;
                if (placeHolder.getInternalFrame().isIcon()) {
                    try {
                        placeHolder.getInternalFrame().setIcon(false);
                    }
                    catch (PropertyVetoException ignored) {
                        // empty catch block
                    }
                }
                if (!placeHolder.getInternalFrame().isSelected()) {
                    try {
                        placeHolder.getInternalFrame().setSelected(true);
                    }
                    catch (PropertyVetoException ignored) {
                        // empty catch block
                    }
                }
            }
            TabbedDesktopPane.this.updateTabbedPaneVisibility();
        }
    }

    private class InternalFrameHandler
    extends InternalFrameAdapter {
        private InternalFrameHandler() {
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            TabbedDesktopPane.this.removeTabFor(e.getInternalFrame());
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            JInternalFrame internalFrame = e.getInternalFrame();
            TabbedDesktopPane.this.selectTabFor(internalFrame);
            TabbedDesktopPane.this.moveFrameToVisible(internalFrame);
        }
    }

    private static class InternalFrameProxy
    extends JComponent {
        private static final long serialVersionUID = 1961531463465924691L;
        private final JInternalFrame internalFrame;

        public InternalFrameProxy(JInternalFrame internalFrame) {
            this.setVisible(false);
            this.setSize(0, 0);
            this.setPreferredSize(this.getSize());
            this.setMaximumSize(this.getSize());
            this.internalFrame = internalFrame;
        }

        public JInternalFrame getInternalFrame() {
            return this.internalFrame;
        }
    }
}

