/*
 * Decompiled with CFR 0.152.
 */
package com.bc.swing.dock;

import com.bc.swing.TitledPane;
import com.bc.swing.dock.DockableComponent;
import com.bc.swing.dock.FloatingComponent;
import com.bc.swing.dock.FloatingComponentFactory;
import com.bc.swing.dock.FloatingWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class DockablePane
extends JPanel
implements DockableComponent {
    private static final long serialVersionUID = -7929784460684679243L;
    public static final String FLOATING_COMPONENT_FACTORY_PROPERTY_NAME = "floatingComponentFactory";
    public static final String DOCKED_PROPERTY_NAME = "docked";
    private TitledPane titledPane;
    private FloatingComponentFactory floatingComponentFactory;
    private FloatingComponent floatingComponent;
    private boolean docked;
    private boolean closable;
    private Window ownerWindow;
    private Rectangle bounds;
    private Object constraints;
    private int componentIndex;
    private Vector windowListeners;

    public DockablePane(String title, Icon icon, JComponent content, boolean closable, FloatingComponentFactory factory) {
        this(title, icon, content, null, closable, factory);
    }

    public DockablePane(String title, Icon icon, JComponent content, Object constraints, boolean closable, FloatingComponentFactory factory) {
        this(title, icon, content, constraints, -1, closable, factory);
    }

    public DockablePane(String title, Icon icon, JComponent content, int componentIndex, boolean closable, FloatingComponentFactory factory) {
        this(title, icon, content, null, componentIndex, closable, factory);
    }

    private DockablePane(String title, Icon icon, JComponent content, Object constraints, int componentIndex, boolean closable, FloatingComponentFactory factory) {
        this.constraints = constraints;
        this.componentIndex = componentIndex;
        this.floatingComponentFactory = factory;
        this.docked = true;
        this.closable = closable;
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setLayout(new BorderLayout());
        this.titledPane = new TitledPane(title, icon, content);
        AbstractButton floatButton = this.createFloatButton();
        JLabel titleBar = this.titledPane.getTitleBar();
        titleBar.add(floatButton);
        if (this.closable) {
            this.titledPane.getTitleBar().add(this.createHideButton());
        }
        this.add((Component)((Object)this.titledPane), "Center");
    }

    public void setShown(boolean show) {
        boolean wasShowing = this.isContentShown();
        if (!wasShowing && show) {
            this.addThisToParent();
        }
        if (wasShowing && !show) {
            if (!this.docked) {
                this.setDocked(true);
            }
            this.removeThisFromParent();
        }
    }

    public boolean isContentShown() {
        return this.getContent().isShowing();
    }

    @Override
    public boolean isDocked() {
        return this.docked;
    }

    @Override
    public void setDocked(boolean docked) {
        boolean wasDocked = this.docked;
        if (wasDocked != docked) {
            if (wasDocked) {
                this.openFloatingComponent();
            } else {
                this.closeFloatingComponent();
            }
            this.docked = docked;
            this.firePropertyChange(DOCKED_PROPERTY_NAME, wasDocked, this.docked);
        }
    }

    public FloatingComponentFactory getFloatingComponentFactory() {
        return this.floatingComponentFactory;
    }

    public void setFloatingComponentFactory(FloatingComponentFactory floatingComponentFactory) {
        FloatingComponentFactory oldValue = this.floatingComponentFactory;
        if (oldValue != floatingComponentFactory) {
            this.floatingComponentFactory = floatingComponentFactory;
            this.firePropertyChange(FLOATING_COMPONENT_FACTORY_PROPERTY_NAME, oldValue, this.floatingComponentFactory);
        }
    }

    public Icon getIcon() {
        return this.titledPane.getIcon();
    }

    public String getTitle() {
        return this.titledPane.getTitle();
    }

    public Component getContent() {
        if (this.floatingComponent != null) {
            return this.floatingComponent.getContent();
        }
        return this.titledPane.getContent();
    }

    public void setContent(Component content) {
        if (this.floatingComponent != null) {
            this.floatingComponent.setContent(content);
        } else {
            this.titledPane.setContent(content);
        }
    }

    public void addWindowListener(WindowListener l) {
        if (this.windowListeners == null) {
            this.windowListeners = new Vector();
        }
        this.windowListeners.add(l);
        if (!this.docked && this.floatingComponent != null) {
            this.floatingComponent.addWindowListener(l);
        }
    }

    public void removeWindowListener(WindowListener l) {
        if (this.windowListeners == null) {
            return;
        }
        this.windowListeners.remove(l);
        if (!this.docked && this.floatingComponent != null) {
            this.floatingComponent.removeWindowListener(l);
        }
    }

    private void addThisToParent() {
        this.setVisible(true);
    }

    private void removeThisFromParent() {
        this.ownerWindow = SwingUtilities.windowForComponent(this);
        if (this.bounds == null) {
            this.bounds = new Rectangle(this.getLocationOnScreen(), this.getSize());
        }
        this.setVisible(false);
    }

    private void openFloatingComponent() {
        this.removeThisFromParent();
        Component content = this.titledPane.getContent();
        this.titledPane.setContent(null);
        this.floatingComponent = this.floatingComponentFactory.createFloatingComponent(this.ownerWindow);
        if (this.floatingComponent instanceof FloatingWindow) {
            FloatingWindow floatingWindow = (FloatingWindow)this.floatingComponent;
            floatingWindow.setClosable(this.closable);
        }
        this.floatingComponent.setOriginator(this);
        this.floatingComponent.setIcon(this.titledPane.getIcon());
        this.floatingComponent.setTitle(this.titledPane.getTitle());
        this.floatingComponent.setContent(content);
        if (this.bounds != null) {
            this.floatingComponent.setBounds(this.bounds);
        }
        if (this.windowListeners != null) {
            for (Object windowListener : this.windowListeners) {
                this.floatingComponent.addWindowListener((WindowListener)windowListener);
            }
        }
        this.floatingComponent.show();
    }

    private void closeFloatingComponent() {
        Component content = this.floatingComponent.getContent();
        this.bounds = this.floatingComponent.getBounds();
        this.floatingComponent.close();
        if (this.windowListeners != null) {
            for (Object windowListener : this.windowListeners) {
                this.floatingComponent.removeWindowListener((WindowListener)windowListener);
            }
        }
        this.floatingComponent = null;
        this.titledPane.setContent(content);
        this.addThisToParent();
    }

    protected AbstractButton createFloatButton() {
        return TitledPane.createTitleBarButton("undock", "Float", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockablePane.this.setDocked(false);
            }
        });
    }

    protected AbstractButton createHideButton() {
        return TitledPane.createTitleBarButton("close", "Close", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockablePane.this.removeThisFromParent();
            }
        });
    }

    public static int getComponentIndex(Container container, Component component) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (container.getComponent(i) != component) continue;
            return i;
        }
        return -1;
    }
}

