/*
 * Decompiled with CFR 0.152.
 */
package com.bc.swing.dock;

import com.bc.swing.dock.DockableComponent;
import com.bc.swing.dock.FloatingComponent;
import com.bc.swing.dock.FloatingComponentFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JDialog;

public class FloatingDialog
extends JDialog
implements FloatingComponent {
    private static final long serialVersionUID = 4032105256845729611L;
    private static final FloatingComponentFactory _factory = new Factory();
    private Component _content;
    private DockableComponent _originator;

    public FloatingDialog(Frame owner) {
        super(owner);
        this.installCloseHandler();
    }

    public FloatingDialog(Dialog owner) {
        super(owner);
        this.installCloseHandler();
    }

    public static FloatingComponentFactory getFactory() {
        return _factory;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public void setIcon(Icon icon) {
    }

    @Override
    public DockableComponent getOriginator() {
        return this._originator;
    }

    @Override
    public void setOriginator(DockableComponent floatableComponent) {
        this._originator = floatableComponent;
    }

    @Override
    public Component getContent() {
        return this._content;
    }

    @Override
    public void setContent(Component content) {
        this.removeContent();
        this._content = content;
        this.addContent();
    }

    @Override
    public void close() {
        this.setVisible(false);
        this.removeContent();
        this.dispose();
    }

    private void addContent() {
        if (this._content != null) {
            this.getContentPane().add(this._content, "Center");
        }
    }

    private void removeContent() {
        if (this._content != null) {
            this.getContentPane().remove(this._content);
        }
    }

    private void installCloseHandler() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowIconified(WindowEvent e) {
                FloatingDialog.this.getOriginator().setDocked(true);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                FloatingDialog.this.getOriginator().setDocked(true);
            }
        });
    }

    private static class Factory
    implements FloatingComponentFactory {
        private Factory() {
        }

        @Override
        public FloatingComponent createFloatingComponent(Window owner) {
            if (owner instanceof Frame) {
                return new FloatingDialog((Frame)owner);
            }
            if (owner instanceof Dialog) {
                return new FloatingDialog((Dialog)owner);
            }
            return new FloatingDialog((Frame)null);
        }
    }
}

