/*
 * Decompiled with CFR 0.152.
 */
package com.bc.swing.dock;

import com.bc.swing.dock.DockableComponent;
import com.bc.swing.dock.FloatingComponent;
import com.bc.swing.dock.FloatingComponentFactory;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;

public class FloatingDockableFrame
implements FloatingComponent {
    private static final int CONTENT_INDEX = 0;
    private DockableFrame dockableFrame;
    private DockableComponent originator;
    private final Window owner;
    private final DockingManager dockManager;

    public FloatingDockableFrame(Window owner, DockingManager dockManager) {
        this.owner = owner;
        this.dockManager = dockManager;
        this.dockableFrame = new DockableFrame();
        this.dockableFrame.setFloatable(true);
        this.dockableFrame.setDockable(true);
        this.dockableFrame.getContext().setInitMode(1);
        this.dockableFrame.setCloseAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FloatingDockableFrame.this.getOriginator() != null) {
                    FloatingDockableFrame.this.getOriginator().setDocked(true);
                }
            }
        });
        this.dockableFrame.setVisible(true);
    }

    public static FloatingComponentFactory getFactory(DockingManager dockManager) {
        return new Factory(dockManager);
    }

    @Override
    public String getTitle() {
        return this.dockableFrame.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.dockableFrame.setTitle(title);
    }

    @Override
    public Icon getIcon() {
        return this.dockableFrame.getFrameIcon();
    }

    @Override
    public void setIcon(Icon icon) {
        this.dockableFrame.setFrameIcon(icon);
    }

    @Override
    public Component getContent() {
        return this.dockableFrame.getContentPane().getComponent(0);
    }

    @Override
    public void setContent(Component component) {
        this.dockableFrame.getContentPane().add(component, 0);
    }

    @Override
    public DockableComponent getOriginator() {
        return this.originator;
    }

    @Override
    public void setOriginator(DockableComponent originator) {
        this.originator = originator;
    }

    @Override
    public Rectangle getBounds() {
        return this.dockableFrame.getBounds();
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.dockableFrame.setBounds(bounds);
    }

    @Override
    public void show() {
        this.dockableFrame.setKey(this.owner.getName() + "." + this.getTitle());
        this.dockManager.addFrame(this.dockableFrame);
        this.dockableFrame.setVisible(true);
    }

    @Override
    public void close() {
        this.dockableFrame.setVisible(false);
        this.dockManager.removeFrame(this.dockableFrame.getKey());
    }

    @Override
    public void addWindowListener(WindowListener l) {
    }

    @Override
    public void removeWindowListener(WindowListener l) {
    }

    private static class Factory
    implements FloatingComponentFactory {
        private DockingManager dockManager;

        private Factory(DockingManager dockManager) {
            this.dockManager = dockManager;
        }

        @Override
        public FloatingComponent createFloatingComponent(Window owner) {
            return new FloatingDockableFrame(owner, this.dockManager);
        }
    }
}

