/*
 * Decompiled with CFR 0.152.
 */
package com.bc.swing.dock;

import com.bc.swing.dock.DockableComponent;
import com.bc.swing.dock.FloatingComponent;
import com.bc.swing.dock.FloatingComponentFactory;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JFrame;

public class FloatingFrame
extends JFrame
implements FloatingComponent {
    private static final long serialVersionUID = -3035735264669355324L;
    private static final FloatingComponentFactory _factory = new Factory();
    private Component _content;
    private DockableComponent _originator;

    public FloatingFrame() {
        this.installCloseHandler();
    }

    public static FloatingComponentFactory getFactory() {
        return _factory;
    }

    @Override
    public DockableComponent getOriginator() {
        return this._originator;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public void setIcon(Icon title) {
    }

    @Override
    public void setOriginator(DockableComponent floatable) {
        this._originator = floatable;
    }

    @Override
    public Component getContent() {
        return this._content;
    }

    @Override
    public void setContent(Component content) {
        if (this._content != null) {
            this.getContentPane().remove(this._content);
        }
        this._content = content;
        if (content != null) {
            this.getContentPane().add(this._content, "Center");
        }
    }

    @Override
    public void close() {
        this.setVisible(false);
        if (this._content != null) {
            this.getContentPane().remove(this._content);
        }
        this.dispose();
    }

    private void installCloseHandler() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowIconified(WindowEvent e) {
                FloatingFrame.this.getOriginator().setDocked(true);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                FloatingFrame.this.getOriginator().setDocked(true);
            }
        });
    }

    private static class Factory
    implements FloatingComponentFactory {
        private Factory() {
        }

        @Override
        public FloatingComponent createFloatingComponent(Window owner) {
            return new FloatingFrame();
        }
    }
}

