/*
 * Decompiled with CFR 0.152.
 */
package com.bc.swing.dock;

import com.bc.swing.TitledPane;
import com.bc.swing.dock.DockableComponent;
import com.bc.swing.dock.FloatingComponent;
import com.bc.swing.dock.FloatingComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class FloatingWindow
extends Window
implements FloatingComponent {
    private static final long serialVersionUID = -5158606919190241950L;
    public static final int BORDER_SIZE = 4;
    public static final int EDGE_SIZE = 12;
    private static final FloatingComponentFactory _factory = new Factory();
    private TitledPane _titledPane;
    private DockableComponent _originator;
    private static Cursor[] _resizeCursors = new Cursor[9];
    private JButton _closeButton;

    public static Cursor getResizeCursor(int resizeMode) {
        return _resizeCursors[resizeMode];
    }

    public FloatingWindow(Frame owner) {
        super(owner);
        this.createUI();
    }

    public FloatingWindow(Window owner) {
        super(owner);
        this.createUI();
    }

    public static FloatingComponentFactory getFactory() {
        return _factory;
    }

    @Override
    public Icon getIcon() {
        return this._titledPane.getIcon();
    }

    @Override
    public void setIcon(Icon icon) {
        this._titledPane.setIcon(icon);
    }

    @Override
    public String getTitle() {
        return this._titledPane.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this._titledPane.setTitle(title);
    }

    @Override
    public Component getContent() {
        return this._titledPane.getContent();
    }

    @Override
    public void setContent(Component content) {
        this._titledPane.setContent(content);
    }

    @Override
    public DockableComponent getOriginator() {
        return this._originator;
    }

    @Override
    public void setOriginator(DockableComponent floatableComponent) {
        this._originator = floatableComponent;
    }

    @Override
    public void close() {
        this.processWindowEvent(new WindowEvent(this, 201));
        this.setVisible(false);
        this.remove((Component)((Object)this._titledPane));
        this.dispose();
        this.processWindowEvent(new WindowEvent(this, 202));
    }

    public void setClosable(boolean closable) {
        this._titledPane.getTitleBar().remove(this._closeButton);
    }

    private void createUI() {
        WindowMouseHandler windowMouseHandler = new WindowMouseHandler();
        TitleBarMouseHandler titleBarMouseHandler = new TitleBarMouseHandler();
        JButton dockButton = this.createDockButton();
        this._closeButton = this.createCloseButton();
        this._titledPane = new TitledPane(" ");
        this._titledPane.getTitleBar().add(dockButton);
        this._titledPane.getTitleBar().add(this._closeButton);
        this._titledPane.getTitleBar().addMouseListener(titleBarMouseHandler);
        this._titledPane.getTitleBar().addMouseMotionListener(titleBarMouseHandler);
        this._titledPane.setBorder(new TitleBorder());
        this._titledPane.addMouseListener(windowMouseHandler);
        this._titledPane.addMouseMotionListener(windowMouseHandler);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this._titledPane), "Center");
        this.pack();
    }

    protected JButton createCloseButton() {
        return TitledPane.createTitleBarButton("close", "Close", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloatingWindow.this.close();
            }
        });
    }

    protected JButton createDockButton() {
        return TitledPane.createTitleBarButton("dock", "Dock", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloatingWindow.this.getOriginator().setDocked(true);
            }
        });
    }

    protected Point convertPointToScreen(MouseEvent e) {
        Point point = e.getPoint();
        SwingUtilities.convertPointToScreen(point, e.getComponent());
        return point;
    }

    static {
        FloatingWindow._resizeCursors[0] = Cursor.getDefaultCursor();
        FloatingWindow._resizeCursors[1] = Cursor.getPredefinedCursor(8);
        FloatingWindow._resizeCursors[5] = Cursor.getPredefinedCursor(9);
        FloatingWindow._resizeCursors[7] = Cursor.getPredefinedCursor(10);
        FloatingWindow._resizeCursors[3] = Cursor.getPredefinedCursor(11);
        FloatingWindow._resizeCursors[8] = Cursor.getPredefinedCursor(6);
        FloatingWindow._resizeCursors[2] = Cursor.getPredefinedCursor(7);
        FloatingWindow._resizeCursors[6] = Cursor.getPredefinedCursor(4);
        FloatingWindow._resizeCursors[4] = Cursor.getPredefinedCursor(5);
    }

    private static class Factory
    implements FloatingComponentFactory {
        private Factory() {
        }

        @Override
        public FloatingComponent createFloatingComponent(Window owner) {
            return new FloatingWindow(owner);
        }
    }

    private static class TitleBorder
    implements Border {
        private TitleBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(c.getBackground());
            g.draw3DRect(x, y, width - 1, height - 1, true);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(4, 4, 4, 4);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    private class TitleBarMouseHandler
    extends MouseInputAdapter {
        private Point _point;

        private TitleBarMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._point = FloatingWindow.this.convertPointToScreen(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this._point = null;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this._point != null) {
                this.mouseDragged(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point p = FloatingWindow.this.convertPointToScreen(e);
            int dx = p.x - this._point.x;
            int dy = p.y - this._point.y;
            this._point = p;
            if (dx != 0 || dy != 0) {
                this.repositionWindow(dx, dy);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            FloatingWindow.this.setCursor(Cursor.getDefaultCursor());
        }

        private void repositionWindow(int dx, int dy) {
            FloatingWindow.this.setLocation(FloatingWindow.this.getX() + dx, FloatingWindow.this.getY() + dy);
        }
    }

    private class WindowMouseHandler
    extends MouseInputAdapter {
        private Point _point;
        private int _resizeMode;
        private Cursor _currentCursor;

        private WindowMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._point = FloatingWindow.this.convertPointToScreen(e);
            this._resizeMode = this.getResizeMode(e);
            this.setResizeCursor(this._resizeMode);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this._point = null;
            this._resizeMode = 0;
            this.setResizeCursor(this._resizeMode);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this._resizeMode > 0) {
                this.mouseDragged(e);
            } else {
                this.setResizeCursor(this.getResizeMode(e));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this._resizeMode > 0) {
                Point p = FloatingWindow.this.convertPointToScreen(e);
                int dx = p.x - this._point.x;
                int dy = p.y - this._point.y;
                this._point = p;
                if (dx != 0 || dy != 0) {
                    this.resizeWindow(dx, dy);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setResizeCursor(this.getResizeMode(e));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setResizeCursor(0);
        }

        private void setResizeCursor(int resizeMode) {
            this.setCurrentCursor(FloatingWindow.getResizeCursor(resizeMode));
        }

        private void setCurrentCursor(Cursor currentCursor) {
            if (currentCursor != this._currentCursor) {
                this._currentCursor = currentCursor;
                FloatingWindow.this.setCursor(this._currentCursor);
            }
        }

        private int getResizeMode(MouseEvent e) {
            int w = FloatingWindow.this.getWidth();
            int h = FloatingWindow.this.getHeight();
            int a = 12;
            int b = 4;
            Point p = e.getPoint();
            if (p.x < a && p.y < a) {
                return 8;
            }
            if (p.x > w - a && p.y < a) {
                return 2;
            }
            if (p.x < a && p.y > h - a) {
                return 6;
            }
            if (p.x > w - a && p.y > h - a) {
                return 4;
            }
            if (p.y < b) {
                return 1;
            }
            if (p.y > h - b) {
                return 5;
            }
            if (p.x < b) {
                return 7;
            }
            if (p.x > w - b) {
                return 3;
            }
            return 0;
        }

        private void resizeWindow(int dx, int dy) {
            int x = FloatingWindow.this.getX();
            int y = FloatingWindow.this.getY();
            int w = FloatingWindow.this.getWidth();
            int h = FloatingWindow.this.getHeight();
            int rm = this._resizeMode;
            if (rm == 1) {
                y += dy;
                h -= dy;
            } else if (rm == 5) {
                h += dy;
            } else if (rm == 7) {
                x += dx;
                w -= dx;
            } else if (rm == 3) {
                w += dx;
            } else if (rm == 8) {
                x += dx;
                y += dy;
                w -= dx;
                h -= dy;
            } else if (rm == 2) {
                y += dy;
                w += dx;
                h -= dy;
            } else if (rm == 6) {
                x += dx;
                w -= dx;
                h += dy;
            } else if (rm == 4) {
                w += dx;
                h += dy;
            }
            FloatingWindow.this.setBounds(x, y, w, h);
            FloatingWindow.this.invalidate();
            FloatingWindow.this.validate();
            FloatingWindow.this.repaint();
        }
    }
}

