/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.runtime.Activator;
import com.bc.ceres.core.runtime.ConfigurationElement;
import com.bc.ceres.core.runtime.Extension;
import com.bc.ceres.core.runtime.ExtensionPoint;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.ModuleContext;
import com.bc.ceres.core.runtime.ModuleState;
import com.sun.java.help.search.QueryEngine;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.help.HelpSet;
import javax.help.HelpSetFactory;
import org.esa.beam.BeamCoreActivator;
import org.esa.beam.framework.help.HelpSys;
import org.esa.beam.framework.ui.application.ApplicationDescriptor;
import org.esa.beam.framework.ui.application.ToolViewDescriptor;
import org.esa.beam.framework.ui.application.ToolViewDescriptorRegistry;
import org.esa.beam.framework.ui.command.Command;
import org.esa.beam.framework.ui.command.CommandGroup;
import org.esa.beam.framework.ui.layer.LayerEditorDescriptor;
import org.esa.beam.framework.ui.layer.LayerSourceDescriptor;
import org.esa.beam.util.TreeNode;

public class BeamUiActivator
implements Activator,
ToolViewDescriptorRegistry {
    private static BeamUiActivator instance;
    private ModuleContext moduleContext;
    private TreeNode<HelpSet> helpSetRegistry;
    private List<Command> actionList;
    private List<CommandGroup> actionGroupList;
    private Map<String, ToolViewDescriptor> toolViewDescriptorRegistry;
    private Map<String, LayerSourceDescriptor> layerSourcesRegistry;
    private ApplicationDescriptor applicationDescriptor;
    private int helpSetNo;

    public void start(ModuleContext moduleContext) throws CoreException {
        this.moduleContext = moduleContext;
        instance = this;
        this.registerHelpSets(moduleContext);
        this.registerToolViews(moduleContext);
        this.registerActions(moduleContext);
        this.registerActionGroups(moduleContext);
        this.registerApplicationDescriptors(moduleContext);
        this.registerLayerEditors(moduleContext);
        this.registerLayerSources(moduleContext);
    }

    public void stop(ModuleContext moduleContext) throws CoreException {
        this.helpSetRegistry = null;
        this.moduleContext = null;
        this.actionList = null;
        this.toolViewDescriptorRegistry = null;
        this.applicationDescriptor = null;
        instance = null;
    }

    private void registerApplicationDescriptors(ModuleContext moduleContext) {
        List applicationDescriptorList = BeamCoreActivator.loadExecutableExtensions((ModuleContext)moduleContext, (String)"applicationDescriptors", (String)"applicationDescriptor", ApplicationDescriptor.class);
        String applicationId = this.getApplicationId();
        for (ApplicationDescriptor applicationDescriptor : applicationDescriptorList) {
            if (applicationId.equals(applicationDescriptor.getApplicationId())) {
                String[] actionGroupIds;
                String[] actionIds;
                String[] toolViewIds;
                moduleContext.getLogger().info(String.format("Using application descriptor [%s]", applicationId));
                this.applicationDescriptor = applicationDescriptor;
                for (String toolViewId : toolViewIds = applicationDescriptor.getExcludedToolViews()) {
                    BeamUiActivator.getInstance().removeToolViewDescriptor(toolViewId);
                    moduleContext.getLogger().info(String.format("Removed toolview [%s]", toolViewId));
                }
                for (String actionId : actionIds = applicationDescriptor.getExcludedActions()) {
                    BeamUiActivator.getInstance().removeAction(actionId);
                    moduleContext.getLogger().info(String.format("Removed action [%s]", actionId));
                }
                for (String actionGroupId : actionGroupIds = applicationDescriptor.getExcludedActionGroups()) {
                    BeamUiActivator.getInstance().removeActionGroup(actionGroupId);
                    moduleContext.getLogger().info(String.format("Removed action group [%s]", actionGroupId));
                }
                continue;
            }
            moduleContext.getLogger().warning(String.format("Ignoring application descriptor [%s]", applicationId));
        }
    }

    public static BeamUiActivator getInstance() {
        return instance;
    }

    public ModuleContext getModuleContext() {
        return this.moduleContext;
    }

    public String getApplicationId() {
        return this.moduleContext.getRuntimeConfig().getApplicationId();
    }

    public ApplicationDescriptor getApplicationDescriptor() {
        return this.applicationDescriptor;
    }

    public List<Command> getCommands() {
        return Collections.unmodifiableList(this.actionList);
    }

    public List<CommandGroup> getCommandGroups() {
        return Collections.unmodifiableList(this.actionGroupList);
    }

    @Override
    public ToolViewDescriptor[] getToolViewDescriptors() {
        return this.toolViewDescriptorRegistry.values().toArray(new ToolViewDescriptor[this.toolViewDescriptorRegistry.values().size()]);
    }

    @Override
    public ToolViewDescriptor getToolViewDescriptor(String viewDescriptorId) {
        return this.toolViewDescriptorRegistry.get(viewDescriptorId);
    }

    public LayerSourceDescriptor[] getLayerSources() {
        return this.layerSourcesRegistry.values().toArray(new LayerSourceDescriptor[this.layerSourcesRegistry.values().size()]);
    }

    public void removeToolViewDescriptor(String viewDescriptorId) {
        this.toolViewDescriptorRegistry.remove(viewDescriptorId);
    }

    public void removeAction(String actionId) {
        for (int i = 0; i < this.actionList.size(); ++i) {
            Command command = this.actionList.get(i);
            if (!actionId.equals(command.getCommandID())) continue;
            this.actionList.remove(i);
            return;
        }
    }

    public void removeActionGroup(String actionGroupId) {
        for (int i = 0; i < this.actionGroupList.size(); ++i) {
            Command command = this.actionGroupList.get(i);
            if (!actionGroupId.equals(command.getCommandID())) continue;
            this.actionGroupList.remove(i);
            return;
        }
    }

    private void registerToolViews(ModuleContext moduleContext) {
        List toolViewDescriptorList = BeamCoreActivator.loadExecutableExtensions((ModuleContext)moduleContext, (String)"toolViews", (String)"toolView", ToolViewDescriptor.class);
        this.toolViewDescriptorRegistry = new HashMap<String, ToolViewDescriptor>(2 * toolViewDescriptorList.size());
        for (ToolViewDescriptor toolViewDescriptor : toolViewDescriptorList) {
            String toolViewId = toolViewDescriptor.getId();
            ToolViewDescriptor existingViewDescriptor = this.toolViewDescriptorRegistry.get(toolViewId);
            if (existingViewDescriptor != null) {
                moduleContext.getLogger().info(String.format("Tool view [%s] has been redeclared!\n", toolViewId));
            }
            this.toolViewDescriptorRegistry.put(toolViewId, toolViewDescriptor);
        }
    }

    private void registerActions(ModuleContext moduleContext) {
        this.actionList = BeamCoreActivator.loadExecutableExtensions((ModuleContext)moduleContext, (String)"actions", (String)"action", Command.class);
        HashMap<String, Command> actionMap = new HashMap<String, Command>(2 * this.actionList.size() + 1);
        for (Command action : new ArrayList<Command>(this.actionList)) {
            String actionId = action.getCommandID();
            Command existingAction = (Command)actionMap.get(actionId);
            if (existingAction != null) {
                moduleContext.getLogger().warning(String.format("Action [%s] has been redeclared!\n", actionId));
                actionMap.remove(actionId);
                this.actionList.remove(existingAction);
            }
            actionMap.put(actionId, action);
        }
    }

    private void registerActionGroups(ModuleContext moduleContext) {
        this.actionGroupList = BeamCoreActivator.loadExecutableExtensions((ModuleContext)moduleContext, (String)"actionGroups", (String)"actionGroup", CommandGroup.class);
        HashMap<String, CommandGroup> actionGroupMap = new HashMap<String, CommandGroup>(2 * this.actionGroupList.size() + 1);
        for (CommandGroup actionGroup : new ArrayList<CommandGroup>(this.actionGroupList)) {
            String actionGroupId = actionGroup.getCommandID();
            CommandGroup existingActionGroup = (CommandGroup)actionGroupMap.get(actionGroupId);
            if (existingActionGroup != null) {
                moduleContext.getLogger().warning(String.format("Action group [%s] has been redeclared!\n", actionGroupId));
                actionGroupMap.remove(actionGroupId);
                this.actionGroupList.remove(existingActionGroup);
            }
            actionGroupMap.put(actionGroupId, actionGroup);
        }
    }

    private void registerLayerEditors(ModuleContext moduleContext) {
        BeamCoreActivator.loadExecutableExtensions((ModuleContext)moduleContext, (String)"layerEditors", (String)"layerEditor", LayerEditorDescriptor.class);
    }

    private void registerLayerSources(ModuleContext moduleContext) {
        List layerSourceListDescriptor = BeamCoreActivator.loadExecutableExtensions((ModuleContext)moduleContext, (String)"layerSources", (String)"layerSource", LayerSourceDescriptor.class);
        this.layerSourcesRegistry = new HashMap<String, LayerSourceDescriptor>(2 * layerSourceListDescriptor.size());
        for (LayerSourceDescriptor layerSourceDescriptor : layerSourceListDescriptor) {
            String id = layerSourceDescriptor.getId();
            LayerSourceDescriptor existingLayerSourceDescriptor = this.layerSourcesRegistry.get(id);
            if (existingLayerSourceDescriptor != null) {
                moduleContext.getLogger().info(String.format("Layer source [%s] has been redeclared!\n", id));
            }
            this.layerSourcesRegistry.put(id, layerSourceDescriptor);
        }
    }

    private void registerHelpSets(ModuleContext moduleContext) {
        Extension[] hsExtensions;
        this.helpSetRegistry = new TreeNode("");
        ExtensionPoint hsExtensionPoint = moduleContext.getModule().getExtensionPoint("helpSets");
        for (Extension extension : hsExtensions = hsExtensionPoint.getExtensions()) {
            ConfigurationElement[] helpSetElements;
            ConfigurationElement confElem = extension.getConfigurationElement();
            for (ConfigurationElement helpSetElement : helpSetElements = (ConfigurationElement[])confElem.getChildren("helpSet")) {
                Module declaringModule = extension.getDeclaringModule();
                if (!declaringModule.getState().is(ModuleState.RESOLVED)) continue;
                this.registerHelpSet(helpSetElement, declaringModule);
            }
        }
        this.addNodeToHelpSys(this.helpSetRegistry);
    }

    private void addNodeToHelpSys(TreeNode<HelpSet> helpSetNode) {
        TreeNode[] children;
        if (helpSetNode.getContent() != null) {
            HelpSys.add((HelpSet)helpSetNode.getContent());
        }
        for (TreeNode child : children = helpSetNode.getChildren()) {
            this.addNodeToHelpSys((TreeNode<HelpSet>)child);
        }
    }

    private void registerHelpSet(ConfigurationElement helpSetElement, Module declaringModule) {
        String helpSetId;
        String helpSetPath = null;
        ConfigurationElement pathElem = (ConfigurationElement)helpSetElement.getChild("path");
        if (pathElem != null) {
            helpSetPath = pathElem.getValue();
        }
        if (helpSetPath == null) {
            helpSetPath = helpSetElement.getAttribute("path");
        }
        if (helpSetPath == null) {
            String message = String.format("Missing resource [path] element in a help set declared in module [%s].", declaringModule.getName());
            this.moduleContext.getLogger().severe(message);
            return;
        }
        URL helpSetUrl = declaringModule.getClassLoader().getResource(helpSetPath);
        if (helpSetUrl == null) {
            String message = String.format("Help set resource path [%s] of module [%s] not found.", helpSetPath, declaringModule.getName());
            this.moduleContext.getLogger().severe(message);
            return;
        }
        VerifyingHelpSetFactory factory = new VerifyingHelpSetFactory(helpSetPath, declaringModule.getName(), this.moduleContext.getLogger());
        HelpSet helpSet = HelpSet.parse((URL)helpSetUrl, (ClassLoader)declaringModule.getClassLoader(), (HelpSetFactory)factory);
        if (helpSet == null) {
            String message = String.format("Failed to add help set [%s] of module [%s]: %s.", helpSetPath, declaringModule.getName(), "");
            this.moduleContext.getLogger().log(Level.SEVERE, message, "");
            return;
        }
        ConfigurationElement idElem = (ConfigurationElement)helpSetElement.getChild("id");
        if (idElem != null) {
            helpSetId = idElem.getValue();
        } else {
            helpSetId = "helpSet$" + this.helpSetNo;
            ++this.helpSetNo;
            String message = String.format("Missing [id] element in help set [%s] of module [%s].", helpSetPath, declaringModule.getSymbolicName());
            this.moduleContext.getLogger().warning(message);
        }
        ConfigurationElement parentElem = (ConfigurationElement)helpSetElement.getChild("parent");
        String helpSetParent = parentElem != null ? parentElem.getValue() : "";
        TreeNode parentNode = this.helpSetRegistry.createChild(helpSetParent);
        TreeNode childNode = parentNode.getChild(helpSetId);
        if (childNode == null) {
            childNode = new TreeNode(helpSetId, (Object)helpSet);
            parentNode.addChild(childNode);
        } else if (childNode.getContent() == null) {
            childNode.setContent((Object)helpSet);
        } else {
            String message = String.format("Help set ignored: Duplicate identifier [%s] in help set [%s] of module [%s] ignored.", helpSetId, helpSetPath, declaringModule.getName());
            this.moduleContext.getLogger().severe(message);
        }
    }

    private static class VerifyingHelpSetFactory
    extends HelpSet.DefaultHelpSetFactory {
        private final String helpSetPath;
        private final String moduleName;
        private final Logger logger;

        public VerifyingHelpSetFactory(String helpSetPath, String moduleName, Logger logger) {
            this.helpSetPath = helpSetPath;
            this.moduleName = moduleName;
            this.logger = logger;
        }

        public void processView(HelpSet hs, String name, String label, String type, Hashtable viewAttributes, String data, Hashtable dataAttributes, Locale locale) {
            if (name.equals("Search")) {
                try {
                    QueryEngine qe = new QueryEngine(data, hs.getHelpSetURL());
                }
                catch (Exception exception) {
                    String message = String.format("Help set [%s] of module [%s] has no or bad search index. Search view removed.", this.helpSetPath, this.moduleName);
                    this.logger.log(Level.SEVERE, message, "");
                    return;
                }
            }
            super.processView(hs, name, label, type, viewAttributes, data, dataAttributes, locale);
        }
    }
}

