/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.help;

import java.awt.Component;
import java.awt.Window;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import org.esa.beam.util.Guardian;

public class HelpSys {
    private static DefaultHelpBroker helpBroker;

    public static void add(HelpSet helpSet) {
        if (!HelpSys.isInitialized()) {
            HelpSys.set(helpSet);
            return;
        }
        HelpSet set = helpBroker.getHelpSet();
        if (set == null) {
            helpBroker.setHelpSet(helpSet);
            return;
        }
        set.add(helpSet);
    }

    public static HelpBroker getHelpBroker() {
        return helpBroker;
    }

    public static HelpSet getHelpSet() {
        if (HelpSys.isInitialized()) {
            return helpBroker.getHelpSet();
        }
        return null;
    }

    public static boolean enableHelp(Component component, String helpId) {
        Guardian.assertNotNull((String)"component", (Object)component);
        Guardian.assertNotNull((String)"helpId", (Object)helpId);
        if (HelpSys.getHelpSet() == null || !HelpSys.isValidID(helpId)) {
            return false;
        }
        HelpSys.getHelpBroker().enableHelp(component, helpId, HelpSys.getHelpSet());
        return true;
    }

    public static boolean enableHelpKey(Component component, String helpId) {
        Guardian.assertNotNull((String)"component", (Object)component);
        Guardian.assertNotNull((String)"helpId", (Object)helpId);
        if (HelpSys.getHelpSet() == null || !HelpSys.isValidID(helpId)) {
            return false;
        }
        HelpSys.getHelpBroker().enableHelpKey(component, helpId, HelpSys.getHelpSet());
        return true;
    }

    public static boolean enableHelpOnButton(Component component, String helpId) {
        Guardian.assertNotNull((String)"component", (Object)component);
        if (HelpSys.getHelpSet() == null || !HelpSys.isValidID(helpId)) {
            return false;
        }
        if (helpId == null || helpId.length() == 0) {
            return false;
        }
        HelpSys.getHelpBroker().enableHelpOnButton(component, helpId, HelpSys.getHelpSet());
        return true;
    }

    public static boolean isValidID(String id) {
        if (HelpSys.getHelpSet() == null || id == null) {
            return false;
        }
        return HelpSys.getHelpSet().getCombinedMap().isValidID(id, HelpSys.getHelpSet());
    }

    public static void showTheme(String helpId) {
        if (HelpSys.isInitialized()) {
            helpBroker.setCurrentID(helpId);
            helpBroker.setDisplayed(true);
        }
    }

    public static boolean isInitialized() {
        return HelpSys.getHelpBroker() != null;
    }

    public static void dispose() {
        if (HelpSys.isInitialized()) {
            Window helpWindow = helpBroker.getWindowPresentation().getHelpWindow();
            if (helpWindow != null) {
                helpWindow.dispose();
            }
            helpBroker = null;
        }
    }

    private static void set(HelpSet helpSet) {
        if (helpBroker == null) {
            helpBroker = new DefaultHelpBroker(helpSet);
        }
        helpBroker.setHelpSet(helpSet);
    }
}

