/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param.editors;

import java.io.IOException;
import javax.swing.JOptionPane;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.param.ParamProperties;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.framework.param.editors.TextFieldXEditor;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.product.ProductExpressionPane;
import org.esa.beam.util.PropertyMap;

public abstract class AbstractExpressionEditor
extends TextFieldXEditor {
    public static final String PROPERTY_KEY_SELECTED_PRODUCT = "selectedProduct";
    public static final String PROPERTY_KEY_INPUT_PRODUCTS = "inputProducts";
    public static final String PROPERTY_KEY_PREFERENCES = "preferences";

    protected AbstractExpressionEditor(Parameter parameter) {
        super(parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeXEditor() {
        Product[] productArray;
        P p;
        ParamProperties paramProperties = this.getParameter().getProperties();
        try {
            UIUtils.setRootFrameWaitCursor(this.getEditorComponent());
            p = this.getSelectedProduct(paramProperties);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.getEditorComponent(), "Failed to invoke expression editor:\n" + e.getMessage(), "Expression Editor", 0);
            return;
        }
        finally {
            UIUtils.setRootFrameDefaultCursor(this.getEditorComponent());
        }
        if (p == null) {
            JOptionPane.showMessageDialog(this.getEditorComponent(), "Failed to invoke expression editor:\nNo input product selected.", "Expression Editor", 0);
            return;
        }
        Product[] sourceProducts = AbstractExpressionEditor.getInputProducts(paramProperties);
        PropertyMap preferences = AbstractExpressionEditor.getPreferences(paramProperties);
        if (sourceProducts != null) {
            productArray = sourceProducts;
        } else {
            Product[] productArray2 = new Product[1];
            productArray = productArray2;
            productArray2[0] = p.product;
        }
        ProductExpressionPane exprPane = this.createProductExpressionPane(productArray, p.product, preferences);
        exprPane.setCode(this.getParameterExprValue());
        if (exprPane.showModalDialog(null, "Expression Editor") == 1) {
            this.setParameterExprValue(exprPane.getCode());
        }
        if (p.mustDispose) {
            p.product.dispose();
        }
        p.product = null;
    }

    private static PropertyMap getPreferences(ParamProperties paramProperties) {
        Object propertyValue = paramProperties.getPropertyValue(PROPERTY_KEY_PREFERENCES);
        if (propertyValue == null) {
            return null;
        }
        if (!(propertyValue instanceof PropertyMap)) {
            throw new IllegalStateException("parameter property 'preferences' is not instanceof PropertyMap");
        }
        return (PropertyMap)propertyValue;
    }

    private P getSelectedProduct(ParamProperties paramProperties) throws IOException {
        Object propertyValue = paramProperties.getPropertyValue(PROPERTY_KEY_SELECTED_PRODUCT);
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue instanceof Product) {
            return new P((Product)propertyValue, false);
        }
        if (propertyValue instanceof String) {
            return new P(this.openProduct((String)propertyValue), true);
        }
        throw new IllegalStateException("parameter property 'selectedProduct' has an illegal type");
    }

    private static Product[] getInputProducts(ParamProperties paramProperties) {
        Object propertyValue = paramProperties.getPropertyValue(PROPERTY_KEY_INPUT_PRODUCTS);
        if (propertyValue == null) {
            return null;
        }
        if (!(propertyValue instanceof Product[])) {
            throw new IllegalStateException("parameter property 'inputProducts' is not instanceof Product[]");
        }
        Product[] inputProducts = (Product[])propertyValue;
        if (inputProducts.length == 0) {
            throw new IllegalStateException("parameter property 'inputProducts' is an empty Product[]");
        }
        return inputProducts;
    }

    Product openProduct(String path) throws IOException {
        return ProductIO.readProduct((String)path);
    }

    protected abstract ProductExpressionPane createProductExpressionPane(Product[] var1, Product var2, PropertyMap var3);

    private String getParameterExprValue() {
        return (String)this.getParameter().getValue();
    }

    private void setParameterExprValue(String value) {
        this.getParameter().setValue((Object)value, null);
    }

    private static class P {
        private Product product;
        private boolean mustDispose;

        public P(Product product, boolean mustClose) {
            this.product = product;
            this.mustDispose = mustClose;
        }
    }
}

