/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import com.bc.ceres.core.Assert;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.Scaling;
import org.esa.beam.framework.datamodel.Stx;
import org.esa.beam.framework.ui.ImageInfoEditorModel;

public abstract class AbstractImageInfoEditorModel
implements ImageInfoEditorModel {
    private final ImageInfo imageInfo;
    private final EventListenerList listenerList;
    private Scaling scaling;
    private Stx stx;
    private String name;
    private String unit;
    private Double histogramViewGain;
    private Double minHistogramViewSample;
    private Double maxHistogramViewSample;

    protected AbstractImageInfoEditorModel(ImageInfo imageInfo) {
        this.imageInfo = imageInfo;
        this.listenerList = new EventListenerList();
    }

    @Override
    public ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    @Override
    public void setDisplayProperties(String name, String unit, Stx stx, Scaling scaling) {
        this.setParameterName(name);
        this.setParameterUnit(unit);
        this.setSampleScaling(scaling);
        this.setSampleStx(stx);
        this.fireStateChanged();
    }

    @Override
    public String getParameterName() {
        return this.name;
    }

    private void setParameterName(String name) {
        this.name = name;
    }

    @Override
    public String getParameterUnit() {
        return this.unit;
    }

    private void setParameterUnit(String unit) {
        this.unit = unit;
    }

    @Override
    public Scaling getSampleScaling() {
        return this.scaling;
    }

    @Override
    public void setSampleScaling(Scaling scaling) {
        Assert.notNull((Object)scaling, (String)"scaling");
        this.scaling = scaling;
    }

    @Override
    public Stx getSampleStx() {
        return this.stx;
    }

    private void setSampleStx(Stx stx) {
        Assert.notNull((Object)stx, (String)"stx");
        this.stx = stx;
    }

    @Override
    public double getMinSample() {
        return this.scaling == null ? 0.0 : this.stx.getMinimum();
    }

    @Override
    public double getMaxSample() {
        return this.scaling == null ? 0.0 : this.stx.getMaximum();
    }

    @Override
    public boolean isHistogramAvailable() {
        return this.getHistogramBins() != null && this.getHistogramBins().length > 0;
    }

    @Override
    public int[] getHistogramBins() {
        return this.stx == null ? null : this.stx.getHistogramBins();
    }

    @Override
    public double getMinHistogramViewSample() {
        if (this.minHistogramViewSample != null) {
            return this.minHistogramViewSample;
        }
        return this.getMinSample();
    }

    @Override
    public void setMinHistogramViewSample(double minViewSample) {
        this.minHistogramViewSample = minViewSample;
    }

    @Override
    public double getMaxHistogramViewSample() {
        if (this.maxHistogramViewSample != null) {
            return this.maxHistogramViewSample;
        }
        return this.getMaxSample();
    }

    @Override
    public void setMaxHistogramViewSample(double maxViewSample) {
        this.maxHistogramViewSample = maxViewSample;
    }

    @Override
    public double getHistogramViewGain() {
        if (this.histogramViewGain != null) {
            return this.histogramViewGain;
        }
        return 1.0;
    }

    @Override
    public void setHistogramViewGain(double gain) {
        this.histogramViewGain = gain;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    @Override
    public void fireStateChanged() {
        ChangeListener[] changeListeners;
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener changeListener : changeListeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(event);
        }
    }
}

