/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.debug.CheckThreadViolationRepaintManager;
import com.bc.ceres.swing.debug.EventDispatchThreadHangMonitor;
import com.jidesoft.action.CommandBar;
import com.jidesoft.action.DefaultDockableBarDockableHolder;
import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.action.event.DockableBarAdapter;
import com.jidesoft.action.event.DockableBarEvent;
import com.jidesoft.action.event.DockableBarListener;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.status.LabelStatusBarItem;
import com.jidesoft.status.StatusBar;
import com.jidesoft.swing.FolderChooser;
import com.jidesoft.swing.JideMenu;
import com.jidesoft.swing.LayoutPersistence;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FontUIResource;
import org.esa.beam.framework.help.HelpSys;
import org.esa.beam.framework.ui.FileHistory;
import org.esa.beam.framework.ui.SuppressibleOptionPane;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.application.ApplicationDescriptor;
import org.esa.beam.framework.ui.application.support.DefaultApplicationDescriptor;
import org.esa.beam.framework.ui.command.Command;
import org.esa.beam.framework.ui.command.CommandGroup;
import org.esa.beam.framework.ui.command.CommandManager;
import org.esa.beam.framework.ui.command.CommandMenuInserter;
import org.esa.beam.framework.ui.command.CommandUIFactory;
import org.esa.beam.framework.ui.command.DefaultCommandManager;
import org.esa.beam.framework.ui.command.DefaultCommandMenuInserter;
import org.esa.beam.framework.ui.command.DefaultCommandUIFactory;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.io.BeamFileChooser;
import org.esa.beam.util.io.FileChooserFactory;
import org.esa.beam.util.io.FileUtils;
import org.esa.beam.util.logging.BeamLogManager;

public class BasicApp {
    public static final String PROPERTY_KEY_APP_LAST_OPEN_DIR = "app.file.lastOpenDir";
    public static final String PROPERTY_KEY_APP_LAST_OPEN_FORMAT = "app.file.lastOpenFormat";
    public static final String PROPERTY_KEY_APP_LAST_SAVE_DIR = "app.file.lastSaveDir";
    public static final String PROPERTY_KEY_APP_LOG_ENABLED = "app.log.enabled";
    public static final String PROPERTY_KEY_APP_LOG_PREFIX = "app.log.prefix";
    public static final String PROPERTY_KEY_APP_LOG_LEVEL = "app.log.level";
    public static final String PROPERTY_KEY_APP_LOG_ECHO = "app.log.echo";
    public static final String PROPERTY_KEY_APP_DEBUG_ENABLED = "app.debug.enabled";
    public static final String PROPERTY_KEY_APP_UI_LAF = "app.ui.laf";
    public static final String PROPERTY_KEY_APP_UI_FONT_NAME = "app.ui.font.name";
    public static final String PROPERTY_KEY_APP_UI_FONT_SIZE = "app.ui.font.size";
    public static final String PROPERTY_KEY_APP_UI_USE_SYSTEM_FONT_SETTINGS = "app.ui.useSystemFontSettings";
    private static final String _IMAGE_RESOURCE_PATH = "/org/esa/beam/resources/images/";
    protected boolean uiDefaultsInitialized;
    private final ApplicationDescriptor applicationDescriptor;
    private File preferencesFile;
    private CommandManager commandManager;
    private CommandUIFactory commandUIFactory;
    private CommandMenuInserter commandMenuInserter;
    private MainFrame mainFrame;
    private CommandBar mainToolBar;
    private StatusBar statusBar;
    private PropertyMap preferences;
    private SuppressibleOptionPane suppressibleOptionPane;
    private FileHistory fileHistory;
    private boolean debugEnabled;
    private MouseListener mouseOverActionHandler;
    private ResourceBundle resourceBundle;
    private boolean startedUp;
    private boolean startingUp;
    private boolean _shuttingDown;
    private ContainerListener popupMenuListener;
    private Logger logger;
    private ActionListener closeHandler;
    private Map<String, CommandBar> toolBars;
    private boolean unexpectedShutdown;
    public static final String MESSAGE_STATUS_BAR_ITEM_KEY = "Message";
    public static final String POSITION_STATUS_BAR_ITEM_KEY = "Position";
    private File beamUserDir;
    private File appUserDir;
    private boolean frameBoundsRestored;

    public BasicApp(ApplicationDescriptor applicationDescriptor) {
        Assert.notNull((Object)applicationDescriptor, (String)"applicationDescriptor");
        this.applicationDescriptor = applicationDescriptor;
        if (applicationDescriptor.getSymbolicName() != null) {
            // empty if block
        }
        this.fileHistory = new FileHistory(10, "recent.files");
        this.mouseOverActionHandler = new MouseOverActionHandler();
        this.closeHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicApp.this.shutDown();
            }
        };
        this.toolBars = new HashMap<String, CommandBar>();
    }

    protected BasicApp(String appName, String appSymbolicName, String appVersion, String appCopyrightInfo, String appResource, String appLoggerName) {
        this(BasicApp.createApplicationDescriptor(appName, appSymbolicName, appVersion, appCopyrightInfo, appResource, appLoggerName));
    }

    public ApplicationDescriptor getApplicationDescriptor() {
        return this.applicationDescriptor;
    }

    public MouseListener getMouseOverActionHandler() {
        return this.mouseOverActionHandler;
    }

    public boolean isFrameBoundsRestored() {
        return this.frameBoundsRestored;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public CommandBar getMainToolBar() {
        return this.mainToolBar;
    }

    public File getPreferencesFile() {
        return this.preferencesFile;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean isStartedUp() {
        return this.startedUp;
    }

    public boolean isShuttingDown() {
        return this._shuttingDown;
    }

    protected void setShuttingDown(boolean shuttingDown) {
        this._shuttingDown = shuttingDown;
    }

    public void startUp(ProgressMonitor pm) throws Exception {
        if (this.startedUp || this.startingUp) {
            throw new IllegalStateException("startUp");
        }
        this.startingUp = true;
        try {
            pm.beginTask("Starting " + this.getAppName(), 6);
            pm.setSubTaskName("Loading preferences...");
            this.initLogger();
            this.initBeamUserDir();
            this.initResources();
            this.initPreferences();
            this.logStartUpInfo();
            pm.worked(1);
            if (Boolean.getBoolean("beam.swing.debug")) {
                RepaintManager.setCurrentManager((RepaintManager)new CheckThreadViolationRepaintManager());
                EventDispatchThreadHangMonitor.initMonitoring();
            }
            pm.setSubTaskName("Creating main frame...");
            this.initCommandManager();
            this.initMainFrame();
            this.initShutdownHook();
            this.initLookAndFeel();
            this.configureLayoutPersitence();
            this.configureDockingManager();
            pm.worked(1);
            this.initClient(SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            pm.setSubTaskName("Initialising UI components...");
            this.configureCommandsByResourceBundle();
            this.initMainMenuBar();
            this.initMainToolBar();
            this.initMainPane();
            this.initStatusBar();
            this.initFrameIcon();
            pm.worked(1);
            this.initClientUI(SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            pm.setSubTaskName("Applying UI preferences...");
            this.applyPreferences();
            this.loadLayout();
            this.clearStatusBarMessage();
            pm.worked(1);
        }
        finally {
            pm.done();
        }
        try {
            this.getMainFrame().setVisible(true);
            this.updateState();
        }
        finally {
            this.startedUp = true;
            this.startingUp = false;
        }
    }

    protected void loadLayout() {
        this.getMainFrame().getLayoutPersistence().loadLayoutData();
    }

    private void logStartUpInfo() {
        this.logger.info(this.getApplicationDescriptor().getDisplayName() + " user directory is '" + this.beamUserDir + "'");
        if (this.resourceBundle != null) {
            this.logger.info("Resource bundle loaded from '" + this.applicationDescriptor.getResourceBundleName() + "'");
        }
        if (this.preferencesFile != null) {
            this.logger.info("User preferences loaded from '" + this.preferencesFile.getPath() + "'");
        }
    }

    private void initFrameIcon() {
        List<Image> imageIcons = this.createFrameIcons();
        if (imageIcons != null) {
            this.getMainFrame().setIconImages(imageIcons);
        }
    }

    private void initStatusBar() {
        this.statusBar = this.createStatusBar();
        if (this.statusBar != null) {
            this.getMainFrame().getContentPane().add("South", (Component)this.statusBar);
        }
    }

    private void initMainPane() {
        JComponent mainPane = this.createMainPane();
        if (mainPane != null) {
            this.getMainFrame().getDockingManager().getWorkspace().setLayout((LayoutManager)new BorderLayout());
            this.getMainFrame().getDockingManager().getWorkspace().add((Component)mainPane, (Object)"Center");
            this.getMainFrame().getDockingManager().setDefaultFocusComponent((Component)mainPane);
        }
    }

    private void initMainMenuBar() {
        CommandBar menuBar = this.createMainMenuBar();
        if (menuBar != null) {
            menuBar.getContext().setInitSide(1);
            menuBar.getContext().setInitIndex(1);
            this.getMainFrame().getDockableBarManager().addDockableBar((DockableBar)menuBar);
            this.insertCommandMenuItems();
        }
    }

    private void initMainToolBar() {
        this.mainToolBar = this.createMainToolBar();
        if (this.mainToolBar != null) {
            this.mainToolBar.getContext().setInitSide(1);
            this.mainToolBar.getContext().setInitIndex(2);
            this.getMainFrame().getDockableBarManager().addDockableBar((DockableBar)this.mainToolBar);
        }
    }

    private void configureDockingManager() {
        this.getMainFrame().getDockingManager().setProfileKey(this.getAppName());
        this.getMainFrame().getDockingManager().setInitBounds(new Rectangle(0, 0, 960, 800));
        this.getMainFrame().getDockingManager().setInitSplitPriority(1);
        this.getMainFrame().getDockingManager().setInitDelay(100);
        this.getMainFrame().getDockingManager().setSteps(1);
        this.getMainFrame().getDockingManager().setStepDelay(0);
        this.getMainFrame().getDockingManager().setUndoLimit(0);
        this.getMainFrame().getDockingManager().setFloatable(true);
        this.getMainFrame().getDockingManager().setShowGripper(false);
        this.getMainFrame().getDockingManager().setDragGripperOnly(false);
        this.getMainFrame().getDockingManager().setContinuousLayout(true);
        this.getMainFrame().getDockingManager().setAutoDockingAsDefault(false);
        this.getMainFrame().getDockingManager().setHideFloatingFramesWhenDeactivate(true);
        this.getMainFrame().getDockingManager().setHideFloatingFramesOnSwitchOutOfApplication(true);
        this.getMainFrame().getDockingManager().setOutlineMode(2);
    }

    private void configureLayoutPersitence() {
        this.getMainFrame().getLayoutPersistence().setProfileKey(this.getAppName());
        this.getMainFrame().getLayoutPersistence().setUsePref(false);
        this.getMainFrame().getLayoutPersistence().setLayoutDirectory(this.appUserDir.getPath());
        this.getMainFrame().getLayoutPersistence().beginLoadLayoutData();
        this.getMainFrame().getDockableBarManager().setProfileKey(this.getAppName());
    }

    private void initCommandManager() {
        this.commandManager = new DefaultCommandManager();
        this.commandUIFactory = new DefaultCommandUIFactory();
        this.commandUIFactory.setCommandManager(this.commandManager);
        this.commandMenuInserter = new DefaultCommandMenuInserter(this.commandManager);
    }

    private void initMainFrame() {
        this.mainFrame = new MainFrame();
        this.mainFrame.setTitle(this.getMainFrameTitle());
        this.mainFrame.setName("mainFrame" + this.getAppName());
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Debug.trace((String)"BasicApp: application main frame is closing, calling exit handler...");
                BasicApp.this.closeHandler.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "close"));
            }
        });
    }

    public String getAppCopyright() {
        return this.applicationDescriptor.getCopyright();
    }

    private void initLogger() {
        this.logger = BeamLogManager.getSystemLogger();
    }

    protected boolean initLookAndFeel() {
        try {
            UIManager.installLookAndFeel("Napkin", "net.sourceforge.napkinlaf.NapkinLookAndFeel");
        }
        catch (Throwable e) {
            // empty catch block
        }
        String currentLafClassName = UIManager.getLookAndFeel().getClass().getName();
        String defaultLafClassName = this.getDefaultLookAndFeelClassName();
        String newLafClassName = this.getPreferences().getPropertyString(PROPERTY_KEY_APP_UI_LAF, defaultLafClassName);
        if (newLafClassName.equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) {
            newLafClassName = defaultLafClassName;
        }
        if (!this.uiDefaultsInitialized || !currentLafClassName.equals(newLafClassName)) {
            try {
                UIManager.setLookAndFeel(newLafClassName);
                this.getPreferences().setPropertyString(PROPERTY_KEY_APP_UI_LAF, newLafClassName);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            try {
                this.loadJideExtension();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    protected void loadJideExtension() {
        LookAndFeelFactory.installJideExtension((int)4);
    }

    protected String getDefaultLookAndFeelClassName() {
        String defaultLookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
        String osName = System.getProperty("os.name").toLowerCase();
        if (!SystemUtils.isRunningOnMacOS() && !osName.contains("windows")) {
            UIManager.LookAndFeelInfo[] lookAndFeels;
            for (UIManager.LookAndFeelInfo laf : lookAndFeels = UIManager.getInstalledLookAndFeels()) {
                if (!"nimbus".equalsIgnoreCase(laf.getName())) continue;
                defaultLookAndFeelClassName = laf.getClassName();
            }
        }
        return defaultLookAndFeelClassName;
    }

    protected void handleImminentExit() {
        Debug.trace((String)(this.getAppName() + ": handleImminentExit entered"));
        if (!this.unexpectedShutdown) {
            Debug.trace((String)"(1)");
            LayoutPersistence layoutPersistence = this.getMainFrame().getLayoutPersistence();
            if (layoutPersistence != null) {
                layoutPersistence.saveLayoutData();
            }
        }
        Debug.trace((String)"(2)");
        this.savePreferences();
        Debug.trace((String)"(3)");
        HelpSys.dispose();
        Debug.trace((String)(this.getAppName() + ": handleImminentExit exited"));
    }

    private void initShutdownHook() {
        Thread shutdownHook = new Thread(this.getAppName() + " shut-down hook"){

            @Override
            public void run() {
                if (BasicApp.this.isStartedUp() && !BasicApp.this.isShuttingDown()) {
                    BasicApp.this.unexpectedShutdown = true;
                    BasicApp.this.logger.severe("Unexpectedly shutting down " + BasicApp.this.getAppName());
                    BasicApp.this.handleImminentExit();
                } else {
                    BasicApp.this.logger.severe("Nominally shutting down " + BasicApp.this.getAppName());
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    protected CommandBar createMainToolBar() {
        return null;
    }

    protected JComponent createMainPane() {
        return new JPanel();
    }

    protected CommandBar createMainMenuBar() {
        return null;
    }

    protected StatusBar createStatusBar() {
        return null;
    }

    protected List<Image> createFrameIcons() {
        String paths = this.applicationDescriptor.getFrameIconPaths();
        if (paths == null) {
            return null;
        }
        String[] pathParts = paths.split(",");
        ArrayList<Image> images = new ArrayList<Image>(pathParts.length);
        for (String pathPart : pathParts) {
            pathPart = pathPart.trim();
            URL iconURL = this.getClass().getResource(pathPart);
            if (iconURL == null) {
                BeamLogManager.getSystemLogger().severe("Missing icon resource: " + pathPart);
                continue;
            }
            images.add(new ImageIcon(iconURL).getImage());
        }
        return images;
    }

    protected void initClient(ProgressMonitor pm) throws Exception {
    }

    protected void initClientUI(ProgressMonitor pm) throws Exception {
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    protected CommandBar createToolBar(String toolBarId, String title) {
        CommandBar toolBar = new CommandBar(toolBarId);
        toolBar.setName(toolBarId);
        toolBar.setTitle(title);
        toolBar.addDockableBarListener((DockableBarListener)new ToolBarListener());
        this.toolBars.put(toolBarId, toolBar);
        return toolBar;
    }

    public CommandBar getToolBar(String toolBarId) {
        return this.toolBars.get(toolBarId);
    }

    public boolean isToolBarVisible(String toolBarId) {
        DockableBarManager barManager = this.getMainFrame().getDockableBarManager();
        if (barManager != null) {
            DockableBar dockableBar = barManager.getDockableBar(toolBarId);
            return dockableBar != null && !dockableBar.isHidden();
        }
        return false;
    }

    public void setToolBarVisible(String toolBarId, boolean visbile) {
        DockableBarManager dockableBarManager = this.getMainFrame().getDockableBarManager();
        if (visbile) {
            dockableBarManager.showDockableBar(toolBarId);
        } else {
            dockableBarManager.hideDockableBar(toolBarId);
        }
    }

    public boolean isStatusBarVisible() {
        return this.statusBar != null && this.statusBar.isVisible();
    }

    public void setStatusBarVisible(boolean visible) {
        if (this.statusBar != null) {
            this.statusBar.setVisible(visible);
        }
    }

    public String getAppName() {
        return this.applicationDescriptor.getDisplayName();
    }

    public String getAppSymbolicName() {
        return this.applicationDescriptor.getSymbolicName();
    }

    public String getAppVersion() {
        return this.applicationDescriptor.getVersion();
    }

    public String getAppBuildInfo() {
        String buildId = this.applicationDescriptor.getBuildId();
        String buildDate = this.applicationDescriptor.getBuildDate();
        if (buildId != null && buildDate != null) {
            return String.format("build %s from %s", buildId, buildDate);
        }
        if (buildId != null) {
            return String.format("build %s", buildId);
        }
        if (buildDate != null) {
            return String.format("from %s", buildDate);
        }
        return "no build info";
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public String getImageResourcePath() {
        return _IMAGE_RESOURCE_PATH;
    }

    private LabelStatusBarItem getStatusBarLabel() {
        if (this.statusBar != null) {
            return (LabelStatusBarItem)this.statusBar.getItemByName(MESSAGE_STATUS_BAR_ITEM_KEY);
        }
        return null;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public void setCommandManager(CommandManager commandManager) {
        Guardian.assertNotNull((String)"commandManager", (Object)commandManager);
        this.commandManager = commandManager;
        this.commandUIFactory.setCommandManager(commandManager);
    }

    public CommandUIFactory getCommandUIFactory() {
        return this.commandUIFactory;
    }

    public final void updateState() {
        Debug.trace((String)"BasicApp: updating application state...");
        this.commandManager.updateState();
    }

    public final void setStatusBarMessage(String message) {
        LabelStatusBarItem label = this.getStatusBarLabel();
        if (label != null && message != null) {
            label.setText(message);
        }
    }

    public void clearStatusBarMessage() {
        this.setStatusBarMessage("Ready.");
    }

    public final String getStatusBarMessage() {
        LabelStatusBarItem label = this.getStatusBarLabel();
        if (label != null) {
            return label.getText();
        }
        return null;
    }

    public final JMenu findMainMenu(String name) {
        return this.findMenu(name, false);
    }

    public final JMenu findMenu(String name) {
        return this.findMenu(name, true);
    }

    public final String[] getToolBarGroups() {
        return new String[]{"file", "edit", "view", null, "tools", "help"};
    }

    protected final void insertCommandToolBarButtons(JToolBar toolbar) {
        String[] toolBarGroups = this.getToolBarGroups();
        if (toolBarGroups == null) {
            return;
        }
        boolean toolAdded = false;
        for (String toolBarGroup : toolBarGroups) {
            if (toolAdded) {
                toolbar.addSeparator();
                toolAdded = false;
            }
            for (int j = 0; j < this.commandManager.getNumCommands(); ++j) {
                String rootParent;
                Command command = this.commandManager.getCommandAt(j);
                if (!(command instanceof ExecCommand) || command.getLargeIcon() == null || ((rootParent = this.findRootParent(command)) != null || toolBarGroup != null) && (rootParent == null || !rootParent.equalsIgnoreCase(toolBarGroup))) continue;
                AbstractButton button = command.createToolBarButton();
                if (button != null) {
                    toolbar.add(button);
                }
                toolAdded = true;
            }
        }
    }

    private String findRootParent(Command command) {
        CommandGroup commandGroup;
        String parent = command.getParent();
        if (parent != null && (commandGroup = this.commandManager.getCommandGroup(parent)) != null) {
            return this.findRootParent(commandGroup);
        }
        return parent;
    }

    protected void insertCommandMenuItems() {
        for (int i = 0; i < this.commandManager.getNumCommands(); ++i) {
            this.insertCommandMenuItem(this.commandManager.getCommandAt(i));
        }
    }

    protected final void configureCommandsByResourceBundle() {
        ResourceBundle resourceBundle = this.getResourceBundle();
        if (resourceBundle == null) {
            return;
        }
        for (int i = 0; i < this.commandManager.getNumCommands(); ++i) {
            this.commandManager.getCommandAt(i).configure(resourceBundle);
        }
    }

    protected final void insertCommandMenuItem(Command command) {
        JMenu menu = null;
        String parent = command.getParent();
        if (parent != null) {
            menu = this.findMenu(parent);
        }
        if (menu == null) {
            menu = this.createNewMenu(parent);
        }
        if (menu != null) {
            this.commandMenuInserter.insertCommandIntoMenu(command, menu);
        }
    }

    protected JMenu createNewMenu(String parent) {
        if (parent == null) {
            return this.findMenu("tools");
        }
        JMenuBar menuBar = this.getMainFrame().getJMenuBar();
        JMenu newMenu = this.createJMenu(parent, parent, parent.charAt(0), new String[0]);
        int index = UIUtils.findMenuPosition(menuBar, "window");
        menuBar.add((Component)newMenu, index);
        return newMenu;
    }

    protected final JMenu findMenu(String name, boolean deepSearch) {
        JMenuBar menuBar = this.getMainFrame().getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        return UIUtils.findMenu(menuBar, name, deepSearch);
    }

    protected final JMenu createJMenu(String name, String text, char mnemonic, String ... cmdIds) {
        JideMenu menu = new JideMenu();
        menu.setName(name);
        menu.setText(text);
        menu.setMnemonic(mnemonic);
        menu.getPopupMenu().addContainerListener(this.getOrCreatePopupMenuListener());
        for (String cmdId : cmdIds) {
            Command command = this.commandManager.getCommand(cmdId);
            if (command == null) continue;
            menu.getPopupMenu().add(command.createMenuItem());
        }
        return menu;
    }

    private ContainerListener getOrCreatePopupMenuListener() {
        if (this.popupMenuListener == null) {
            this.popupMenuListener = new ContainerListener(){

                @Override
                public void componentAdded(ContainerEvent e) {
                    Component component = e.getChild();
                    component.addMouseListener(BasicApp.this.getMouseOverActionHandler());
                }

                @Override
                public void componentRemoved(ContainerEvent e) {
                    Component component = e.getChild();
                    component.removeMouseListener(BasicApp.this.getMouseOverActionHandler());
                }
            };
        }
        return this.popupMenuListener;
    }

    public void shutDown() {
        this.setShuttingDown(true);
        this.handleImminentExit();
        this.getMainFrame().dispose();
        System.exit(0);
    }

    protected final void loadPreferences() {
        if (this.preferencesFile == null) {
            return;
        }
        try {
            this.getPreferences().load(this.preferencesFile);
        }
        catch (IOException ignored) {
            this.logger.warning("Failed to load user preferences from " + this.preferencesFile);
            this.logger.warning("Using application default values...");
        }
    }

    public final void savePreferences() {
        if (this.preferencesFile == null) {
            return;
        }
        this.setPreferences();
        try {
            this.logger.info("Storing user preferences in '" + this.preferencesFile.getPath() + "'...");
            this.getPreferences().store(this.preferencesFile, this.getAppName() + " " + this.getAppVersion() + " - User preferences file");
            this.logger.info("User preferences stored");
        }
        catch (IOException ignored) {
            this.logger.warning("Failed to store user preferences");
        }
    }

    protected final void setPreferences() {
        this.fileHistory.copyInto(this.getPreferences());
        this.getPreferences().setPropertyInt("frame.location.x", this.getMainFrame().getLocation().x);
        this.getPreferences().setPropertyInt("frame.location.y", this.getMainFrame().getLocation().y);
        this.getPreferences().setPropertyInt("frame.size.width", this.getMainFrame().getSize().width);
        this.getPreferences().setPropertyInt("frame.size.height", this.getMainFrame().getSize().height);
        this.getPreferences().setPropertyBool("frame.ui.dblbuf", RepaintManager.currentManager((Component)((Object)this.getMainFrame())).isDoubleBufferingEnabled());
        this.getPreferences().setPropertyBool(PROPERTY_KEY_APP_DEBUG_ENABLED, this.debugEnabled);
    }

    protected void applyPreferences() {
        this.logger.info("Applying user preferences...");
        int x = this.getPreferences().getPropertyInt("frame.location.x", -1);
        int y = this.getPreferences().getPropertyInt("frame.location.y", -1);
        int width = this.getPreferences().getPropertyInt("frame.size.width", 0);
        int height = this.getPreferences().getPropertyInt("frame.size.height", 0);
        this.frameBoundsRestored = false;
        if (x >= 0 && y >= 0 && width > 0 && height > 0) {
            this.getMainFrame().setBounds(x, y, width, height);
            this.frameBoundsRestored = true;
        }
        Boolean bV = this.getPreferences().getPropertyBool("view.showToolBar", Boolean.TRUE);
        ExecCommand command = this.commandManager.getExecCommand("showToolBar");
        if (command != null) {
            command.setSelected(bV);
        }
        bV = this.getPreferences().getPropertyBool("view.showStatusBar", Boolean.TRUE);
        command = this.commandManager.getExecCommand("showStatusBar");
        if (command != null) {
            command.setSelected(bV);
        }
        this.fileHistory.initBy(this.getPreferences());
        bV = this.getPreferences().getPropertyBool(PROPERTY_KEY_APP_DEBUG_ENABLED, Boolean.FALSE);
        this.debugEnabled = bV;
        if (this.debugEnabled) {
            Debug.setEnabled((boolean)true);
        }
        this.applyLookAndFeelPreferences();
        this.logger.info("User preferences applied");
    }

    protected final void applyLookAndFeelPreferences() {
        boolean useSystemFontSettings;
        boolean startingUp;
        boolean bl = startingUp = !this.isStartedUp();
        if (startingUp && this.uiDefaultsInitialized) {
            return;
        }
        boolean mustUpdateComponentTreeUI = this.initLookAndFeel();
        UIDefaults uiDefaults = UIManager.getLookAndFeel().getDefaults();
        boolean currentUseSystemFontSettings = uiDefaults.getBoolean("Application.useSystemFontSettings");
        if (currentUseSystemFontSettings != (useSystemFontSettings = this.getPreferences().getPropertyBool(PROPERTY_KEY_APP_UI_USE_SYSTEM_FONT_SETTINGS, currentUseSystemFontSettings))) {
            uiDefaults.put("Application.useSystemFontSettings", (Object)useSystemFontSettings);
            mustUpdateComponentTreeUI = true;
        }
        if (!useSystemFontSettings) {
            Font currentMenuFont = uiDefaults.getFont("Menu.font");
            String fontName = this.getPreferences().getPropertyString(PROPERTY_KEY_APP_UI_FONT_NAME, currentMenuFont.getName());
            int fontSize = this.getPreferences().getPropertyInt(PROPERTY_KEY_APP_UI_FONT_SIZE, currentMenuFont.getSize());
            if (!currentMenuFont.getName().equalsIgnoreCase(fontName) || currentMenuFont.getSize() != fontSize) {
                this.changeUIDefaultsFonts(uiDefaults, fontName, fontSize);
                mustUpdateComponentTreeUI = true;
            }
        }
        if (mustUpdateComponentTreeUI && this.getMainFrame().isVisible()) {
            this.updateComponentTreeUI();
        }
        this.uiDefaultsInitialized = true;
    }

    private void changeUIDefaultsFonts(UIDefaults uiDefaults, String fontName, int fontSize) {
        String[] smallFontKeys = new String[]{"ToolTip.font", "Menu.acceleratorFont", "MenuItem.acceleratorFont", "CheckBoxMenuItem.acceleratorFont", "RadioButtonMenuItem.acceleratorFont"};
        String[] plainFontKeys = new String[]{"ToolBar.font", "MenuBar.font", "Menu.font", "MenuItem.font", "CheckBoxMenuItem.font", "RadioButtonMenuItem.font", "PopupMenu.font", "ComboBox.font", "List.font", "Tree.font", "Table.font", "TableHeader.font", "Button.font", "ToggleButton.font", "RadioButton.font", "Panel.font", "ScrollPane.font", "Viewport.font", "TabbedPane.font", "ProgressBar.font", "Spinner.font", "TitledBorder.font", "Label.font", "CheckBox.font", "EditorPane.font", "TextPane.font", "TextField.font", "FormattedTextField.font", "PasswordField.font", "TextArea.font", "FileChooser.listFont", "ColorChooser.font", "OptionPane.font", "OptionPane.buttonFont", "OptionPane.messageFont"};
        FontUIResource plainFont = new FontUIResource(new Font(fontName, 0, fontSize));
        for (String plainFontKey : plainFontKeys) {
            uiDefaults.put(plainFontKey, plainFont);
        }
        FontUIResource smallFont = new FontUIResource(plainFont.deriveFont(0.8f * (float)fontSize));
        for (String smallFontKey : smallFontKeys) {
            uiDefaults.put(smallFontKey, smallFont);
        }
    }

    protected void updateComponentTreeUI() {
        this.mainFrame.getDockableBarManager().updateComponentTreeUI();
        this.mainFrame.getDockingManager().updateComponentTreeUI();
        SwingUtilities.updateComponentTreeUI((Component)((Object)this.getMainFrame()));
    }

    public final void setCurrentDocTitle(String currentDocTitle) {
        String mainFrameTitle = this.getMainFrameTitle();
        if (!StringUtils.isNullOrEmpty((String)currentDocTitle)) {
            this.getMainFrame().setTitle(currentDocTitle + " - " + mainFrameTitle);
        } else {
            this.getMainFrame().setTitle(mainFrameTitle);
        }
    }

    public final void center() {
        UIUtils.centerComponent((Component)((Object)this.getMainFrame()));
    }

    public final File showFileOpenDialog(String title, boolean dirsOnly, FileFilter fileFilter) {
        return this.showFileOpenDialog(title, dirsOnly, fileFilter, PROPERTY_KEY_APP_LAST_OPEN_DIR);
    }

    public final File showFileOpenDialog(String title, boolean dirsOnly, FileFilter fileFilter, String lastDirPropertyKey) {
        String lastDirPath;
        Assert.notNull((Object)lastDirPropertyKey, (String)"lastDirPropertyKey");
        Assert.argument((!lastDirPropertyKey.isEmpty() ? 1 : 0) != 0, (String)"!lastDirPropertyKey.isEmpty()");
        String lastDir = this.getPreferences().getPropertyString(lastDirPropertyKey, SystemUtils.getUserHomeDir().getPath());
        File currentDir = new File(lastDir);
        BeamFileChooser fileChooser = new BeamFileChooser();
        fileChooser.setCurrentDirectory(currentDir);
        if (fileFilter != null) {
            fileChooser.setFileFilter(fileFilter);
        }
        fileChooser.setDialogTitle(this.getAppName() + " - " + title);
        fileChooser.setFileSelectionMode(dirsOnly ? 1 : 0);
        int result = fileChooser.showOpenDialog((Component)((Object)this.getMainFrame()));
        if (fileChooser.getCurrentDirectory() != null && (lastDirPath = fileChooser.getCurrentDirectory().getAbsolutePath()) != null) {
            this.getPreferences().setPropertyString(lastDirPropertyKey, lastDirPath);
        }
        if (result == 0) {
            File file = fileChooser.getSelectedFile();
            if (file == null || file.getName().equals("")) {
                return null;
            }
            file = file.getAbsoluteFile();
            return file;
        }
        return null;
    }

    public final File showFileSaveDialog(String title, boolean dirsOnly, FileFilter fileFilter, String defaultExtension, String fileName) {
        return this.showFileSaveDialog(title, dirsOnly, fileFilter, defaultExtension, fileName, PROPERTY_KEY_APP_LAST_SAVE_DIR);
    }

    public final File showFileSaveDialog(String title, boolean dirsOnly, FileFilter fileFilter, String defaultExtension, String fileName, String lastDirPropertyKey) {
        File file = null;
        while (file == null) {
            file = this.showFileSaveDialogImpl(title, dirsOnly, fileFilter, defaultExtension, fileName, lastDirPropertyKey);
            if (file == null) {
                return null;
            }
            if (!file.exists()) continue;
            int status = JOptionPane.showConfirmDialog((Component)((Object)this.getMainFrame()), MessageFormat.format("The file ''{0}'' already exists.\nOverwrite it?", file), MessageFormat.format("{0} - {1}", this.getAppName(), title), 1, 2);
            if (status == 2) {
                return null;
            }
            if (status != 1) continue;
            file = null;
        }
        return file;
    }

    private File showFileSaveDialogImpl(String title, boolean dirsOnly, FileFilter fileFilter, String defaultExtension, String fileName, String lastDirPropertyKey) {
        String lastDirPath;
        Assert.notNull((Object)lastDirPropertyKey, (String)"lastDirPropertyKey");
        Assert.argument((!lastDirPropertyKey.isEmpty() ? 1 : 0) != 0, (String)"!lastDirPropertyKey.isEmpty()");
        String lastDir = this.getPreferences().getPropertyString(lastDirPropertyKey, SystemUtils.getUserHomeDir().getPath());
        File currentDir = new File(lastDir);
        BeamFileChooser fileChooser = new BeamFileChooser();
        fileChooser.setCurrentDirectory(currentDir);
        if (fileFilter != null) {
            fileChooser.setFileFilter(fileFilter);
        }
        if (fileName != null) {
            fileChooser.setSelectedFile(new File(FileUtils.exchangeExtension((String)fileName, (String)defaultExtension)));
        }
        fileChooser.setDialogTitle(this.getAppName() + " - " + title);
        fileChooser.setFileSelectionMode(dirsOnly ? 1 : 0);
        int result = fileChooser.showSaveDialog((Component)((Object)this.getMainFrame()));
        if (fileChooser.getCurrentDirectory() != null && (lastDirPath = fileChooser.getCurrentDirectory().getAbsolutePath()) != null) {
            this.getPreferences().setPropertyString(lastDirPropertyKey, lastDirPath);
        }
        if (result == 0) {
            File file = fileChooser.getSelectedFile();
            if (file == null || file.getName().equals("")) {
                return null;
            }
            String absolutePath = file.getAbsolutePath();
            if (defaultExtension != null && !absolutePath.toLowerCase().endsWith(defaultExtension.toLowerCase())) {
                absolutePath = absolutePath.concat(defaultExtension);
            }
            file = new File(absolutePath);
            return file;
        }
        return null;
    }

    protected void historyPush(File file) {
        this.fileHistory.push(file.getAbsolutePath());
    }

    public final synchronized void registerJob(Object job) {
    }

    public final synchronized void unregisterJob(Object job) {
    }

    public final void handleUnknownException(Throwable e) {
        Debug.trace((Throwable)e);
        String message = e == null ? "An unknown error occurred." : (e.getMessage() == null ? "An exception occurred:\n   Type: " + e.getClass().getName() + "\n" + "   No message text available." : "An exception occurred:\n   Type: " + e.getClass().getName() + "\n" + "   Message: " + e.getMessage());
        this.getMainFrame().setCursor(Cursor.getDefaultCursor());
        this.setStatusBarMessage("Error.");
        this.logger.log(Level.SEVERE, message, e);
        this.showErrorDialog("Error", message);
        this.clearStatusBarMessage();
    }

    public final SuppressibleOptionPane getSuppressibleOptionPane() {
        return this.suppressibleOptionPane;
    }

    public final void showErrorDialog(String message) {
        this.showErrorDialog("Error", message);
    }

    public final void showErrorDialog(String title, String message) {
        this.showMessageDialog(title, message, 0, null);
    }

    public final void showWarningDialog(String message) {
        this.showMessageDialog("Warning", message, 2, null);
    }

    public final void showWarningDialog(String title, String message) {
        this.showMessageDialog(title, message, 2, null);
    }

    public final void showInfoDialog(String message, String preferencesKey) {
        this.showInfoDialog("Information", message, preferencesKey);
    }

    public final void showInfoDialog(String title, String message, String preferencesKey) {
        this.showMessageDialog(title, message, 1, preferencesKey);
    }

    public final void showOutOfMemoryErrorDialog(String message) {
        this.showErrorDialog("Out of Memory", String.format("%s is out of memory.\n%s\n\nYou can try to release memory by closing products or image views which\nyou currently not really need.\nIf this does not help, you can increase the amount of virtual memory\nas described on the BEAM website at http://envisat.esa.int/services/beam/.", this.getAppName(), message));
    }

    public final void showMessageDialog(String title, String message, int messageType, String preferencesKey) {
        if (this.suppressibleOptionPane != null && !StringUtils.isNullOrEmpty((String)preferencesKey)) {
            this.suppressibleOptionPane.showMessageDialog(preferencesKey, (Component)((Object)this.getMainFrame()), message, this.getAppName() + " - " + title, messageType);
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this.getMainFrame()), message, this.getAppName() + " - " + title, messageType);
        }
    }

    public final int showQuestionDialog(String message, String preferencesKey) {
        return this.showQuestionDialog("Question", message, preferencesKey);
    }

    public final int showQuestionDialog(String title, String message, String preferencesKey) {
        return this.showQuestionDialog(title, message, false, preferencesKey);
    }

    public final int showQuestionDialog(String title, String message, boolean allowCancel, String preferencesKey) {
        if (this.suppressibleOptionPane != null && !StringUtils.isNullOrEmpty((String)preferencesKey)) {
            return this.suppressibleOptionPane.showConfirmDialog(preferencesKey, (Component)((Object)this.getMainFrame()), message, this.getAppName() + " - " + title, allowCancel ? 1 : 0, 3);
        }
        return JOptionPane.showConfirmDialog((Component)((Object)this.getMainFrame()), message, this.getAppName() + " - " + title, allowCancel ? 1 : 0, 3);
    }

    public final void showWarningsDialog(String message, String[] warnings) {
        if (warnings != null && warnings.length > 0) {
            JPanel messagePanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weightx = 1.0;
            String[] messageStrings = StringUtils.toStringArray((String)message, (String)"\n");
            for (int i = 0; i < messageStrings.length; ++i) {
                gbc.gridy = i + 1;
                messagePanel.add((Component)new JLabel(messageStrings[i]), gbc);
            }
            JTextArea ta = new JTextArea();
            for (String warning : warnings) {
                ta.append(warning + "\n");
            }
            final JScrollPane details = new JScrollPane(ta);
            details.setPreferredSize(new Dimension(400, 150));
            details.setVisible(false);
            final JButton detailsButton = new JButton();
            detailsButton.setText("Show Details");
            detailsButton.setMnemonic('S');
            detailsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    details.setVisible(!details.isVisible());
                    if (details.isVisible()) {
                        detailsButton.setText("Hide Details");
                        detailsButton.setMnemonic('H');
                    } else {
                        detailsButton.setText("Show Details");
                        detailsButton.setMnemonic('S');
                    }
                    Window windowAncestor = SwingUtilities.getWindowAncestor(detailsButton);
                    if (windowAncestor != null) {
                        windowAncestor.pack();
                    }
                }
            });
            JPanel buttonPanel = new JPanel(new BorderLayout());
            buttonPanel.add((Component)detailsButton, "East");
            JPanel messageMainPanel = new JPanel(new BorderLayout(0, 5));
            messageMainPanel.add((Component)messagePanel, "North");
            messageMainPanel.add((Component)buttonPanel, "Center");
            messageMainPanel.add((Component)details, "South");
            JOptionPane.showMessageDialog((Component)((Object)this.getMainFrame()), messageMainPanel, "Warning", 2);
        } else {
            this.showWarningDialog(message);
        }
    }

    public final boolean promptForOverwrite(File file) {
        Guardian.assertNotNull((String)"file", (Object)file);
        if (!file.exists()) {
            return true;
        }
        int answer = this.showQuestionDialog("File Exists", "The file\n'" + file.getPath() + "'\n" + "already exists.\n\n" + "Do you really want to overwrite it?\n", null);
        return answer == 0;
    }

    public final PropertyMap getPreferences() {
        return this.preferences;
    }

    public final FileHistory getFileHistory() {
        return this.fileHistory;
    }

    public ActionListener getCloseHandler() {
        return this.closeHandler;
    }

    public void setCloseHandler(ActionListener closeHandler) {
        Guardian.assertNotNull((String)"closeHandler", (Object)closeHandler);
        this.closeHandler = closeHandler;
    }

    protected String getMainFrameTitle() {
        return this.getAppName() + " " + this.getAppVersion();
    }

    public final void addHelp(ClassLoader classLoader, String helpsetResourcePath) {
        Guardian.assertNotNull((String)"classLoader", (Object)classLoader);
        Guardian.assertNotNullOrEmpty((String)"helpsetResourcePath", (String)helpsetResourcePath);
        URL url = HelpSet.findHelpSet((ClassLoader)classLoader, (String)helpsetResourcePath);
        if (url == null) {
            this.getLogger().log(Level.SEVERE, "Helpset not found: " + helpsetResourcePath);
            return;
        }
        try {
            HelpSet helpSet = new HelpSet(classLoader, url);
            HelpSys.add(helpSet);
        }
        catch (HelpSetException e) {
            this.getLogger().log(Level.SEVERE, "Helpset could not be added: " + helpsetResourcePath, e);
        }
    }

    private void initBeamUserDir() throws IOException {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            throw new IllegalStateException("Java system property 'user.home' not set");
        }
        this.beamUserDir = SystemUtils.getApplicationDataDir((boolean)true);
        this.appUserDir = new File(this.beamUserDir, this.getAppSymbolicName());
        if (!this.appUserDir.exists() && !this.appUserDir.mkdir()) {
            throw new IOException("Failed to create directory '" + this.appUserDir + "'.");
        }
    }

    private void initResources() throws MissingResourceException {
        this.resourceBundle = this.applicationDescriptor.getResourceBundleName() != null ? ResourceBundle.getBundle(this.applicationDescriptor.getResourceBundleName(), Locale.getDefault(), this.getClass().getClassLoader()) : null;
    }

    private void initPreferences() {
        this.preferences = new PropertyMap();
        this.preferences.setPropertyBool(PROPERTY_KEY_APP_DEBUG_ENABLED, false);
        this.preferences.setPropertyString(PROPERTY_KEY_APP_UI_FONT_NAME, "SansSerif");
        this.preferences.setPropertyInt(PROPERTY_KEY_APP_UI_FONT_SIZE, 12);
        this.preferences.setPropertyBool(PROPERTY_KEY_APP_LOG_ENABLED, false);
        this.preferences.setPropertyString(PROPERTY_KEY_APP_LOG_PREFIX, this.getAppName());
        this.preferences.setPropertyString(PROPERTY_KEY_APP_LOG_LEVEL, "INFO");
        this.preferences.setPropertyBool(PROPERTY_KEY_APP_LOG_ECHO, false);
        this.preferencesFile = new File(this.appUserDir, "preferences.properties");
        this.loadPreferences();
        this.suppressibleOptionPane = new SuppressibleOptionPane(this.getPreferences());
    }

    private static ApplicationDescriptor createApplicationDescriptor(String appName, String appSymbolicName, String appVersion, String appCopyrightInfo, String appResource, String appLoggerName) {
        DefaultApplicationDescriptor applicationDescriptor = new DefaultApplicationDescriptor();
        applicationDescriptor.setDisplayName(appName);
        applicationDescriptor.setSymbolicName(appSymbolicName);
        applicationDescriptor.setVersion(appVersion);
        applicationDescriptor.setCopyright(appCopyrightInfo);
        applicationDescriptor.setResourceBundleName(appResource);
        applicationDescriptor.setLoggerName(appLoggerName);
        return applicationDescriptor;
    }

    static {
        FileChooserFactory.getInstance().setDirChooserClass(FolderChooser.class);
    }

    public class ToolBarListener
    extends DockableBarAdapter {
        public void dockableBarHidden(DockableBarEvent dockableBarEvent) {
            BasicApp.this.updateState();
        }
    }

    public static class MainFrame
    extends DefaultDockableBarDockableHolder {
    }

    final class MouseOverActionHandler
    extends MouseAdapter {
        private String _oldMessage;

        MouseOverActionHandler() {
        }

        @Override
        public final void mouseEntered(MouseEvent evt) {
            String message;
            AbstractButton button;
            Action action;
            if (evt.getSource() instanceof AbstractButton && (action = (button = (AbstractButton)evt.getSource()).getAction()) != null && (message = (String)action.getValue("ShortDescription")) != null && message.length() > 0) {
                this._oldMessage = BasicApp.this.getStatusBarMessage();
                BasicApp.this.setStatusBarMessage(message);
            }
        }

        @Override
        public final void mouseExited(MouseEvent evt) {
            AbstractButton button;
            Action action;
            if (evt.getSource() instanceof AbstractButton && (action = (button = (AbstractButton)evt.getSource()).getAction()) != null) {
                BasicApp.this.setStatusBarMessage(this._oldMessage != null ? this._oldMessage : " ");
            }
        }
    }
}

