/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import com.bc.ceres.glayer.swing.LayerCanvas;
import com.bc.ceres.grender.Rendering;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.ui.WorldMapPane;
import org.esa.beam.framework.ui.WorldMapPaneDataModel;

public abstract class BoundaryOverlay
implements LayerCanvas.Overlay {
    private final WorldMapPaneDataModel dataModel;
    private LayerCanvas layerCanvas;

    protected BoundaryOverlay(WorldMapPaneDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public void paintOverlay(LayerCanvas canvas, Rendering rendering) {
        this.layerCanvas = canvas;
        for (GeoPos[] extraGeoBoundary : this.dataModel.getAdditionalGeoBoundaries()) {
            this.drawGeoBoundary(rendering.getGraphics(), extraGeoBoundary, false, null, null);
        }
        Product selectedProduct = this.dataModel.getSelectedProduct();
        for (Product product : this.dataModel.getProducts()) {
            if (selectedProduct == product) continue;
            this.drawProduct(rendering.getGraphics(), product, false);
        }
        this.handleSelectedProduct(rendering, selectedProduct);
    }

    protected abstract void handleSelectedProduct(Rendering var1, Product var2);

    protected void drawProduct(Graphics2D g2d, Product product, boolean isCurrent) {
        GeoCoding geoCoding = product.getGeoCoding();
        if (geoCoding == null) {
            return;
        }
        GeneralPath[] boundaryPaths = WorldMapPane.getGeoBoundaryPaths(product);
        String text = String.valueOf(product.getRefNo());
        PixelPos textCenter = this.getProductCenter(product);
        this.drawGeoBoundary(g2d, boundaryPaths, isCurrent, text, textCenter);
    }

    private void drawGeoBoundary(Graphics2D g2d, GeneralPath[] boundaryPaths, boolean isCurrent, String text, PixelPos textCenter) {
        AffineTransform transform = this.layerCanvas.getViewport().getModelToViewTransform();
        for (GeneralPath boundaryPath : boundaryPaths) {
            boundaryPath.transform(transform);
            this.drawPath(isCurrent, g2d, boundaryPath, 0.0f);
        }
        this.drawText(g2d, text, textCenter, 0.0f);
    }

    private void drawGeoBoundary(Graphics2D g2d, GeoPos[] geoBoundary, boolean isCurrent, String text, PixelPos textCenter) {
        GeneralPath gp = this.convertToPixelPath(geoBoundary);
        this.drawPath(isCurrent, g2d, gp, 0.0f);
        this.drawText(g2d, text, textCenter, 0.0f);
    }

    private void drawPath(boolean isCurrent, Graphics2D g2d, GeneralPath gp, float offsetX) {
        g2d = this.prepareGraphics2D(offsetX, g2d);
        if (isCurrent) {
            g2d.setColor(new Color(255, 200, 200, 30));
        } else {
            g2d.setColor(new Color(255, 255, 255, 30));
        }
        g2d.fill(gp);
        if (isCurrent) {
            g2d.setColor(new Color(255, 0, 0));
        } else {
            g2d.setColor(Color.WHITE);
        }
        g2d.draw(gp);
    }

    private GeneralPath convertToPixelPath(GeoPos[] geoBoundary) {
        GeneralPath gp = new GeneralPath();
        for (int i = 0; i < geoBoundary.length; ++i) {
            GeoPos geoPos = geoBoundary[i];
            AffineTransform m2vTransform = this.layerCanvas.getViewport().getModelToViewTransform();
            Point2D viewPos = m2vTransform.transform(new Point2D.Double(geoPos.lon, geoPos.lat), null);
            if (i == 0) {
                gp.moveTo(viewPos.getX(), viewPos.getY());
                continue;
            }
            gp.lineTo(viewPos.getX(), viewPos.getY());
        }
        gp.closePath();
        return gp;
    }

    private void drawText(Graphics2D g2d, String text, PixelPos textCenter, float offsetX) {
        if (text == null || textCenter == null) {
            return;
        }
        g2d = this.prepareGraphics2D(offsetX, g2d);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Color color = g2d.getColor();
        g2d.setColor(Color.black);
        g2d.drawString(text, textCenter.x - (float)fontMetrics.stringWidth(text) / 2.0f, textCenter.y + (float)fontMetrics.getAscent() / 2.0f);
        g2d.setColor(color);
    }

    private Graphics2D prepareGraphics2D(float offsetX, Graphics2D g2d) {
        if (offsetX != 0.0f) {
            g2d = (Graphics2D)g2d.create();
            AffineTransform transform = g2d.getTransform();
            AffineTransform offsetTrans = new AffineTransform();
            offsetTrans.setToTranslation(offsetX, 0.0);
            transform.concatenate(offsetTrans);
            g2d.setTransform(transform);
        }
        return g2d;
    }

    private PixelPos getProductCenter(Product product) {
        GeoCoding geoCoding = product.getGeoCoding();
        PixelPos centerPos = null;
        if (geoCoding != null) {
            float pixelX = (float)Math.floor(0.5f * (float)product.getSceneRasterWidth()) + 0.5f;
            float pixelY = (float)Math.floor(0.5f * (float)product.getSceneRasterHeight()) + 0.5f;
            GeoPos geoPos = geoCoding.getGeoPos(new PixelPos(pixelX, pixelY), null);
            AffineTransform transform = this.layerCanvas.getViewport().getModelToViewTransform();
            Point2D point2D = transform.transform(new Point2D.Double(geoPos.getLon(), geoPos.getLat()), null);
            centerPos = new PixelPos((float)point2D.getX(), (float)point2D.getY());
        }
        return centerPos;
    }
}

